/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.solution.director;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.drools.ClassObjectFilter;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.calculator.ScoreCalculator;
import org.drools.planner.core.score.constraint.ConstraintOccurrence;
import org.drools.planner.core.score.constraint.DoubleConstraintOccurrence;
import org.drools.planner.core.score.constraint.IntConstraintOccurrence;
import org.drools.planner.core.score.constraint.UnweightedConstraintOccurrence;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solution.director.SolutionDirector;
import org.drools.runtime.ObjectFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSolutionDirector
implements SolutionDirector {
    public static final String GLOBAL_SCORE_CALCULATOR_KEY = "scoreCalculator";
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SolutionDescriptor solutionDescriptor;
    protected RuleBase ruleBase;
    protected ScoreDefinition scoreDefinition;
    protected Solution workingSolution;
    protected StatefulSession workingMemory;
    protected ScoreCalculator workingScoreCalculator;
    protected long calculateCount;

    public SolutionDescriptor getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public void setSolutionDescriptor(SolutionDescriptor solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
    }

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public void setRuleBase(RuleBase ruleBase) {
        this.ruleBase = ruleBase;
    }

    public ScoreDefinition getScoreDefinition() {
        return this.scoreDefinition;
    }

    public void setScoreDefinition(ScoreDefinition scoreDefinition) {
        this.scoreDefinition = scoreDefinition;
        this.workingScoreCalculator = scoreDefinition.buildScoreCalculator();
    }

    @Override
    public Solution getWorkingSolution() {
        return this.workingSolution;
    }

    public void setWorkingSolution(Solution workingSolution) {
        this.workingSolution = workingSolution;
        this.resetWorkingMemory();
    }

    @Override
    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public long getCalculateCount() {
        return this.calculateCount;
    }

    public void resetCalculateCount() {
        this.calculateCount = 0L;
    }

    private void resetWorkingMemory() {
        if (this.workingMemory != null) {
            this.workingMemory.dispose();
        }
        this.workingMemory = this.ruleBase.newStatefulSession();
        this.workingMemory.setGlobal(GLOBAL_SCORE_CALCULATOR_KEY, (Object)this.workingScoreCalculator);
        for (Object fact : this.getWorkingFacts()) {
            this.workingMemory.insert(fact);
        }
    }

    public Collection<Object> getWorkingFacts() {
        return this.solutionDescriptor.getAllFacts(this.workingSolution);
    }

    public List<Object> getWorkingPlanningEntityList() {
        return this.solutionDescriptor.getPlanningEntityList(this.workingSolution);
    }

    public boolean isWorkingSolutionInitialized() {
        return this.solutionDescriptor.isInitialized(this.workingSolution);
    }

    @Override
    public Score calculateScoreFromWorkingMemory() {
        this.workingMemory.fireAllRules();
        Score score = this.workingScoreCalculator.calculateScore();
        this.workingSolution.setScore(score);
        ++this.calculateCount;
        return score;
    }

    public void assertWorkingScore(Score presumedScore) {
        StatefulSession tmpWorkingMemory = this.ruleBase.newStatefulSession();
        ScoreCalculator tmpScoreCalculator = this.workingScoreCalculator.clone();
        tmpWorkingMemory.setGlobal(GLOBAL_SCORE_CALCULATOR_KEY, (Object)tmpScoreCalculator);
        for (Object fact : this.getWorkingFacts()) {
            tmpWorkingMemory.insert(fact);
        }
        tmpWorkingMemory.fireAllRules();
        Score realScore = tmpScoreCalculator.calculateScore();
        tmpWorkingMemory.dispose();
        if (!presumedScore.equals(realScore)) {
            throw new IllegalStateException("The presumedScore (" + presumedScore + ") is corrupted because it is not the realScore  (" + realScore + ").\n" + "Presumed workingMemory:\n" + this.buildConstraintOccurrenceSummary((WorkingMemory)this.workingMemory) + "Real workingMemory:\n" + this.buildConstraintOccurrenceSummary((WorkingMemory)tmpWorkingMemory));
        }
    }

    public String buildConstraintOccurrenceSummary() {
        return this.buildConstraintOccurrenceSummary((WorkingMemory)this.workingMemory);
    }

    public String buildConstraintOccurrenceSummary(WorkingMemory summaryWorkingMemory) {
        this.logger.trace("Building ConstraintOccurrence summary");
        if (summaryWorkingMemory == null) {
            return "  The workingMemory is null.";
        }
        TreeMap<String, SummaryLine> summaryLineMap = new TreeMap<String, SummaryLine>();
        Iterator it = summaryWorkingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(ConstraintOccurrence.class));
        while (it.hasNext()) {
            ConstraintOccurrence occurrence = (ConstraintOccurrence)it.next();
            this.logger.trace("    Adding ConstraintOccurrence ({})", (Object)occurrence);
            SummaryLine summaryLine = (SummaryLine)summaryLineMap.get(occurrence.getRuleId());
            if (summaryLine == null) {
                summaryLine = new SummaryLine();
                summaryLineMap.put(occurrence.getRuleId(), summaryLine);
            }
            summaryLine.increment();
            if (occurrence instanceof IntConstraintOccurrence) {
                summaryLine.addWeight(((IntConstraintOccurrence)occurrence).getWeight());
                continue;
            }
            if (occurrence instanceof DoubleConstraintOccurrence) {
                summaryLine.addWeight(((DoubleConstraintOccurrence)occurrence).getWeight());
                continue;
            }
            if (occurrence instanceof UnweightedConstraintOccurrence) {
                summaryLine.addWeight(1);
                continue;
            }
            throw new IllegalStateException("Cannot determine occurrenceScore of ConstraintOccurrence class: " + occurrence.getClass());
        }
        StringBuilder summary = new StringBuilder();
        for (Map.Entry summaryLineEntry : summaryLineMap.entrySet()) {
            SummaryLine summaryLine = (SummaryLine)summaryLineEntry.getValue();
            summary.append("  Score rule (").append((String)summaryLineEntry.getKey()).append(") has count (").append(summaryLine.getCount()).append(") and weight total (").append(summaryLine.getWeightTotal()).append(").\n");
        }
        return summary.toString();
    }

    private static class SummaryLine {
        private int count = 0;
        private Number weightTotal = null;

        private SummaryLine() {
        }

        public int getCount() {
            return this.count;
        }

        public Number getWeightTotal() {
            return this.weightTotal;
        }

        public void increment() {
            ++this.count;
        }

        public void addWeight(Integer weight) {
            if (this.weightTotal == null) {
                this.weightTotal = 0;
            }
            this.weightTotal = (Integer)this.weightTotal + weight;
        }

        public void addWeight(Double weight) {
            if (this.weightTotal == null) {
                this.weightTotal = 0.0;
            }
            this.weightTotal = (Double)this.weightTotal + weight;
        }
    }
}

