/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.statistic.memoryuse;

import java.util.ArrayList;
import java.util.List;
import org.drools.planner.benchmark.statistic.memoryuse.MemoryUseMeasurement;
import org.drools.planner.benchmark.statistic.memoryuse.MemoryUseStatisticPoint;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListenerAdapter;
import org.drools.planner.core.phase.step.AbstractStepScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryUseStatisticListener
extends SolverPhaseLifecycleListenerAdapter {
    private long timeMillisThresholdInterval;
    private long nextTimeMillisThreshold;
    private List<MemoryUseStatisticPoint> statisticPointList = new ArrayList<MemoryUseStatisticPoint>();

    public MemoryUseStatisticListener() {
        this(1000L);
    }

    public MemoryUseStatisticListener(long timeMillisThresholdInterval) {
        if (timeMillisThresholdInterval <= 0L) {
            throw new IllegalArgumentException("The timeMillisThresholdInterval (" + timeMillisThresholdInterval + ") must be bigger than 0.");
        }
        this.timeMillisThresholdInterval = timeMillisThresholdInterval;
        this.nextTimeMillisThreshold = timeMillisThresholdInterval;
    }

    public List<MemoryUseStatisticPoint> getStatisticPointList() {
        return this.statisticPointList;
    }

    @Override
    public void stepTaken(AbstractStepScope stepScope) {
        long timeMillisSpend = stepScope.getSolverPhaseScope().calculateSolverTimeMillisSpend();
        if (timeMillisSpend >= this.nextTimeMillisThreshold) {
            this.statisticPointList.add(new MemoryUseStatisticPoint(timeMillisSpend, MemoryUseMeasurement.create()));
            this.nextTimeMillisThreshold += this.timeMillisThresholdInterval;
            if (this.nextTimeMillisThreshold < timeMillisSpend) {
                this.nextTimeMillisThreshold = timeMillisSpend;
            }
        }
    }
}

