/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.examination.solver.selector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.Decider;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.TabuPropertyEnabled;
import org.drools.planner.core.localsearch.decider.selector.AbstractSelector;
import org.drools.planner.core.move.Move;
import org.drools.planner.examples.examination.domain.Exam;
import org.drools.planner.examples.examination.domain.Examination;
import org.drools.planner.examples.examination.solver.move.factory.ExamSwitchMoveFactory;
import org.drools.planner.examples.examination.solver.move.factory.PeriodChangeMoveFactory;
import org.drools.planner.examples.examination.solver.move.factory.RoomChangeMoveFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllMovesOfOneExamSelector
extends AbstractSelector {
    protected PeriodChangeMoveFactory periodChangeMoveFactory = new PeriodChangeMoveFactory();
    protected RoomChangeMoveFactory roomChangeMoveFactory = new RoomChangeMoveFactory();
    protected ExamSwitchMoveFactory examSwitchMoveFactory = new ExamSwitchMoveFactory();
    protected Map<Exam, List<Move>> cachedExamToMoveMap;
    protected List<Exam> shuffledExamList;
    protected int nextShuffledExamListIndex;

    @Override
    public void setDecider(Decider decider) {
        super.setDecider(decider);
        this.periodChangeMoveFactory.setDecider(decider);
        this.roomChangeMoveFactory.setDecider(decider);
        this.examSwitchMoveFactory.setDecider(decider);
    }

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.periodChangeMoveFactory.phaseStarted(localSearchSolverPhaseScope);
        this.roomChangeMoveFactory.phaseStarted(localSearchSolverPhaseScope);
        this.examSwitchMoveFactory.phaseStarted(localSearchSolverPhaseScope);
        this.createCachedExamToMoveMap(localSearchSolverPhaseScope);
    }

    private void createCachedExamToMoveMap(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        Examination examination = (Examination)localSearchSolverPhaseScope.getWorkingSolution();
        int examListSize = examination.getExamList().size();
        List<Move> cachedPeriodChangeMoveList = this.periodChangeMoveFactory.getCachedMoveList();
        List<Move> cachedRoomChangeMoveList = this.roomChangeMoveFactory.getCachedMoveList();
        List<Move> cachedExamSwitchMoveList = this.examSwitchMoveFactory.getCachedMoveList();
        this.cachedExamToMoveMap = new HashMap<Exam, List<Move>>(cachedPeriodChangeMoveList.size() + cachedRoomChangeMoveList.size() + cachedExamSwitchMoveList.size());
        this.addToCachedExamToMoveMap(examListSize, cachedPeriodChangeMoveList);
        this.addToCachedExamToMoveMap(examListSize, cachedRoomChangeMoveList);
        this.addToCachedExamToMoveMap(examListSize, cachedExamSwitchMoveList);
        this.shuffledExamList = new ArrayList<Exam>(this.cachedExamToMoveMap.keySet());
        this.nextShuffledExamListIndex = Integer.MAX_VALUE;
    }

    private void addToCachedExamToMoveMap(int examListSize, List<Move> cachedMoveList) {
        for (Move cachedMove : cachedMoveList) {
            TabuPropertyEnabled tabuPropertyEnabledMove = (TabuPropertyEnabled)((Object)cachedMove);
            for (Object object : tabuPropertyEnabledMove.getTabuProperties()) {
                Exam exam = (Exam)object;
                List<Move> moveList = this.cachedExamToMoveMap.get(exam);
                if (moveList == null) {
                    moveList = new ArrayList<Move>(examListSize);
                    this.cachedExamToMoveMap.put(exam, moveList);
                }
                moveList.add(cachedMove);
            }
        }
    }

    @Override
    public void beforeDeciding(LocalSearchStepScope localSearchStepScope) {
        this.periodChangeMoveFactory.beforeDeciding(localSearchStepScope);
        this.roomChangeMoveFactory.beforeDeciding(localSearchStepScope);
        this.examSwitchMoveFactory.beforeDeciding(localSearchStepScope);
    }

    @Override
    public Iterator<Move> moveIterator(LocalSearchStepScope localSearchStepScope) {
        if (this.nextShuffledExamListIndex >= this.shuffledExamList.size()) {
            Collections.shuffle(this.shuffledExamList, localSearchStepScope.getWorkingRandom());
            this.nextShuffledExamListIndex = 0;
        }
        Exam exam = this.shuffledExamList.get(this.nextShuffledExamListIndex);
        List<Move> moveList = this.cachedExamToMoveMap.get(exam);
        ++this.nextShuffledExamListIndex;
        return moveList.iterator();
    }

    @Override
    public void stepDecided(LocalSearchStepScope localSearchStepScope) {
        this.periodChangeMoveFactory.stepDecided(localSearchStepScope);
        this.roomChangeMoveFactory.stepDecided(localSearchStepScope);
        this.examSwitchMoveFactory.stepDecided(localSearchStepScope);
    }

    @Override
    public void stepTaken(LocalSearchStepScope localSearchStepScope) {
        this.periodChangeMoveFactory.stepTaken(localSearchStepScope);
        this.roomChangeMoveFactory.stepTaken(localSearchStepScope);
        this.examSwitchMoveFactory.stepTaken(localSearchStepScope);
    }

    @Override
    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.periodChangeMoveFactory.phaseEnded(localSearchSolverPhaseScope);
        this.roomChangeMoveFactory.phaseEnded(localSearchSolverPhaseScope);
        this.examSwitchMoveFactory.phaseEnded(localSearchSolverPhaseScope);
    }
}

