/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nqueens.domain;

import org.drools.planner.api.domain.entity.PlanningEntity;
import org.drools.planner.api.domain.variable.PlanningVariable;
import org.drools.planner.api.domain.variable.ValueRangeFromSolutionProperty;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.nqueens.domain.Column;
import org.drools.planner.examples.nqueens.domain.Row;
import org.drools.planner.examples.nqueens.domain.solution.QueenDifficultyWeightFactory;
import org.drools.planner.examples.nqueens.domain.solution.RowStrengthWeightFactory;

@PlanningEntity(difficultyWeightFactoryClass=QueenDifficultyWeightFactory.class)
public class Queen
extends AbstractPersistable {
    private Column column;
    private Row row;

    public Column getColumn() {
        return this.column;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    @PlanningVariable(strengthWeightFactoryClass=RowStrengthWeightFactory.class)
    @ValueRangeFromSolutionProperty(propertyName="rowList")
    public Row getRow() {
        return this.row;
    }

    public void setRow(Row row) {
        this.row = row;
    }

    public int getColumnIndex() {
        return this.column.getIndex();
    }

    public int getRowIndex() {
        return this.row.getIndex();
    }

    public int getAscendingDiagonalIndex() {
        return this.getColumnIndex() + this.getRowIndex();
    }

    public int getDescendingDiagonalIndex() {
        return this.getColumnIndex() - this.getRowIndex();
    }

    public Queen clone() {
        Queen clone = new Queen();
        clone.id = this.id;
        clone.column = this.column;
        clone.row = this.row;
        return clone;
    }

    public String toString() {
        return this.column + " @ " + this.row;
    }
}

