/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.pas.persistence;

import java.io.IOException;
import java.util.Collections;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.persistence.AbstractTxtSolutionExporter;
import org.drools.planner.examples.pas.domain.BedDesignation;
import org.drools.planner.examples.pas.domain.Patient;
import org.drools.planner.examples.pas.domain.PatientAdmissionSchedule;
import org.drools.planner.examples.pas.persistence.PatientAdmissionScheduleDaoImpl;

public class PatientAdmissionScheduleSolutionExporter
extends AbstractTxtSolutionExporter {
    public static void main(String[] args) {
        new PatientAdmissionScheduleSolutionExporter().convertAll();
    }

    public PatientAdmissionScheduleSolutionExporter() {
        super(new PatientAdmissionScheduleDaoImpl());
    }

    public AbstractTxtSolutionExporter.TxtOutputBuilder createTxtOutputBuilder() {
        return new PatientAdmissionScheduleOutputBuilder();
    }

    public class PatientAdmissionScheduleOutputBuilder
    extends AbstractTxtSolutionExporter.TxtOutputBuilder {
        private PatientAdmissionSchedule patientAdmissionSchedule;

        public PatientAdmissionScheduleOutputBuilder() {
            super(PatientAdmissionScheduleSolutionExporter.this);
        }

        public void setSolution(Solution solution) {
            this.patientAdmissionSchedule = (PatientAdmissionSchedule)solution;
        }

        public void writeSolution() throws IOException {
            Collections.sort(this.patientAdmissionSchedule.getBedDesignationList());
            for (Patient patient : this.patientAdmissionSchedule.getPatientList()) {
                this.bufferedWriter.write(Long.toString(patient.getId()));
                for (BedDesignation bedDesignation : this.patientAdmissionSchedule.getBedDesignationList()) {
                    if (!bedDesignation.getPatient().equals(patient)) continue;
                    for (int i = 0; i < bedDesignation.getAdmissionPart().getNightCount(); ++i) {
                        this.bufferedWriter.write(" " + Long.toString(bedDesignation.getBed().getId()));
                    }
                }
                this.bufferedWriter.write("\n");
            }
        }
    }
}

