/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.tsp.solver.solution.initializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.planner.core.phase.custom.CustomSolverPhaseCommand;
import org.drools.planner.core.score.DefaultSimpleScore;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.SimpleScore;
import org.drools.planner.core.solution.director.SolutionDirector;
import org.drools.planner.examples.common.domain.PersistableIdComparator;
import org.drools.planner.examples.tsp.domain.City;
import org.drools.planner.examples.tsp.domain.CityAssignment;
import org.drools.planner.examples.tsp.domain.TravelingSalesmanTour;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TspStartingSolutionInitializer
implements CustomSolverPhaseCommand {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void changeWorkingSolution(SolutionDirector solutionDirector) {
        TravelingSalesmanTour travelingSalesmanTour = (TravelingSalesmanTour)solutionDirector.getWorkingSolution();
        this.initializeCityAssignmentList(solutionDirector, travelingSalesmanTour);
    }

    private void initializeCityAssignmentList(SolutionDirector solutionDirector, TravelingSalesmanTour travelingSalesmanTour) {
        City startCity = travelingSalesmanTour.getStartCity();
        WorkingMemory workingMemory = solutionDirector.getWorkingMemory();
        List<CityAssignment> cityAssignmentList = this.createCityAssignmentList(travelingSalesmanTour);
        ArrayList<CityAssignment> assignedCityAssignmentList = null;
        for (CityAssignment cityAssignment : cityAssignmentList) {
            FactHandle cityAssignmentHandle = null;
            if (assignedCityAssignmentList == null) {
                assignedCityAssignmentList = new ArrayList<CityAssignment>(cityAssignmentList.size());
                cityAssignment.setNextCityAssignment(cityAssignment);
                cityAssignment.setPreviousCityAssignment(cityAssignment);
                cityAssignmentHandle = workingMemory.insert((Object)cityAssignment);
            } else {
                Score<SimpleScore> bestScore = DefaultSimpleScore.valueOf(Integer.MIN_VALUE);
                CityAssignment bestAfterCityAssignment = null;
                FactHandle bestAfterCityAssignmentFactHandle = null;
                CityAssignment bestBeforeCityAssignment = null;
                FactHandle bestBeforeCityAssignmentFactHandle = null;
                for (CityAssignment afterCityAssignment : assignedCityAssignmentList) {
                    CityAssignment beforeCityAssignment = afterCityAssignment.getNextCityAssignment();
                    FactHandle afterCityAssignmentFactHandle = workingMemory.getFactHandle((Object)afterCityAssignment);
                    FactHandle beforeCityAssignmentFactHandle = workingMemory.getFactHandle((Object)beforeCityAssignment);
                    afterCityAssignment.setNextCityAssignment(cityAssignment);
                    cityAssignment.setPreviousCityAssignment(afterCityAssignment);
                    cityAssignment.setNextCityAssignment(beforeCityAssignment);
                    beforeCityAssignment.setPreviousCityAssignment(cityAssignment);
                    if (cityAssignmentHandle == null) {
                        cityAssignmentHandle = workingMemory.insert((Object)cityAssignment);
                    } else {
                        workingMemory.update((org.drools.runtime.rule.FactHandle)cityAssignmentHandle, (Object)cityAssignment);
                    }
                    workingMemory.update((org.drools.runtime.rule.FactHandle)afterCityAssignmentFactHandle, (Object)afterCityAssignment);
                    workingMemory.update((org.drools.runtime.rule.FactHandle)beforeCityAssignmentFactHandle, (Object)beforeCityAssignment);
                    Score score = solutionDirector.calculateScoreFromWorkingMemory();
                    if (score.compareTo(bestScore) > 0) {
                        bestScore = score;
                        bestAfterCityAssignment = afterCityAssignment;
                        bestAfterCityAssignmentFactHandle = afterCityAssignmentFactHandle;
                        bestBeforeCityAssignment = beforeCityAssignment;
                        bestBeforeCityAssignmentFactHandle = beforeCityAssignmentFactHandle;
                    }
                    afterCityAssignment.setNextCityAssignment(beforeCityAssignment);
                    beforeCityAssignment.setPreviousCityAssignment(afterCityAssignment);
                    workingMemory.update((org.drools.runtime.rule.FactHandle)afterCityAssignmentFactHandle, (Object)afterCityAssignment);
                    workingMemory.update((org.drools.runtime.rule.FactHandle)beforeCityAssignmentFactHandle, (Object)beforeCityAssignment);
                }
                if (bestAfterCityAssignment == null) {
                    throw new IllegalStateException("The bestAfterCityAssignment (" + bestAfterCityAssignment + ") cannot be null.");
                }
                bestAfterCityAssignment.setNextCityAssignment(cityAssignment);
                cityAssignment.setPreviousCityAssignment(bestAfterCityAssignment);
                cityAssignment.setNextCityAssignment(bestBeforeCityAssignment);
                bestBeforeCityAssignment.setPreviousCityAssignment(cityAssignment);
                workingMemory.update((org.drools.runtime.rule.FactHandle)cityAssignmentHandle, (Object)cityAssignment);
                workingMemory.update(bestAfterCityAssignmentFactHandle, (Object)bestAfterCityAssignment);
                workingMemory.update(bestBeforeCityAssignmentFactHandle, (Object)bestBeforeCityAssignment);
            }
            assignedCityAssignmentList.add(cityAssignment);
            if (cityAssignment.getCity() == startCity) {
                travelingSalesmanTour.setStartCityAssignment(cityAssignment);
            }
            this.logger.debug("    CityAssignment ({}) initialized.", (Object)cityAssignment);
        }
        Collections.sort(cityAssignmentList, new PersistableIdComparator());
        travelingSalesmanTour.setCityAssignmentList(cityAssignmentList);
    }

    public List<CityAssignment> createCityAssignmentList(TravelingSalesmanTour travelingSalesmanTour) {
        List<City> cityList = travelingSalesmanTour.getCityList();
        ArrayList<CityAssignment> cityAssignmentList = new ArrayList<CityAssignment>(cityList.size());
        int cityAssignmentId = 0;
        for (City city : cityList) {
            CityAssignment cityAssignment = new CityAssignment();
            cityAssignment.setId(Long.valueOf(cityAssignmentId));
            cityAssignment.setCity(city);
            cityAssignmentList.add(cityAssignment);
            ++cityAssignmentId;
        }
        return cityAssignmentList;
    }
}

