/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.examination.solver.move.factory;

import java.util.ArrayList;
import java.util.List;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.move.factory.AbstractMoveFactory;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.examination.domain.Exam;
import org.drools.planner.examples.examination.domain.Examination;
import org.drools.planner.examples.examination.domain.Period;
import org.drools.planner.examples.examination.domain.Room;
import org.drools.planner.examples.examination.solver.move.PeriodChangeMove;
import org.drools.planner.examples.examination.solver.move.RoomChangeMove;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JumpingNeighbourExaminationMoveFactory
extends AbstractMoveFactory {
    private int periodJump = 1;
    private int roomJump = 1;

    @Override
    public List<Move> createMoveList(Solution solution) {
        Examination examination = (Examination)solution;
        List<Period> periodList = examination.getPeriodList();
        List<Room> roomList = examination.getRoomList();
        ArrayList<Move> moveList = new ArrayList<Move>();
        for (Exam exam : examination.getExamList()) {
            if (exam.isCoincidenceLeader()) {
                for (Period period : periodList) {
                    int distance = this.calculateShortestDistance(period.getPeriodIndex(), exam.getPeriod().getPeriodIndex(), periodList.size());
                    if (distance != this.periodJump) continue;
                    moveList.add(new PeriodChangeMove(exam, period));
                }
            }
            for (Room room : roomList) {
                long distance = this.calculateShortestDistance(room.getId(), exam.getRoom().getId(), (long)roomList.size());
                if (distance != (long)this.roomJump) continue;
                moveList.add(new RoomChangeMove(exam, room));
            }
        }
        ++this.periodJump;
        if (this.periodJump >= periodList.size() / 2) {
            this.periodJump = 1;
        }
        ++this.roomJump;
        if (this.roomJump >= roomList.size() / 2) {
            this.roomJump = 1;
        }
        return moveList;
    }

    public int calculateShortestDistance(int a, int b, int size) {
        int innerDistance = Math.abs(a - b);
        int outerDistance = size - innerDistance;
        return Math.min(innerDistance, outerDistance);
    }

    public long calculateShortestDistance(long a, long b, long size) {
        long innerDistance = Math.abs(a - b);
        long outerDistance = size - innerDistance;
        return Math.min(innerDistance, outerDistance);
    }
}

