/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.phase;

import org.drools.planner.core.bestsolution.BestSolutionRecaller;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.SolverPhase;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListener;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleSupport;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solver.DefaultSolverScope;
import org.drools.planner.core.termination.Termination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSolverPhase
implements SolverPhase,
SolverPhaseLifecycleListener {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Termination termination;
    protected BestSolutionRecaller bestSolutionRecaller;
    protected SolverPhaseLifecycleSupport solverPhaseLifecycleSupport = new SolverPhaseLifecycleSupport();

    public void setTermination(Termination termination) {
        this.termination = termination;
    }

    public void setBestSolutionRecaller(BestSolutionRecaller bestSolutionRecaller) {
        this.bestSolutionRecaller = bestSolutionRecaller;
    }

    public void phaseStarted(AbstractSolverPhaseScope solverPhaseScope) {
        solverPhaseScope.reset();
        this.termination.phaseStarted(solverPhaseScope);
        this.solverPhaseLifecycleSupport.firePhaseStarted(solverPhaseScope);
    }

    public void beforeDeciding(AbstractStepScope stepScope) {
        this.termination.beforeDeciding(stepScope);
        this.solverPhaseLifecycleSupport.fireBeforeDeciding(stepScope);
    }

    public void stepDecided(AbstractStepScope stepScope) {
        this.termination.stepDecided(stepScope);
        this.solverPhaseLifecycleSupport.fireStepDecided(stepScope);
    }

    public void stepTaken(AbstractStepScope stepScope) {
        this.bestSolutionRecaller.extractBestSolution(stepScope);
        this.termination.stepTaken(stepScope);
        this.solverPhaseLifecycleSupport.fireStepTaken(stepScope);
    }

    public void phaseEnded(AbstractSolverPhaseScope solverPhaseScope) {
        DefaultSolverScope solverScope = solverPhaseScope.getSolverScope();
        Solution bestSolution = solverScope.getBestSolution();
        if (bestSolution != null) {
            solverScope.getSolutionDirector().setWorkingSolution(bestSolution.cloneSolution());
        }
        this.termination.phaseEnded(solverPhaseScope);
        this.solverPhaseLifecycleSupport.firePhaseEnded(solverPhaseScope);
    }

    public void addSolverPhaseLifecycleListener(SolverPhaseLifecycleListener lifecycleListener) {
        this.solverPhaseLifecycleSupport.addEventListener(lifecycleListener);
    }

    public void removeSolverPhaseLifecycleListener(SolverPhaseLifecycleListener lifecycleListener) {
        this.solverPhaseLifecycleSupport.removeEventListener(lifecycleListener);
    }
}

