/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.examination.solver.move;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.WorkingMemory;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.TabuPropertyEnabled;
import org.drools.planner.core.move.Move;
import org.drools.planner.examples.examination.domain.Exam;
import org.drools.planner.examples.examination.domain.Period;
import org.drools.planner.examples.examination.domain.Room;
import org.drools.planner.examples.examination.solver.move.ExaminationMoveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamSwitchMove
implements Move,
TabuPropertyEnabled {
    private Exam leftExam;
    private Exam rightExam;

    public ExamSwitchMove(Exam leftExam, Exam rightExam) {
        this.leftExam = leftExam;
        this.rightExam = rightExam;
    }

    @Override
    public boolean isMoveDoable(WorkingMemory workingMemory) {
        return !ObjectUtils.equals((Object)this.leftExam.getPeriod(), (Object)this.rightExam.getPeriod()) || !ObjectUtils.equals((Object)this.leftExam.getRoom(), (Object)this.rightExam.getRoom());
    }

    @Override
    public Move createUndoMove(WorkingMemory workingMemory) {
        return new ExamSwitchMove(this.rightExam, this.leftExam);
    }

    @Override
    public void doMove(WorkingMemory workingMemory) {
        Period oldLeftPeriod = this.leftExam.getPeriod();
        Period oldRightPeriod = this.rightExam.getPeriod();
        Room oldLeftRoom = this.leftExam.getRoom();
        Room oldRightRoom = this.rightExam.getRoom();
        if (oldLeftPeriod.equals(oldRightPeriod)) {
            ExaminationMoveHelper.moveRoom(workingMemory, this.leftExam, oldRightRoom);
            ExaminationMoveHelper.moveRoom(workingMemory, this.rightExam, oldLeftRoom);
        } else if (oldLeftRoom.equals(oldRightRoom)) {
            ExaminationMoveHelper.movePeriod(workingMemory, this.leftExam, oldRightPeriod);
            ExaminationMoveHelper.movePeriod(workingMemory, this.rightExam, oldLeftPeriod);
        } else {
            ExaminationMoveHelper.moveExam(workingMemory, this.leftExam, oldRightPeriod, oldRightRoom);
            ExaminationMoveHelper.moveExam(workingMemory, this.rightExam, oldLeftPeriod, oldLeftRoom);
        }
    }

    @Override
    public Collection<? extends Object> getTabuProperties() {
        return Arrays.asList(this.leftExam, this.rightExam);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ExamSwitchMove) {
            ExamSwitchMove other = (ExamSwitchMove)o;
            return new EqualsBuilder().append((Object)this.leftExam, (Object)other.leftExam).append((Object)this.rightExam, (Object)other.rightExam).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftExam).append((Object)this.rightExam).toHashCode();
    }

    public String toString() {
        return this.leftExam + " <=> " + this.rightExam;
    }
}

