/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nqueens.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.TabuPropertyEnabled;
import org.drools.planner.core.move.Move;
import org.drools.planner.examples.nqueens.domain.Queen;
import org.drools.planner.examples.nqueens.domain.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowChangeMove
implements Move,
TabuPropertyEnabled {
    private Queen queen;
    private Row toRow;

    public RowChangeMove(Queen queen, Row toRow) {
        this.queen = queen;
        this.toRow = toRow;
    }

    @Override
    public boolean isMoveDoable(WorkingMemory workingMemory) {
        return !ObjectUtils.equals((Object)this.queen.getRow(), (Object)this.toRow);
    }

    @Override
    public Move createUndoMove(WorkingMemory workingMemory) {
        return new RowChangeMove(this.queen, this.queen.getRow());
    }

    @Override
    public void doMove(WorkingMemory workingMemory) {
        FactHandle queenHandle = workingMemory.getFactHandle((Object)this.queen);
        this.queen.setRow(this.toRow);
        workingMemory.update((org.drools.runtime.rule.FactHandle)queenHandle, (Object)this.queen);
    }

    @Override
    public Collection<? extends Object> getTabuProperties() {
        return Collections.singletonList(this.queen);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RowChangeMove) {
            RowChangeMove other = (RowChangeMove)o;
            return new EqualsBuilder().append((Object)this.queen, (Object)other.queen).append((Object)this.toRow, (Object)other.toRow).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.queen).append((Object)this.toRow).toHashCode();
    }

    public String toString() {
        return this.queen + " => " + this.toRow;
    }
}

