/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.travelingtournament.solver.smart.move;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.TabuPropertyEnabled;
import org.drools.planner.core.move.Move;
import org.drools.planner.examples.travelingtournament.domain.Day;
import org.drools.planner.examples.travelingtournament.domain.Match;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleMatchListRotateMove
implements Move,
TabuPropertyEnabled {
    private List<Match> firstMatchList;
    private List<Match> secondMatchList;

    public MultipleMatchListRotateMove(List<Match> firstMatchList, List<Match> secondMatchList) {
        this.firstMatchList = firstMatchList;
        this.secondMatchList = secondMatchList;
    }

    @Override
    public boolean isMoveDoable(WorkingMemory workingMemory) {
        return true;
    }

    @Override
    public Move createUndoMove(WorkingMemory workingMemory) {
        ArrayList<Match> inverseFirstMatchList = new ArrayList<Match>(this.firstMatchList);
        Collections.reverse(inverseFirstMatchList);
        ArrayList<Match> inverseSecondMatchList = new ArrayList<Match>(this.secondMatchList);
        Collections.reverse(inverseSecondMatchList);
        return new MultipleMatchListRotateMove(inverseFirstMatchList, inverseSecondMatchList);
    }

    @Override
    public void doMove(WorkingMemory workingMemory) {
        this.rotateList(this.firstMatchList, workingMemory);
        if (!this.secondMatchList.isEmpty()) {
            this.rotateList(this.secondMatchList, workingMemory);
        }
    }

    private void rotateList(List<Match> matchList, WorkingMemory workingMemory) {
        Iterator<Match> it = matchList.iterator();
        Match firstMatch = it.next();
        Match secondMatch = null;
        Day startDay = firstMatch.getDay();
        while (it.hasNext()) {
            secondMatch = it.next();
            FactHandle firstMatchHandle = workingMemory.getFactHandle((Object)firstMatch);
            firstMatch.setDay(secondMatch.getDay());
            workingMemory.update((org.drools.runtime.rule.FactHandle)firstMatchHandle, (Object)firstMatch);
            firstMatch = secondMatch;
        }
        FactHandle secondMatchHandle = workingMemory.getFactHandle((Object)firstMatch);
        secondMatch.setDay(startDay);
        workingMemory.update((org.drools.runtime.rule.FactHandle)secondMatchHandle, (Object)secondMatch);
    }

    @Override
    public Collection<? extends Object> getTabuProperties() {
        ArrayList<Match> tabuPropertyList = new ArrayList<Match>(this.firstMatchList.size() + this.secondMatchList.size());
        tabuPropertyList.addAll(this.firstMatchList);
        tabuPropertyList.addAll(this.secondMatchList);
        return tabuPropertyList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MultipleMatchListRotateMove) {
            MultipleMatchListRotateMove other = (MultipleMatchListRotateMove)o;
            return new EqualsBuilder().append(this.firstMatchList, other.firstMatchList).append(this.secondMatchList, other.secondMatchList).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.firstMatchList).append(this.secondMatchList).toHashCode();
    }

    public String toString() {
        return this.firstMatchList + " & " + this.secondMatchList;
    }
}

