/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.domain.variable;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.drools.planner.api.domain.variable.PlanningValueStrengthWeightFactory;
import org.drools.planner.core.solution.Solution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanningValueSorter {
    private Comparator<Object> strengthComparator = null;
    private PlanningValueStrengthWeightFactory strengthWeightFactory = null;

    public void setStrengthComparator(Comparator<Object> strengthComparator) {
        this.strengthComparator = strengthComparator;
    }

    public void setStrengthWeightFactory(PlanningValueStrengthWeightFactory strengthWeightFactory) {
        this.strengthWeightFactory = strengthWeightFactory;
    }

    public boolean isSortStrengthSupported() {
        return this.strengthComparator != null || this.strengthWeightFactory != null;
    }

    public void sortStrengthAscending(Solution solution, List<Object> planningValueList) {
        if (this.strengthComparator != null) {
            Collections.sort(planningValueList, this.strengthComparator);
        } else if (this.strengthWeightFactory != null) {
            TreeMap<Comparable, Object> planningValueMap = new TreeMap<Comparable, Object>();
            for (Object planningValue : planningValueList) {
                Comparable strengthWeight = this.strengthWeightFactory.createStrengthWeight(solution, planningValue);
                Object previous = planningValueMap.put(strengthWeight, planningValue);
                if (previous == null) continue;
                throw new IllegalStateException("The planningValueList contains 2 times the same planningValue (" + previous + ") and (" + planningValue + ").");
            }
            planningValueList.clear();
            planningValueList.addAll(planningValueMap.values());
        } else {
            throw new IllegalStateException("Sorting on strength is impossible because strengthComparator and strengthWeightFactory are null.");
        }
    }

    public void sortStrengthDescending(Solution solution, List<Object> planningEntityList) {
        this.sortStrengthAscending(solution, planningEntityList);
        Collections.reverse(planningEntityList);
    }
}

