/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.solver.solution.initializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.planner.core.phase.custom.CustomSolverPhaseCommand;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.buildin.hardandsoft.DefaultHardAndSoftScore;
import org.drools.planner.core.score.buildin.hardandsoft.HardAndSoftScore;
import org.drools.planner.core.solution.director.SolutionDirector;
import org.drools.planner.examples.common.domain.PersistableIdComparator;
import org.drools.planner.examples.nurserostering.domain.Employee;
import org.drools.planner.examples.nurserostering.domain.NurseRoster;
import org.drools.planner.examples.nurserostering.domain.Shift;
import org.drools.planner.examples.nurserostering.domain.ShiftAssignment;
import org.drools.planner.examples.nurserostering.domain.ShiftDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NurseRosteringSolutionInitializer
implements CustomSolverPhaseCommand {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void changeWorkingSolution(SolutionDirector solutionDirector) {
        NurseRoster nurseRoster = (NurseRoster)solutionDirector.getWorkingSolution();
        this.initializeAssignmentList(solutionDirector, nurseRoster);
    }

    private void initializeAssignmentList(SolutionDirector solutionDirector, NurseRoster nurseRoster) {
        List<Employee> employeeList = nurseRoster.getEmployeeList();
        WorkingMemory workingMemory = solutionDirector.getWorkingMemory();
        List<ShiftAssignment> shiftAssignmentList = this.createAssignmentList(nurseRoster);
        for (ShiftAssignment shiftAssignment : shiftAssignmentList) {
            FactHandle assignmentHandle = null;
            Score<HardAndSoftScore> bestScore = DefaultHardAndSoftScore.valueOf(Integer.MIN_VALUE, Integer.MIN_VALUE);
            Employee bestEmployee = null;
            for (Employee employee : employeeList) {
                Score score;
                shiftAssignment.setEmployee(employee);
                if (assignmentHandle == null) {
                    assignmentHandle = workingMemory.insert((Object)shiftAssignment);
                } else {
                    workingMemory.update((org.drools.runtime.rule.FactHandle)assignmentHandle, (Object)shiftAssignment);
                }
                if ((score = solutionDirector.calculateScoreFromWorkingMemory()).compareTo(bestScore) <= 0) continue;
                bestScore = score;
                bestEmployee = employee;
            }
            if (bestEmployee == null) {
                throw new IllegalStateException("The bestEmployee (" + bestEmployee + ") cannot be null.");
            }
            shiftAssignment.setEmployee(bestEmployee);
            workingMemory.update(assignmentHandle, (Object)shiftAssignment);
            this.logger.debug("    ShiftAssignment ({}) initialized.", (Object)shiftAssignment);
        }
        Collections.sort(shiftAssignmentList, new PersistableIdComparator());
        nurseRoster.setShiftAssignmentList(shiftAssignmentList);
    }

    public List<ShiftAssignment> createAssignmentList(NurseRoster nurseRoster) {
        List<Shift> shiftList = nurseRoster.getShiftList();
        List<ShiftDate> shiftDateList = nurseRoster.getShiftDateList();
        ArrayList<ShiftInitializationWeight> shiftInitializationWeightList = new ArrayList<ShiftInitializationWeight>(shiftList.size());
        for (Shift shift : shiftList) {
            shiftInitializationWeightList.add(new ShiftInitializationWeight(nurseRoster, shift));
        }
        Collections.sort(shiftInitializationWeightList);
        ArrayList<ShiftAssignment> shiftAssignmentList = new ArrayList<ShiftAssignment>(shiftDateList.size() * nurseRoster.getEmployeeList().size());
        int assignmentId = 0;
        for (ShiftInitializationWeight shiftInitializationWeight : shiftInitializationWeightList) {
            Shift shift = shiftInitializationWeight.getShift();
            for (int i = 0; i < shift.getRequiredEmployeeSize(); ++i) {
                ShiftAssignment shiftAssignment = new ShiftAssignment();
                shiftAssignment.setId(Long.valueOf(assignmentId));
                shiftAssignment.setShift(shift);
                shiftAssignmentList.add(shiftAssignment);
                ++assignmentId;
            }
        }
        return shiftAssignmentList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShiftInitializationWeight
    implements Comparable<ShiftInitializationWeight> {
        private Shift shift;

        private ShiftInitializationWeight(NurseRoster nurseRoster, Shift shift) {
            this.shift = shift;
        }

        public Shift getShift() {
            return this.shift;
        }

        @Override
        public int compareTo(ShiftInitializationWeight other) {
            return new CompareToBuilder().append((Object)this.shift.getShiftDate(), (Object)other.shift.getShiftDate()).append(other.shift.getRequiredEmployeeSize(), this.shift.getRequiredEmployeeSize()).append((Object)this.shift.getShiftType(), (Object)other.shift.getShiftType()).toComparison();
        }
    }
}

