/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.tsp.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.api.domain.entity.PlanningEntity;
import org.drools.planner.api.domain.variable.PlanningVariable;
import org.drools.planner.api.domain.variable.ValueRangeFromSolutionProperty;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.tsp.domain.City;
import org.drools.planner.examples.tsp.solver.variable.PreviousJourneyListener;

@PlanningEntity
@XStreamAlias(value="Journey")
public class Journey
extends AbstractPersistable {
    private City city;
    private Journey previousJourney;
    private Journey nextJourney;

    public City getCity() {
        return this.city;
    }

    public void setCity(City city) {
        this.city = city;
    }

    @PlanningVariable(listenerClasses={PreviousJourneyListener.class})
    @ValueRangeFromSolutionProperty(propertyName="journeyList")
    public Journey getPreviousJourney() {
        return this.previousJourney;
    }

    public void setPreviousJourney(Journey previousJourney) {
        this.previousJourney = previousJourney;
    }

    public Journey getNextJourney() {
        return this.nextJourney;
    }

    public void setNextJourney(Journey nextJourney) {
        this.nextJourney = nextJourney;
    }

    public Journey clone() {
        Journey clone = new Journey();
        clone.id = this.id;
        clone.city = this.city;
        clone.previousJourney = this.previousJourney;
        clone.nextJourney = this.nextJourney;
        return clone;
    }

    public boolean solutionEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Journey) {
            Journey other = (Journey)o;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.city, (Object)other.city).append((Object)this.previousJourney, (Object)other.previousJourney).append((Object)this.nextJourney, (Object)other.nextJourney).isEquals();
        }
        return false;
    }

    public int solutionHashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.city).append((Object)this.previousJourney).append((Object)this.nextJourney).toHashCode();
    }

    public String toString() {
        return this.city.toString();
    }

    public int getDistanceToNextJourney() {
        return this.city.getDistance(this.nextJourney.getCity());
    }
}

