/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.tsp.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.api.domain.solution.PlanningEntityCollectionProperty;
import org.drools.planner.core.score.buildin.simple.SimpleScore;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.tsp.domain.City;
import org.drools.planner.examples.tsp.domain.Journey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="TravelingSalesmanTour")
public class TravelingSalesmanTour
extends AbstractPersistable
implements Solution<SimpleScore> {
    private String name;
    private List<City> cityList;
    private City startCity;
    private List<Journey> journeyList;
    private Journey startJourney;
    private SimpleScore score;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<City> getCityList() {
        return this.cityList;
    }

    public void setCityList(List<City> cityList) {
        this.cityList = cityList;
    }

    public City getStartCity() {
        return this.startCity;
    }

    public void setStartCity(City startCity) {
        this.startCity = startCity;
    }

    @PlanningEntityCollectionProperty
    public List<Journey> getJourneyList() {
        return this.journeyList;
    }

    public void setJourneyList(List<Journey> journeyList) {
        this.journeyList = journeyList;
    }

    public Journey getStartJourney() {
        return this.startJourney;
    }

    public void setStartJourney(Journey startJourney) {
        this.startJourney = startJourney;
    }

    @Override
    public SimpleScore getScore() {
        return this.score;
    }

    @Override
    public void setScore(SimpleScore score) {
        this.score = score;
    }

    @Override
    public Collection<? extends Object> getProblemFacts() {
        ArrayList<City> facts = new ArrayList<City>();
        facts.addAll(this.cityList);
        facts.add(this.startCity);
        return facts;
    }

    public TravelingSalesmanTour cloneSolution() {
        TravelingSalesmanTour clone = new TravelingSalesmanTour();
        clone.id = this.id;
        clone.name = this.name;
        clone.cityList = this.cityList;
        clone.startCity = this.startCity;
        ArrayList<Journey> clonedJourneyList = new ArrayList<Journey>(this.journeyList.size());
        HashMap<Long, Journey> idToClonedJourneyMap = new HashMap<Long, Journey>(this.journeyList.size());
        for (Journey journey : this.journeyList) {
            Journey clonedJourney = journey.clone();
            clonedJourneyList.add(clonedJourney);
            idToClonedJourneyMap.put(clonedJourney.getId(), clonedJourney);
            if (journey != this.startJourney) continue;
            clone.startJourney = clonedJourney;
        }
        for (Journey clonedJourney : clonedJourneyList) {
            clonedJourney.setPreviousJourney((Journey)idToClonedJourneyMap.get(clonedJourney.getPreviousJourney().getId()));
            clonedJourney.setNextJourney((Journey)idToClonedJourneyMap.get(clonedJourney.getNextJourney().getId()));
        }
        clone.journeyList = clonedJourneyList;
        clone.score = this.score;
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null || !(o instanceof TravelingSalesmanTour)) {
            return false;
        }
        TravelingSalesmanTour other = (TravelingSalesmanTour)o;
        if (this.journeyList.size() != other.journeyList.size()) {
            return false;
        }
        Iterator<Journey> it = this.journeyList.iterator();
        Iterator<Journey> otherIt = other.journeyList.iterator();
        while (it.hasNext()) {
            Journey otherJourney;
            Journey journey = it.next();
            if (journey.solutionEquals(otherJourney = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (Journey journey : this.journeyList) {
            hashCodeBuilder.append(journey.solutionHashCode());
        }
        return hashCodeBuilder.toHashCode();
    }
}

