/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.tsp.persistence;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.drools.planner.examples.tsp.domain.City;
import org.drools.planner.examples.tsp.domain.Journey;
import org.drools.planner.examples.tsp.domain.TravelingSalesmanTour;
import org.drools.planner.examples.tsp.persistence.TspDaoImpl;

public class TspSolutionImporter
extends AbstractTxtSolutionImporter {
    private static final String INPUT_FILE_SUFFIX = ".tsp";

    public static void main(String[] args) {
        new TspSolutionImporter().convertAll();
    }

    public TspSolutionImporter() {
        super(new TspDaoImpl());
    }

    protected String getInputFileSuffix() {
        return INPUT_FILE_SUFFIX;
    }

    public AbstractTxtSolutionImporter.TxtInputBuilder createTxtInputBuilder() {
        return new TravelingSalesmanTourInputBuilder();
    }

    public class TravelingSalesmanTourInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder {
        private TravelingSalesmanTour travelingSalesmanTour;
        private int cityListSize;

        public Solution readSolution() throws IOException {
            this.travelingSalesmanTour = new TravelingSalesmanTour();
            this.travelingSalesmanTour.setId(0L);
            this.readHeaders();
            this.readCityList();
            this.readConstantLine("EOF");
            this.createJourneyList();
            TspSolutionImporter.this.logger.info("TravelingSalesmanTour with {} cities.", (Object)this.travelingSalesmanTour.getCityList().size());
            BigInteger possibleSolutionSize = this.factorial(this.travelingSalesmanTour.getCityList().size() - 1);
            String flooredPossibleSolutionSize = "10^" + (possibleSolutionSize.toString().length() - 1);
            TspSolutionImporter.this.logger.info("TravelingSalesmanTour with flooredPossibleSolutionSize ({}) and possibleSolutionSize ({}).", (Object)flooredPossibleSolutionSize, (Object)possibleSolutionSize);
            return this.travelingSalesmanTour;
        }

        private void readHeaders() throws IOException {
            this.travelingSalesmanTour.setName(this.readStringValue("NAME :"));
            this.readUntilConstantLine("TYPE : TSP");
            this.cityListSize = this.readIntegerValue("DIMENSION :");
            String edgeWeightType = this.readStringValue("EDGE_WEIGHT_TYPE :");
            if (!edgeWeightType.equalsIgnoreCase("EUC_2D")) {
                throw new IllegalArgumentException("The edgeWeightType (" + edgeWeightType + ") is not supported.");
            }
        }

        private void readCityList() throws IOException {
            this.readConstantLine("NODE_COORD_SECTION");
            ArrayList<City> cityList = new ArrayList<City>(this.cityListSize);
            for (int i = 0; i < this.cityListSize; ++i) {
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpace(line, 3);
                City city = new City();
                city.setId(Long.parseLong(lineTokens[0]));
                city.setLatitude(Double.parseDouble(lineTokens[1]));
                city.setLongitude(Double.parseDouble(lineTokens[2]));
                cityList.add(city);
            }
            this.travelingSalesmanTour.setCityList(cityList);
            this.travelingSalesmanTour.setStartCity((City)cityList.get(0));
        }

        private void createJourneyList() {
            List<City> cityList = this.travelingSalesmanTour.getCityList();
            ArrayList<Journey> journeyList = new ArrayList<Journey>(cityList.size());
            long id = 0L;
            for (City city : cityList) {
                Journey journey = new Journey();
                journey.setId(id);
                ++id;
                journey.setCity(city);
                journeyList.add(journey);
                if (!city.equals(this.travelingSalesmanTour.getStartCity())) continue;
                this.travelingSalesmanTour.setStartJourney(journey);
            }
            this.travelingSalesmanTour.setJourneyList(journeyList);
        }

        private BigInteger factorial(int base) {
            BigInteger value = BigInteger.ONE;
            for (int i = 1; i <= base; ++i) {
                value = value.multiply(BigInteger.valueOf(base));
            }
            return value;
        }
    }
}

