/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.tsp.solver.solution.initializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.planner.core.phase.custom.CustomSolverPhaseCommand;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.buildin.simple.DefaultSimpleScore;
import org.drools.planner.core.score.buildin.simple.SimpleScore;
import org.drools.planner.core.solution.director.SolutionDirector;
import org.drools.planner.examples.common.domain.PersistableIdComparator;
import org.drools.planner.examples.tsp.domain.City;
import org.drools.planner.examples.tsp.domain.Journey;
import org.drools.planner.examples.tsp.domain.TravelingSalesmanTour;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TspSolutionInitializer
implements CustomSolverPhaseCommand {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void changeWorkingSolution(SolutionDirector solutionDirector) {
        TravelingSalesmanTour travelingSalesmanTour = (TravelingSalesmanTour)solutionDirector.getWorkingSolution();
        this.initializeJourneyList(solutionDirector, travelingSalesmanTour);
    }

    private void initializeJourneyList(SolutionDirector solutionDirector, TravelingSalesmanTour travelingSalesmanTour) {
        City startCity = travelingSalesmanTour.getStartCity();
        WorkingMemory workingMemory = solutionDirector.getWorkingMemory();
        List<Journey> journeyList = this.createJourneyList(travelingSalesmanTour);
        ArrayList<Journey> assignedJourneyList = null;
        for (Journey journey : journeyList) {
            FactHandle journeyHandle = null;
            if (assignedJourneyList == null) {
                assignedJourneyList = new ArrayList<Journey>(journeyList.size());
                journey.setNextJourney(journey);
                journey.setPreviousJourney(journey);
                journeyHandle = workingMemory.insert((Object)journey);
            } else {
                Score<SimpleScore> bestScore = DefaultSimpleScore.valueOf(Integer.MIN_VALUE);
                Journey bestAfterJourney = null;
                FactHandle bestAfterJourneyFactHandle = null;
                Journey bestBeforeJourney = null;
                FactHandle bestBeforeJourneyFactHandle = null;
                for (Journey afterJourney : assignedJourneyList) {
                    Journey beforeJourney = afterJourney.getNextJourney();
                    FactHandle afterJourneyFactHandle = workingMemory.getFactHandle((Object)afterJourney);
                    FactHandle beforeJourneyFactHandle = workingMemory.getFactHandle((Object)beforeJourney);
                    afterJourney.setNextJourney(journey);
                    journey.setPreviousJourney(afterJourney);
                    journey.setNextJourney(beforeJourney);
                    beforeJourney.setPreviousJourney(journey);
                    if (journeyHandle == null) {
                        journeyHandle = workingMemory.insert((Object)journey);
                    } else {
                        workingMemory.update((org.drools.runtime.rule.FactHandle)journeyHandle, (Object)journey);
                    }
                    workingMemory.update((org.drools.runtime.rule.FactHandle)afterJourneyFactHandle, (Object)afterJourney);
                    workingMemory.update((org.drools.runtime.rule.FactHandle)beforeJourneyFactHandle, (Object)beforeJourney);
                    Score score = solutionDirector.calculateScoreFromWorkingMemory();
                    if (score.compareTo(bestScore) > 0) {
                        bestScore = score;
                        bestAfterJourney = afterJourney;
                        bestAfterJourneyFactHandle = afterJourneyFactHandle;
                        bestBeforeJourney = beforeJourney;
                        bestBeforeJourneyFactHandle = beforeJourneyFactHandle;
                    }
                    afterJourney.setNextJourney(beforeJourney);
                    beforeJourney.setPreviousJourney(afterJourney);
                    workingMemory.update((org.drools.runtime.rule.FactHandle)afterJourneyFactHandle, (Object)afterJourney);
                    workingMemory.update((org.drools.runtime.rule.FactHandle)beforeJourneyFactHandle, (Object)beforeJourney);
                }
                if (bestAfterJourney == null) {
                    throw new IllegalStateException("The bestAfterJourney (" + bestAfterJourney + ") cannot be null.");
                }
                bestAfterJourney.setNextJourney(journey);
                journey.setPreviousJourney(bestAfterJourney);
                journey.setNextJourney(bestBeforeJourney);
                bestBeforeJourney.setPreviousJourney(journey);
                workingMemory.update((org.drools.runtime.rule.FactHandle)journeyHandle, (Object)journey);
                workingMemory.update(bestAfterJourneyFactHandle, (Object)bestAfterJourney);
                workingMemory.update(bestBeforeJourneyFactHandle, (Object)bestBeforeJourney);
            }
            assignedJourneyList.add(journey);
            if (journey.getCity() == startCity) {
                travelingSalesmanTour.setStartJourney(journey);
            }
            this.logger.debug("    Journey ({}) initialized.", (Object)journey);
        }
        Collections.sort(journeyList, new PersistableIdComparator());
        travelingSalesmanTour.setJourneyList(journeyList);
    }

    public List<Journey> createJourneyList(TravelingSalesmanTour travelingSalesmanTour) {
        List<City> cityList = travelingSalesmanTour.getCityList();
        ArrayList<Journey> journeyList = new ArrayList<Journey>(cityList.size());
        int journeyId = 0;
        for (City city : cityList) {
            Journey journey = new Journey();
            journey.setId(Long.valueOf(journeyId));
            journey.setCity(city);
            journeyList.add(journey);
            ++journeyId;
        }
        return journeyList;
    }
}

