/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.tsp.swingui;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.tsp.domain.Journey;
import org.drools.planner.examples.tsp.domain.TravelingSalesmanTour;
import org.drools.planner.examples.tsp.solver.move.SubTourChangeMove;
import org.drools.planner.examples.tsp.swingui.TspPanel;

public class TspListPanel
extends JPanel {
    private static final Color HEADER_COLOR = Color.YELLOW;
    private final TspPanel tspPanel;

    public TspListPanel(TspPanel tspPanel) {
        this.tspPanel = tspPanel;
        this.setLayout(new GridLayout(0, 1));
    }

    public void resetPanel(Solution solution) {
        this.removeAll();
        TravelingSalesmanTour travelingSalesmanTour = (TravelingSalesmanTour)solution;
        JLabel headerLabel = new JLabel("Tour of " + travelingSalesmanTour.getName());
        headerLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        headerLabel.setBackground(HEADER_COLOR);
        headerLabel.setOpaque(true);
        this.add(headerLabel);
        for (Journey journey : travelingSalesmanTour.getJourneyList()) {
            JPanel journeyPanel = new JPanel(new GridLayout(1, 2));
            JButton button = new JButton(new JourneyAction(journey));
            journeyPanel.add(button);
            String distanceLabelString = journey.getNextJourney() == null ? "Unassigned" : "Distance to next: " + journey.getDistanceToNextJourney();
            journeyPanel.add(new JLabel(distanceLabelString));
            this.add(journeyPanel);
        }
    }

    private class JourneyAction
    extends AbstractAction {
        private Journey journey;

        public JourneyAction(Journey journey) {
            super(journey.getCity().toString());
            this.journey = journey;
        }

        public void actionPerformed(ActionEvent e) {
            JPanel listFieldsPanel = new JPanel(new GridLayout(2, 1));
            List<Journey> afterJourneyList = TspListPanel.this.tspPanel.getTravelingSalesmanTour().getJourneyList();
            JComboBox<Object> afterJourneyListField = new JComboBox<Object>(afterJourneyList.toArray());
            afterJourneyListField.setSelectedItem(this.journey.getNextJourney());
            listFieldsPanel.add(afterJourneyListField);
            int result = JOptionPane.showConfirmDialog(TspListPanel.this.getRootPane(), listFieldsPanel, "Select to move after city", 2);
            if (result == 0) {
                Journey toAfterJourney = (Journey)afterJourneyListField.getSelectedItem();
                TspListPanel.this.tspPanel.doMove(new SubTourChangeMove(this.journey, this.journey, toAfterJourney));
                TspListPanel.this.tspPanel.getWorkflowFrame().resetScreen();
            }
        }
    }
}

