/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.drools.RuleBaseConfiguration;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.RuleBasePartitionId;
import org.drools.core.util.BitMaskUtil;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.ContextEntry;
import org.drools.rule.constraint.MvelConstraint;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.PropagationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlphaNode
extends ObjectSource
implements ObjectSinkNode,
NodeMemory {
    private static final long serialVersionUID = 510L;
    private AlphaNodeFieldConstraint constraint;
    private ObjectSinkNode previousRightTupleSinkNode;
    private ObjectSinkNode nextRightTupleSinkNode;
    private long listenedPropertyMask = -1L;
    private List<String> listenedProperties;

    public AlphaNode() {
    }

    public AlphaNode(int id, AlphaNodeFieldConstraint constraint, ObjectSource objectSource, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), objectSource, context.getRuleBase().getConfiguration().getAlphaNodeHashingThreshold());
        this.constraint = constraint;
        this.listenedProperties = context.getListenedProperties();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.constraint = (AlphaNodeFieldConstraint)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.constraint);
    }

    public AlphaNodeFieldConstraint getConstraint() {
        return this.constraint;
    }

    @Override
    public void attach() {
        this.source.addObjectSink(this);
    }

    @Override
    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        for (InternalWorkingMemory workingMemory : workingMemories) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.source.updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        AlphaMemory memory = (AlphaMemory)workingMemory.getNodeMemory(this);
        if (this.constraint.isAllowed(factHandle, workingMemory, memory.context)) {
            this.sink.propagateAssertObject(factHandle, context, workingMemory);
        }
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (context.getModificationMask() == Long.MAX_VALUE || BitMaskUtil.intersect(context.getModificationMask(), this.getListenedPropertyMask(workingMemory))) {
            AlphaMemory memory = (AlphaMemory)workingMemory.getNodeMemory(this);
            if (this.constraint.isAllowed(factHandle, workingMemory, memory.context)) {
                this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
            }
        } else {
            this.byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
        }
    }

    private void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        for (ObjectSink objectSink : this.sink.getSinks()) {
            if (objectSink instanceof BetaNode) {
                RightTuple rightTuple = modifyPreviousTuples.removeRightTuple((BetaNode)objectSink);
                if (rightTuple == null) continue;
                rightTuple.reAdd();
                continue;
            }
            if (!(objectSink instanceof AlphaNode)) continue;
            ((AlphaNode)((Object)this.sink)).byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
        }
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        AlphaMemory memory = (AlphaMemory)workingMemory.getNodeMemory(this);
        ObjectSinkUpdateAdapter adapter = new ObjectSinkUpdateAdapter(sink, this.constraint, memory.context);
        this.source.updateSink(adapter, context, workingMemory);
    }

    @Override
    public Object createMemory(RuleBaseConfiguration config) {
        AlphaMemory memory = new AlphaMemory();
        memory.context = this.constraint.createContextEntry();
        return memory;
    }

    @Override
    public String toString() {
        return "[AlphaNode(" + this.id + ") constraint=" + this.constraint + "]";
    }

    @Override
    public int hashCode() {
        return this.source.hashCode() * 17 + (this.constraint != null ? this.constraint.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof AlphaNode)) {
            return false;
        }
        AlphaNode other = (AlphaNode)object;
        return this.source.equals(other.source) && this.constraint.equals(other.constraint);
    }

    @Override
    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextRightTupleSinkNode;
    }

    @Override
    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextRightTupleSinkNode = next;
    }

    @Override
    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousRightTupleSinkNode;
    }

    @Override
    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousRightTupleSinkNode = previous;
    }

    long getListenedPropertyMask(InternalWorkingMemory workingMemory) {
        if (this.listenedPropertyMask >= 0L) {
            return this.listenedPropertyMask;
        }
        List<String> settableProperties = BetaNode.getSettableProperties(workingMemory, this.getObjectTypeNode());
        return this.getListenedPropertyMask(settableProperties);
    }

    long getListenedPropertyMask(List<String> settableProperties) {
        long mask;
        if (!(this.constraint instanceof MvelConstraint)) {
            return Long.MAX_VALUE;
        }
        if (this.listenedPropertyMask >= 0L) {
            return this.listenedPropertyMask;
        }
        this.listenedPropertyMask = mask = this.calculateMask(settableProperties);
        return mask >= 0L ? mask : Long.MAX_VALUE;
    }

    private long calculateMask(List<String> settableProperties) {
        if (this.listenedProperties != null && this.listenedProperties.size() == 1 && ((Object)this.listenedProperties).equals("*")) {
            return Long.MAX_VALUE;
        }
        long mask = 0L;
        if (this.listenedProperties != null && this.listenedProperties.contains("*")) {
            mask = Long.MAX_VALUE;
        } else if (this.listenedProperties == null || !this.listenedProperties.contains("!*")) {
            mask = this.inferListenedMask(settableProperties);
        }
        return BetaNode.calculateListenedMaskFromPattern(this.listenedProperties, mask, settableProperties);
    }

    private long inferListenedMask(List<String> settableProperties) {
        if (settableProperties == null || !(this.constraint instanceof MvelConstraint)) {
            return Long.MAX_VALUE;
        }
        long mask = ((MvelConstraint)this.constraint).getListenedPropertyMask(settableProperties);
        for (ObjectSink objectSink : this.sink.getSinks()) {
            if (objectSink instanceof AlphaNode ? (mask |= ((AlphaNode)objectSink).inferListenedMask(settableProperties)) == Long.MAX_VALUE : objectSink instanceof BetaNode && (mask |= ((BetaNode)objectSink).inferListenedMask(settableProperties)) == Long.MAX_VALUE) break;
        }
        return mask;
    }

    private ObjectTypeNode getObjectTypeNode() {
        ObjectSource source = this;
        while (source != null) {
            if (source instanceof ObjectTypeNode) {
                return (ObjectTypeNode)source;
            }
            source = source.source;
        }
        return null;
    }

    private static class ObjectSinkUpdateAdapter
    implements ObjectSink {
        private final ObjectSink sink;
        private final AlphaNodeFieldConstraint constraint;
        private final ContextEntry contextEntry;

        public ObjectSinkUpdateAdapter(ObjectSink sink, AlphaNodeFieldConstraint constraint, ContextEntry contextEntry) {
            this.sink = sink;
            this.constraint = constraint;
            this.contextEntry = contextEntry;
        }

        public void assertObject(InternalFactHandle handle, PropagationContext propagationContext, InternalWorkingMemory workingMemory) {
            if (this.constraint.isAllowed(handle, workingMemory, this.contextEntry)) {
                this.sink.assertObject(handle, propagationContext, workingMemory);
            }
        }

        public int getId() {
            return 0;
        }

        public RuleBasePartitionId getPartitionId() {
            return this.sink.getPartitionId();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException("This method should NEVER EVER be called");
        }
    }

    public static class AlphaMemory
    implements Externalizable {
        private static final long serialVersionUID = 510L;
        public ContextEntry context;

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.context = (ContextEntry)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.context);
        }
    }
}

