/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.constraint;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.And;
import org.mvel2.ast.BinaryOperation;
import org.mvel2.ast.BooleanNode;
import org.mvel2.ast.Contains;
import org.mvel2.ast.LiteralNode;
import org.mvel2.ast.Negation;
import org.mvel2.ast.NewObjectNode;
import org.mvel2.ast.Or;
import org.mvel2.ast.RegExMatch;
import org.mvel2.ast.Substatement;
import org.mvel2.compiler.Accessor;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExecutableAccessor;
import org.mvel2.compiler.ExecutableLiteral;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.ImmutableDefaultFactory;
import org.mvel2.optimizers.dynamic.DynamicGetAccessor;
import org.mvel2.optimizers.impl.refl.nodes.ConstructorAccessor;
import org.mvel2.optimizers.impl.refl.nodes.FieldAccessor;
import org.mvel2.optimizers.impl.refl.nodes.GetterAccessor;
import org.mvel2.optimizers.impl.refl.nodes.ListAccessor;
import org.mvel2.optimizers.impl.refl.nodes.ListAccessorNest;
import org.mvel2.optimizers.impl.refl.nodes.MapAccessorNest;
import org.mvel2.optimizers.impl.refl.nodes.MethodAccessor;
import org.mvel2.optimizers.impl.refl.nodes.StaticReferenceAccessor;
import org.mvel2.optimizers.impl.refl.nodes.StaticVarAccessor;
import org.mvel2.optimizers.impl.refl.nodes.ThisValueAccessor;
import org.mvel2.optimizers.impl.refl.nodes.VariableAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionAnalyzer {
    private ASTNode node;
    private ParserContext parserContext;
    private Map<String, Object> vars;

    public ConditionAnalyzer(ExecutableStatement stmt) {
        if (stmt instanceof CompiledExpression) {
            this.parserContext = ((CompiledExpression)stmt).getParserContext();
            this.node = ((CompiledExpression)stmt).getFirstNode();
        } else {
            this.node = ((ExecutableAccessor)stmt).getNode();
        }
    }

    public ConditionAnalyzer(ExecutableStatement stmt, Map<String, Object> vars) {
        this(stmt);
        this.vars = vars;
    }

    public Condition analyzeCondition() {
        while (this.node.nextASTNode != null) {
            this.node = this.node.nextASTNode;
        }
        return this.analyzeCondition(this.node);
    }

    private Condition analyzeCondition(ASTNode node) {
        boolean isNegated = false;
        if (node instanceof Negation) {
            isNegated = true;
            node = ((ExecutableAccessor)((Negation)node).getStatement()).getNode();
        }
        if ((node = this.analyzeSubstatement(node)) instanceof And || node instanceof Or) {
            return this.analyzeCombinedCondition((BooleanNode)node, isNegated);
        }
        return this.analyzeSingleCondition(node, isNegated);
    }

    private SingleCondition analyzeSingleCondition(ASTNode node, boolean isNegated) {
        SingleCondition condition = new SingleCondition(isNegated);
        if (node instanceof BinaryOperation) {
            BinaryOperation binaryOperation = (BinaryOperation)node;
            condition.left = this.analyzeNode(binaryOperation.getLeft());
            condition.operation = BooleanOperator.fromMvelOpCode(binaryOperation.getOperation());
            condition.right = this.analyzeNode(binaryOperation.getRight());
        } else if (node instanceof RegExMatch) {
            condition.left = this.analyzeNode(node);
            condition.operation = BooleanOperator.MATCHES;
            Pattern pattern = ((RegExMatch)node).getPattern();
            condition.right = new FixedExpression(String.class, pattern.pattern());
        } else if (node instanceof Contains) {
            condition.left = this.analyzeNode(((Contains)node).getFirstStatement());
            condition.operation = BooleanOperator.CONTAINS;
            condition.right = this.analyzeNode(((Contains)node).getSecondStatement());
        } else {
            condition.left = this.analyzeNode(node);
        }
        return condition;
    }

    private CombinedCondition analyzeCombinedCondition(BooleanNode booleanNode, boolean isNegated) {
        CombinedCondition condition = new CombinedCondition(booleanNode instanceof And, isNegated);
        condition.addCondition(this.analyzeCondition(booleanNode.getLeft()));
        condition.addCondition(this.analyzeCondition(booleanNode.getRight()));
        return condition;
    }

    private ASTNode analyzeSubstatement(ASTNode node) {
        if (node instanceof Substatement) {
            return ((ExecutableAccessor)((Substatement)node).getStatement()).getNode();
        }
        return node;
    }

    private ASTNode analyzeRegEx(ASTNode node) {
        if (node instanceof RegExMatch) {
            return ((ExecutableAccessor)((RegExMatch)node).getStatement()).getNode();
        }
        return node;
    }

    private Expression analyzeNode(ASTNode node) {
        if ((node = this.analyzeRegEx(this.analyzeSubstatement(node))) instanceof LiteralNode) {
            LiteralNode literalNode = (LiteralNode)node;
            return new FixedExpression(literalNode.getEgressType(), literalNode.getLiteralValue());
        }
        if (node instanceof BinaryOperation) {
            BinaryOperation op = (BinaryOperation)node;
            if (node.getClass() == BinaryOperation.class) {
                return new AritmeticExpression(node.getEgressType(), this.analyzeNode(op.getLeft()), AritmeticOperator.fromMvelOpCode(op.getOperation()), this.analyzeNode(op.getRight()));
            }
            return new FixedExpression(op.getEgressType(), op.getReducedValue((Object)this.parserContext, null, (VariableResolverFactory)new ImmutableDefaultFactory()));
        }
        Accessor accessor = node.getAccessor();
        if (accessor == null && node instanceof NewObjectNode) {
            accessor = ((NewObjectNode)node).getNewObjectOptimizer();
        }
        return this.analyzeAccessor(accessor);
    }

    private Expression analyzeAccessor(Accessor accessor) {
        VariableAccessor variableAccessor;
        AccessorNode accessorNode;
        if (accessor instanceof VariableAccessor && ((accessorNode = (variableAccessor = (VariableAccessor)accessor).getNextNode()) == null || !this.isStaticAccessor(accessorNode))) {
            String variableName = (String)variableAccessor.getProperty();
            return new VariableExpression(variableName, this.analyzeExpressionNode(accessorNode), this.getVariableType(variableName));
        }
        if (accessor instanceof DynamicGetAccessor) {
            accessorNode = (AccessorNode)((DynamicGetAccessor)accessor).getAccessor();
        } else if (accessor instanceof AccessorNode) {
            accessorNode = (AccessorNode)accessor;
        } else {
            if (accessor instanceof CompiledExpression) {
                return this.analyzeNode(((CompiledExpression)accessor).getFirstNode());
            }
            throw new RuntimeException("Unknown accessor type: " + accessor);
        }
        if (accessorNode != null && accessorNode instanceof VariableAccessor) {
            if (this.isStaticAccessor(accessorNode)) {
                while (accessorNode != null && accessorNode instanceof VariableAccessor) {
                    accessorNode = accessorNode.getNextNode();
                }
            } else {
                return this.analyzeAccessor((Accessor)accessorNode);
            }
        }
        while (accessorNode instanceof StaticReferenceAccessor) {
            StaticReferenceAccessor staticReferenceAccessor = (StaticReferenceAccessor)accessorNode;
            Object literal = staticReferenceAccessor.getLiteral();
            if ((accessorNode = accessorNode.getNextNode()) != null) continue;
            return new FixedExpression(literal.getClass(), literal);
        }
        return this.analyzeExpressionNode(accessorNode);
    }

    private boolean isStaticAccessor(AccessorNode accessorNode) {
        while (accessorNode != null) {
            if (accessorNode instanceof StaticVarAccessor || accessorNode instanceof StaticReferenceAccessor) {
                return true;
            }
            if (accessorNode instanceof MethodAccessor) {
                Method method = ((MethodAccessor)accessorNode).getMethod();
                return (method.getModifiers() & 8) > 0;
            }
            accessorNode = accessorNode.getNextNode();
        }
        return false;
    }

    private EvaluatedExpression analyzeExpressionNode(AccessorNode accessorNode) {
        if (accessorNode == null) {
            return null;
        }
        EvaluatedExpression expression = new EvaluatedExpression();
        Invocation invocation = null;
        while (accessorNode != null) {
            if ((invocation = this.analyzeAccessor(accessorNode, invocation)) != null) {
                expression.addInvocation(invocation);
            }
            accessorNode = accessorNode.getNextNode();
        }
        return expression;
    }

    private Invocation analyzeAccessor(AccessorNode accessorNode, Invocation formerInvocation) {
        if (accessorNode instanceof GetterAccessor) {
            return new MethodInvocation(((GetterAccessor)accessorNode).getMethod());
        }
        if (accessorNode instanceof MethodAccessor) {
            MethodAccessor methodAccessor = (MethodAccessor)accessorNode;
            MethodInvocation invocation = new MethodInvocation(methodAccessor.getMethod());
            this.readInvocationParams(invocation, methodAccessor.getParms(), methodAccessor.getParameterTypes());
            return invocation;
        }
        if (accessorNode instanceof ConstructorAccessor) {
            ConstructorAccessor constructorAccessor = (ConstructorAccessor)accessorNode;
            Constructor constructor = constructorAccessor.getConstructor();
            ConstructorInvocation invocation = new ConstructorInvocation(constructor);
            this.readInvocationParams(invocation, constructorAccessor.getParameters(), constructorAccessor.getParameterTypes());
            return invocation;
        }
        if (accessorNode instanceof ListAccessor) {
            Class<?> listType = this.getListType(formerInvocation);
            ListAccessor listAccessor = (ListAccessor)accessorNode;
            return new ListAccessInvocation(listType, new FixedExpression(Integer.TYPE, listAccessor.getIndex()));
        }
        if (accessorNode instanceof ListAccessorNest) {
            Class<?> listType = this.getListType(formerInvocation);
            ListAccessorNest listAccessorNest = (ListAccessorNest)accessorNode;
            ExecutableAccessor index = (ExecutableAccessor)listAccessorNest.getIndex();
            return new ListAccessInvocation(listType, this.analyzeNode(index.getNode()));
        }
        if (accessorNode instanceof MapAccessorNest) {
            MapAccessorNest mapAccessor;
            ExecutableStatement statement;
            Class keyType = Object.class;
            Class valueType = Object.class;
            Type[] generics = this.getGenerics(formerInvocation);
            if (generics != null && generics.length == 2 && generics[0] instanceof Class) {
                if (generics[0] instanceof Class) {
                    keyType = (Class)generics[0];
                }
                if (generics[1] instanceof Class) {
                    valueType = (Class)generics[1];
                }
            }
            if ((statement = (mapAccessor = (MapAccessorNest)accessorNode).getProperty()) instanceof ExecutableLiteral) {
                return new MapAccessInvocation(keyType, valueType, new FixedExpression(keyType, ((ExecutableLiteral)statement).getLiteral()));
            }
            return new MapAccessInvocation(keyType, valueType, this.analyzeNode(((ExecutableAccessor)statement).getNode()));
        }
        if (accessorNode instanceof FieldAccessor) {
            return new FieldAccessInvocation(((FieldAccessor)accessorNode).getField());
        }
        if (accessorNode instanceof StaticVarAccessor) {
            Field field = ((StaticVarAccessor)accessorNode).getField();
            return new FieldAccessInvocation(field);
        }
        if (accessorNode instanceof ThisValueAccessor) {
            return new MethodInvocation(null);
        }
        throw new RuntimeException("Unknown AccessorNode type: " + accessorNode.getClass().getName());
    }

    private Class<?> getListType(Invocation formerInvocation) {
        Class listType = Object.class;
        Type[] generics = this.getGenerics(formerInvocation);
        if (generics != null && generics.length == 1 && generics[0] instanceof Class) {
            listType = (Class)generics[0];
        }
        return listType;
    }

    private Type[] getGenerics(Invocation invocation) {
        Type returnType;
        if (invocation != null && invocation instanceof MethodInvocation && (returnType = ((MethodInvocation)invocation).getMethod().getGenericReturnType()) instanceof ParameterizedType) {
            return ((ParameterizedType)returnType).getActualTypeArguments();
        }
        return null;
    }

    private void readInvocationParams(Invocation invocation, ExecutableStatement[] params, Class[] paramTypes) {
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                ExecutableStatement param = params[i];
                if (param instanceof ExecutableLiteral) {
                    invocation.addArgument(new FixedExpression(paramTypes[i], ((ExecutableLiteral)param).getLiteral()));
                    continue;
                }
                if (!(param instanceof ExecutableAccessor)) continue;
                invocation.addArgument(this.analyzeNode(((ExecutableAccessor)param).getNode()));
            }
        }
    }

    private Class<?> getVariableType(String name) {
        if (this.vars == null) {
            return Object.class;
        }
        Object value = this.vars.get(name);
        return value == null ? Object.class : value.getClass();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AritmeticOperator {
        ADD("+"),
        SUB("-"),
        MUL("*"),
        DIV("/"),
        MOD("%"),
        POW("^"),
        BW_AND("&"),
        BW_OR("|"),
        BW_XOR("^"),
        BW_SHIFT_RIGHT(">>"),
        BW_SHIFT_LEFT("<<"),
        BW_USHIFT_RIGHT(">>>"),
        BW_USHIFT_LEFT("<<<");

        private String symbol;

        private AritmeticOperator(String symbol) {
            this.symbol = symbol;
        }

        public String toString() {
            return this.symbol;
        }

        public boolean isBitwiseOperation() {
            return this == BW_AND || this == BW_OR || this == BW_SHIFT_RIGHT || this == BW_SHIFT_LEFT || this == BW_USHIFT_RIGHT || this == BW_USHIFT_LEFT;
        }

        public static AritmeticOperator fromMvelOpCode(int opCode) {
            switch (opCode) {
                case 0: {
                    return ADD;
                }
                case 1: {
                    return SUB;
                }
                case 2: {
                    return MUL;
                }
                case 3: {
                    return DIV;
                }
                case 4: {
                    return MOD;
                }
                case 6: {
                    return BW_AND;
                }
                case 7: {
                    return BW_OR;
                }
                case 9: {
                    return BW_SHIFT_RIGHT;
                }
                case 10: {
                    return BW_SHIFT_LEFT;
                }
                case 11: {
                    return BW_USHIFT_RIGHT;
                }
                case 12: {
                    return BW_USHIFT_LEFT;
                }
            }
            throw new RuntimeException("Unknown boolean operator");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BooleanOperator {
        EQ("=="),
        NE("!="),
        GT(">"),
        GE(">="),
        LT("<"),
        LE("<="),
        MATCHES("~="),
        CONTAINS("in");

        private String symbol;

        private BooleanOperator(String symbol) {
            this.symbol = symbol;
        }

        public String toString() {
            return this.symbol;
        }

        public boolean isEquality() {
            return this == EQ || this == NE;
        }

        public boolean needsSameType() {
            return this != CONTAINS;
        }

        public boolean isComparison() {
            return this == GT || this == GE || this == LT || this == LE;
        }

        public static BooleanOperator fromMvelOpCode(int opCode) {
            switch (opCode) {
                case 18: {
                    return EQ;
                }
                case 19: {
                    return NE;
                }
                case 15: {
                    return GT;
                }
                case 17: {
                    return GE;
                }
                case 14: {
                    return LT;
                }
                case 16: {
                    return LE;
                }
            }
            throw new RuntimeException("Unknown boolean operator");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypedValue {
        Class<?> type;
        Object value;

        TypedValue(Class<?> type, Object value) {
            this.type = type;
            this.value = value;
        }

        public String toString() {
            return this.type.getSimpleName() + " " + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldAccessInvocation
    extends Invocation {
        private final Field field;

        public FieldAccessInvocation(Field field) {
            this.field = field;
        }

        public Field getField() {
            return this.field;
        }

        public String toString() {
            return this.field.getName();
        }

        @Override
        public Class<?> getReturnType() {
            return this.field.getType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapAccessInvocation
    extends Invocation {
        private final Class<?> keyType;
        private final Class<?> valueType;
        private final Expression key;

        public MapAccessInvocation(Class<?> keyType, Class<?> valueType, Expression key) {
            this.keyType = keyType;
            this.valueType = valueType;
            this.key = key;
        }

        public Expression getKey() {
            return this.key;
        }

        public String toString() {
            return "[\"" + this.key + "\"]";
        }

        public Class<?> getKeyType() {
            return this.keyType;
        }

        @Override
        public Class<?> getReturnType() {
            return this.valueType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListAccessInvocation
    extends Invocation {
        private final Class<?> listType;
        private final Expression index;

        public ListAccessInvocation(Class<?> listType, Expression index) {
            this.listType = listType;
            this.index = index;
        }

        public Expression getIndex() {
            return this.index;
        }

        public String toString() {
            return "[" + this.index + "]";
        }

        @Override
        public Class<?> getReturnType() {
            return this.listType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConstructorInvocation
    extends Invocation {
        private final Constructor constructor;

        public ConstructorInvocation(Constructor constructor) {
            this.constructor = constructor;
        }

        public Constructor getConstructor() {
            return this.constructor;
        }

        public String toString() {
            return "new " + this.getReturnType() + (!this.getArguments().isEmpty() ? " with " + this.getArguments() : "");
        }

        @Override
        public Class<?> getReturnType() {
            return this.constructor.getDeclaringClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodInvocation
    extends Invocation {
        private final Method method;

        public MethodInvocation(Method method) {
            this.method = this.getMethodFromSuperclass(method);
        }

        private Method getMethodFromSuperclass(Method method) {
            if (method == null) {
                return method;
            }
            Class<?> declaringClass = method.getDeclaringClass();
            Class<?> declaringSuperclass = declaringClass.getSuperclass();
            if (declaringSuperclass != null) {
                try {
                    return this.getMethodFromSuperclass(declaringSuperclass.getMethod(method.getName(), method.getParameterTypes()));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (Class<?> interfaze : declaringClass.getInterfaces()) {
                try {
                    return interfaze.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (Exception e) {
                }
            }
            return method;
        }

        public Method getMethod() {
            return this.method;
        }

        public String toString() {
            if (this.method == null) {
                return "this";
            }
            return this.method + (!this.getArguments().isEmpty() ? " with " + this.getArguments() : "");
        }

        @Override
        public Class<?> getReturnType() {
            return this.method != null ? this.method.getReturnType() : Object.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Invocation {
        private final List<Expression> arguments = new ArrayList<Expression>();

        public List<Expression> getArguments() {
            return this.arguments;
        }

        public void addArgument(Expression argument) {
            this.arguments.add(argument);
        }

        public abstract Class<?> getReturnType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AritmeticExpression
    implements Expression {
        final Class<?> type;
        final Expression left;
        final AritmeticOperator operator;
        final Expression right;

        public AritmeticExpression(Class<?> type, Expression left, AritmeticOperator operator, Expression right) {
            if (operator.isBitwiseOperation()) {
                type = left instanceof VariableExpression ? ((VariableExpression)left).getVariableType() : left.getType();
            }
            this.type = type;
            this.left = left;
            this.operator = operator;
            this.right = right;
        }

        @Override
        public boolean isFixed() {
            return false;
        }

        @Override
        public boolean canBeNull() {
            return true;
        }

        @Override
        public Class<?> getType() {
            if (this.isStringConcat()) {
                return String.class;
            }
            if (this.type == Integer.class) {
                return Integer.TYPE;
            }
            if (this.type == Long.class) {
                return Long.TYPE;
            }
            return Double.TYPE;
        }

        public String toString() {
            return this.left + " " + (Object)((Object)this.operator) + " " + this.right;
        }

        public boolean isStringConcat() {
            return this.operator == AritmeticOperator.ADD && (this.left.getType() == String.class || this.right.getType() == String.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EvaluatedExpression
    implements Expression {
        final List<Invocation> invocations = new ArrayList<Invocation>();

        void addInvocation(Invocation invocation) {
            this.invocations.add(invocation);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Iterator<Invocation> i = this.invocations.iterator();
            while (i.hasNext()) {
                sb.append(i.next());
                if (!i.hasNext()) continue;
                sb.append(" . ");
            }
            return sb.toString();
        }

        @Override
        public boolean isFixed() {
            return false;
        }

        @Override
        public boolean canBeNull() {
            return true;
        }

        @Override
        public Class<?> getType() {
            return this.invocations.get(this.invocations.size() - 1).getReturnType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VariableExpression
    implements Expression {
        final String variableName;
        final EvaluatedExpression subsequentInvocations;
        final Class<?> type;

        VariableExpression(String variableName, EvaluatedExpression subsequentInvocations, Class<?> type) {
            this.variableName = variableName;
            this.subsequentInvocations = subsequentInvocations;
            this.type = type;
        }

        @Override
        public boolean isFixed() {
            return false;
        }

        @Override
        public boolean canBeNull() {
            return true;
        }

        @Override
        public Class<?> getType() {
            return this.subsequentInvocations != null ? this.subsequentInvocations.getType() : Object.class;
        }

        public Class<?> getVariableType() {
            return this.subsequentInvocations != null ? this.subsequentInvocations.getType() : this.type;
        }

        public String toString() {
            return this.variableName + (this.subsequentInvocations == null ? "" : " . " + this.subsequentInvocations);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FixedExpression
    implements Expression {
        final TypedValue typedValue;

        FixedExpression(TypedValue value) {
            this.typedValue = value;
        }

        FixedExpression(Class<?> type, Object value) {
            this(new TypedValue(type, value));
        }

        public String toString() {
            return this.typedValue.toString();
        }

        @Override
        public boolean isFixed() {
            return true;
        }

        @Override
        public boolean canBeNull() {
            return this.typedValue.value == null;
        }

        @Override
        public Class<?> getType() {
            return this.typedValue.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Expression {
        public boolean isFixed();

        public boolean canBeNull();

        public Class<?> getType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CombinedCondition
    extends Condition {
        private final boolean isAnd;
        private List<Condition> conditions = new ArrayList<Condition>();

        protected CombinedCondition(boolean isAnd, boolean negated) {
            super(negated);
            this.isAnd = isAnd;
        }

        private void addCondition(Condition condition) {
            if (condition instanceof CombinedCondition && this.isAnd() == ((CombinedCondition)condition).isAnd()) {
                this.conditions.addAll(((CombinedCondition)condition).getConditions());
            } else {
                this.conditions.add(condition);
            }
        }

        public boolean isAnd() {
            return this.isAnd;
        }

        public List<Condition> getConditions() {
            return this.conditions;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.isNegated() ? "not (" : "(");
            Iterator<Condition> i = this.conditions.iterator();
            while (i.hasNext()) {
                sb.append(i.next());
                if (!i.hasNext()) continue;
                sb.append(this.isAnd ? " and " : " or ");
            }
            return sb.append(")").toString();
        }
    }

    public static class SingleCondition
    extends Condition {
        private Expression left;
        private BooleanOperator operation;
        private Expression right;

        protected SingleCondition(boolean negated) {
            super(negated);
        }

        public Expression getLeft() {
            return this.left;
        }

        public Expression getRight() {
            return this.right;
        }

        public boolean isBinary() {
            return this.operation != null;
        }

        public BooleanOperator getOperation() {
            return this.operation;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.isNegated() ? "not " : "");
            sb.append(this.left);
            if (this.isBinary()) {
                sb.append(" ").append((Object)this.operation);
                sb.append(" ").append(this.right);
            }
            return sb.toString();
        }
    }

    public static abstract class Condition {
        private boolean negated;

        protected Condition(boolean negated) {
            this.negated = negated;
        }

        public boolean isNegated() {
            return this.negated;
        }

        public void toggleNegation() {
            this.negated = !this.negated;
        }
    }
}

