/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.constraint;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.base.DroolsQuery;
import org.drools.base.extractors.ArrayElementReader;
import org.drools.common.AbstractRuleBase;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.StringUtils;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.rule.IndexEvaluator;
import org.drools.rule.IndexableConstraint;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.MutableTypeConstraint;
import org.drools.rule.constraint.ASMConditionEvaluatorJitter;
import org.drools.rule.constraint.ConditionAnalyzer;
import org.drools.rule.constraint.ConditionEvaluator;
import org.drools.rule.constraint.MvelConditionEvaluator;
import org.drools.runtime.rule.Variable;
import org.drools.spi.InternalReadAccessor;
import org.drools.util.CompositeClassLoader;
import org.mvel2.ParserConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MvelConstraint
extends MutableTypeConstraint
implements IndexableConstraint {
    private static final boolean TEST_JITTING = false;
    private static final int JIT_THRESOLD = 20;
    private transient AtomicInteger invocationCounter = new AtomicInteger(1);
    private transient boolean jitted = false;
    private String packageName;
    private String expression;
    private boolean isIndexable;
    private Declaration[] declarations;
    private Declaration indexingDeclaration;
    private InternalReadAccessor extractor;
    private boolean isUnification;
    private transient ConditionEvaluator conditionEvaluator;
    private transient ConditionAnalyzer.Condition analyzedCondition;
    public static final IndexEvaluator INDEX_EVALUATOR = new PlainIndexEvaluator();

    public MvelConstraint() {
    }

    public MvelConstraint(String packageName, String expression) {
        this(packageName, expression, false, null, null, null, false);
    }

    public MvelConstraint(String packageName, String expression, boolean isIndexable, Declaration[] declarations, Declaration indexingDeclaration, InternalReadAccessor extractor, boolean isUnification) {
        this.packageName = packageName;
        this.expression = expression;
        this.isIndexable = isIndexable;
        this.declarations = declarations == null ? new Declaration[]{} : declarations;
        this.indexingDeclaration = indexingDeclaration;
        this.extractor = extractor;
        this.isUnification = isUnification;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getExpression() {
        return this.expression;
    }

    @Override
    public boolean isUnification() {
        return this.isUnification;
    }

    public void unsetUnification() {
        this.isUnification = false;
    }

    @Override
    public boolean isIndexable() {
        return this.isIndexable && this.indexingDeclaration != null;
    }

    @Override
    public boolean isAllowed(InternalFactHandle handle, InternalWorkingMemory workingMemory, ContextEntry context) {
        if (this.isUnification) {
            throw new UnsupportedOperationException("Should not be called");
        }
        Map<String, Object> vars = context == null ? null : ((MvelContextEntry)context).getRightVars(workingMemory, handle);
        return this.evaluate(handle.getObject(), workingMemory, vars);
    }

    @Override
    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        if (this.isUnification) {
            if (((UnificationContextEntry)context).getVariable() != null) {
                return true;
            }
            context = ((UnificationContextEntry)context).getContextEntry();
        }
        MvelContextEntry mvelContextEntry = (MvelContextEntry)context;
        return this.evaluate(handle.getObject(), mvelContextEntry.workingMemory, mvelContextEntry.vars);
    }

    @Override
    public boolean isAllowedCachedRight(LeftTuple tuple, ContextEntry context) {
        if (this.isUnification) {
            DroolsQuery query = (DroolsQuery)tuple.get(0).getObject();
            Variable v = query.getVariables()[((UnificationContextEntry)context).getReader().getIndex()];
            if (v != null) {
                return true;
            }
            context = ((UnificationContextEntry)context).getContextEntry();
        }
        MvelContextEntry mvelContextEntry = (MvelContextEntry)context;
        return this.evaluate(mvelContextEntry.right, mvelContextEntry.workingMemory, mvelContextEntry.getRightVars(tuple));
    }

    private boolean evaluate(Object object, InternalWorkingMemory workingMemory, Map<String, Object> vars) {
        if (!this.jitted) {
            if (this.conditionEvaluator == null) {
                this.createMvelConditionEvaluator(workingMemory);
            } else if (this.invocationCounter.getAndIncrement() == 20) {
                this.jitEvaluator(workingMemory, object, vars);
            }
        }
        return this.conditionEvaluator.evaluate(object, vars);
    }

    private void createMvelConditionEvaluator(InternalWorkingMemory workingMemory) {
        this.conditionEvaluator = new MvelConditionEvaluator(this.getParserConfiguration(workingMemory), this.expression);
    }

    private boolean forceJitEvaluator(InternalWorkingMemory workingMemory, Object object, Map<String, Object> vars) {
        boolean mvelValue;
        try {
            mvelValue = this.conditionEvaluator.evaluate(object, vars);
        }
        catch (ClassCastException cce) {
            mvelValue = false;
        }
        this.jitEvaluator(workingMemory, object, vars);
        return mvelValue;
    }

    private void jitEvaluator(InternalWorkingMemory workingMemory, Object object, Map<String, Object> vars) {
        this.jitted = true;
        try {
            CompositeClassLoader classLoader = ((AbstractRuleBase)workingMemory.getRuleBase()).getRootClassLoader();
            if (this.analyzedCondition == null) {
                this.analyzedCondition = ((MvelConditionEvaluator)this.conditionEvaluator).getAnalyzedCondition(object, vars);
            }
            this.conditionEvaluator = ASMConditionEvaluatorJitter.jit(this.analyzedCondition, (ClassLoader)classLoader);
        }
        catch (Throwable t) {
            throw new RuntimeException("Exception jitting: " + this.expression, t);
        }
    }

    @Override
    public ContextEntry createContextEntry() {
        if (this.declarations.length == 0) {
            return null;
        }
        ContextEntry contextEntry = new MvelContextEntry(this.declarations);
        if (this.isUnification) {
            contextEntry = new UnificationContextEntry(contextEntry, this.declarations[0]);
        }
        return contextEntry;
    }

    @Override
    public AbstractHashTable.FieldIndex getFieldIndex() {
        this.indexingDeclaration.getPattern().setOffset(this.declarations[0].getPattern().getOffset());
        return new AbstractHashTable.FieldIndex(this.extractor, this.indexingDeclaration, INDEX_EVALUATOR);
    }

    public InternalReadAccessor getFieldExtractor() {
        return this.extractor;
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        return this.declarations;
    }

    public Declaration getIndexingDeclaration() {
        return this.indexingDeclaration;
    }

    @Override
    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        for (int i = 0; i < this.declarations.length; ++i) {
            if (!this.declarations[i].equals(oldDecl)) continue;
            this.declarations[i] = newDecl;
            break;
        }
        if (this.indexingDeclaration != null && this.indexingDeclaration.equals(oldDecl)) {
            this.indexingDeclaration = newDecl;
        }
    }

    public long getListenedPropertyMask(List<String> settableProperties) {
        if (this.conditionEvaluator == null) {
            return this.calculateMaskFromExpression(settableProperties);
        }
        if (this.analyzedCondition == null) {
            this.analyzedCondition = ((MvelConditionEvaluator)this.conditionEvaluator).getAnalyzedCondition();
        }
        return this.calculateMask(this.analyzedCondition, settableProperties);
    }

    private long calculateMaskFromExpression(List<String> settableProperties) {
        int pos;
        StringBuilder propertyNameBuilder = new StringBuilder();
        int cursor = StringUtils.extractFirstIdentifier(this.expression, propertyNameBuilder, 0);
        String propertyName = propertyNameBuilder.toString();
        if (propertyName.equals("this")) {
            StringUtils.extractFirstIdentifier(this.expression, propertyNameBuilder, cursor);
            propertyName = propertyNameBuilder.toString();
        }
        if ((pos = settableProperties.indexOf(propertyName)) < 0) {
            throw new RuntimeException("Unknown property: " + propertyName);
        }
        return 1L << pos;
    }

    private long calculateMask(ConditionAnalyzer.Condition condition, List<String> settableProperties) {
        if (condition instanceof ConditionAnalyzer.SingleCondition) {
            return this.calculateMask((ConditionAnalyzer.SingleCondition)condition, settableProperties);
        }
        long mask = 0L;
        for (ConditionAnalyzer.Condition c : ((ConditionAnalyzer.CombinedCondition)condition).getConditions()) {
            mask |= this.calculateMask(c, settableProperties);
        }
        return mask;
    }

    private long calculateMask(ConditionAnalyzer.SingleCondition condition, List<String> settableProperties) {
        Method method = this.getFirstInvokedMethod(condition.getLeft());
        if (method == null) {
            return Long.MAX_VALUE;
        }
        String propertyName = ClassUtils.getter2property(method.getName());
        if (propertyName != null) {
            int pos = settableProperties.indexOf(propertyName);
            if (pos < 0) {
                throw new RuntimeException("Unknown property: " + propertyName);
            }
            return 1L << pos;
        }
        return Long.MAX_VALUE;
    }

    private Method getFirstInvokedMethod(ConditionAnalyzer.Expression expression) {
        if (!(expression instanceof ConditionAnalyzer.EvaluatedExpression)) {
            return null;
        }
        List<ConditionAnalyzer.Invocation> invocations = ((ConditionAnalyzer.EvaluatedExpression)expression).invocations;
        ConditionAnalyzer.Invocation invocation = invocations.get(0);
        if (!(invocation instanceof ConditionAnalyzer.MethodInvocation)) {
            return null;
        }
        Method method = ((ConditionAnalyzer.MethodInvocation)invocation).getMethod();
        if (method == null && invocations.size() > 1 && (invocation = invocations.get(1)) instanceof ConditionAnalyzer.MethodInvocation) {
            method = ((ConditionAnalyzer.MethodInvocation)invocation).getMethod();
        }
        return method;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.packageName);
        out.writeObject(this.expression);
        out.writeObject(this.declarations);
        out.writeObject(this.indexingDeclaration);
        out.writeObject(this.extractor);
        out.writeBoolean(this.isIndexable);
        out.writeBoolean(this.isUnification);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.packageName = (String)in.readObject();
        this.expression = (String)in.readObject();
        this.declarations = (Declaration[])in.readObject();
        this.indexingDeclaration = (Declaration)in.readObject();
        this.extractor = (InternalReadAccessor)in.readObject();
        this.isIndexable = in.readBoolean();
        this.isUnification = in.readBoolean();
    }

    @Override
    public boolean isTemporal() {
        return false;
    }

    @Override
    public Object clone() {
        return new MvelConstraint(this.packageName, this.expression, this.isIndexable, this.declarations, this.indexingDeclaration, this.extractor, this.isUnification);
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != MvelConstraint.class) {
            return false;
        }
        return this.expression.equals(((MvelConstraint)object).expression);
    }

    public String toString() {
        return this.expression;
    }

    private ParserConfiguration getParserConfiguration(InternalWorkingMemory workingMemory) {
        return ((MVELDialectRuntimeData)workingMemory.getRuleBase().getPackage(this.packageName).getDialectRuntimeRegistry().getDialectData("mvel")).getParserConfiguration();
    }

    public static class PlainIndexEvaluator
    implements IndexEvaluator {
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 == null;
            }
            if (value1 instanceof String) {
                return value1.equals(value2.toString());
            }
            return value1.equals(value2);
        }
    }

    public static class UnificationContextEntry
    implements ContextEntry {
        private ContextEntry contextEntry;
        private Declaration declaration;
        private Variable variable;
        private ArrayElementReader reader;

        public UnificationContextEntry() {
        }

        public UnificationContextEntry(ContextEntry contextEntry, Declaration declaration) {
            this.contextEntry = contextEntry;
            this.declaration = declaration;
            this.reader = (ArrayElementReader)this.declaration.getExtractor();
        }

        public ContextEntry getContextEntry() {
            return this.contextEntry;
        }

        public ArrayElementReader getReader() {
            return this.reader;
        }

        public ContextEntry getNext() {
            return this.contextEntry.getNext();
        }

        public void resetFactHandle() {
            this.contextEntry.resetFactHandle();
        }

        public void resetTuple() {
            this.contextEntry.resetTuple();
            this.variable = null;
        }

        public void setNext(ContextEntry entry) {
            this.contextEntry.setNext(entry);
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.contextEntry.updateFromFactHandle(workingMemory, handle);
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            DroolsQuery query = (DroolsQuery)tuple.get(0).getObject();
            Variable v = query.getVariables()[this.reader.getIndex()];
            if (v == null) {
                this.variable = null;
                this.contextEntry.updateFromTuple(workingMemory, tuple);
            } else {
                this.variable = v;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.contextEntry = (ContextEntry)in.readObject();
            this.declaration = (Declaration)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.contextEntry);
            out.writeObject(this.declaration);
        }

        public Variable getVariable() {
            return this.variable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MvelContextEntry
    implements ContextEntry {
        private Object left;
        private Object right;
        private Declaration[] declarations;
        private ContextEntry next;
        private transient Map<String, Object> vars;
        private transient InternalWorkingMemory workingMemory;

        public MvelContextEntry() {
        }

        public MvelContextEntry(Declaration[] declarations) {
            this.declarations = declarations;
            if (declarations.length > 0) {
                this.vars = new HashMap<String, Object>();
            }
        }

        @Override
        public ContextEntry getNext() {
            return this.next;
        }

        @Override
        public void setNext(ContextEntry entry) {
            this.next = entry;
        }

        @Override
        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.workingMemory = workingMemory;
            Declaration declaration = this.declarations[0];
            InternalFactHandle handle = tuple.get(declaration);
            this.left = declaration.getExtractor().getValue(workingMemory, handle.getObject());
            if (this.declarations.length == 1) {
                this.vars.put(declaration.getBindingName(), this.left);
            } else {
                this.getRightVars(tuple);
            }
        }

        @Override
        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.workingMemory = workingMemory;
            this.right = handle.getObject();
        }

        Map<String, Object> getRightVars(LeftTuple tuple) {
            if (this.declarations.length == 0) {
                return null;
            }
            for (Declaration declaration : this.declarations) {
                try {
                    this.vars.put(declaration.getBindingName(), declaration.getExtractor().getValue(this.workingMemory, tuple.get(declaration).getObject()));
                }
                catch (NullPointerException npe) {
                    this.vars.put(declaration.getBindingName(), this.declarations[0].getExtractor().getValue(this.workingMemory, tuple.get(this.declarations[0]).getObject()));
                }
            }
            return this.vars;
        }

        Map<String, Object> getRightVars(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            if (this.declarations.length == 0) {
                return null;
            }
            for (Declaration declaration : this.declarations) {
                this.vars.put(declaration.getBindingName(), declaration.getExtractor().getValue(workingMemory, handle.getObject()));
            }
            return this.vars;
        }

        @Override
        public void resetTuple() {
            this.left = null;
            if (this.vars != null) {
                this.vars.clear();
            }
        }

        @Override
        public void resetFactHandle() {
            this.workingMemory = null;
            this.right = null;
            if (this.vars != null) {
                this.vars.clear();
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.left = in.readObject();
            this.right = in.readObject();
            this.declarations = (Declaration[])in.readObject();
            this.next = (ContextEntry)in.readObject();
            if (this.declarations.length > 0) {
                this.vars = new HashMap<String, Object>();
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.left);
            out.writeObject(this.right);
            out.writeObject(this.declarations);
            out.writeObject(this.next);
        }
    }
}

