/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.config;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.drools.planner.benchmark.api.PlannerBenchmark;
import org.drools.planner.benchmark.config.PlannerBenchmarkConfig;
import org.drools.planner.config.XmlSolverFactory;

public class XmlPlannerBenchmarkFactory {
    private XStream xStream = XmlSolverFactory.buildXstream();
    private PlannerBenchmarkConfig plannerBenchmarkConfig = null;

    public XmlPlannerBenchmarkFactory() {
        this.xStream.processAnnotations(PlannerBenchmarkConfig.class);
    }

    public void addXstreamAnnotations(Class ... xstreamAnnotations) {
        this.xStream.processAnnotations(xstreamAnnotations);
    }

    public XmlPlannerBenchmarkFactory configure(String resource) {
        InputStream in = this.getClass().getResourceAsStream(resource);
        if (in == null) {
            throw new IllegalArgumentException("Resource not found: " + resource);
        }
        return this.configure(in);
    }

    public XmlPlannerBenchmarkFactory configure(InputStream in) {
        XmlPlannerBenchmarkFactory xmlPlannerBenchmarkFactory;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(in, "UTF-8");
            xmlPlannerBenchmarkFactory = this.configure(reader);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new IllegalStateException("This vm does not support UTF-8 encoding.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)in);
        return xmlPlannerBenchmarkFactory;
    }

    public XmlPlannerBenchmarkFactory configure(Reader reader) {
        this.plannerBenchmarkConfig = (PlannerBenchmarkConfig)this.xStream.fromXML(reader);
        return this;
    }

    public PlannerBenchmarkConfig getPlannerBenchmarkConfig() {
        if (this.plannerBenchmarkConfig == null) {
            throw new IllegalStateException("The plannerBenchmarkConfig (" + this.plannerBenchmarkConfig + ") is null," + " call configure(...) first.");
        }
        return this.plannerBenchmarkConfig;
    }

    public PlannerBenchmark buildPlannerBenchmark() {
        if (this.plannerBenchmarkConfig == null) {
            throw new IllegalStateException("The plannerBenchmarkConfig (" + this.plannerBenchmarkConfig + ") is null," + " call configure(...) first.");
        }
        return this.plannerBenchmarkConfig.buildPlannerBenchmark();
    }
}

