/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.core;

import java.io.File;
import java.util.List;
import org.drools.planner.benchmark.api.ProblemIO;
import org.drools.planner.benchmark.core.PlannerBenchmarkResult;
import org.drools.planner.benchmark.core.SolverBenchmark;
import org.drools.planner.benchmark.core.statistic.ProblemStatistic;
import org.drools.planner.config.termination.TerminationConfig;
import org.drools.planner.core.Solver;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solver.DefaultSolver;
import org.drools.planner.core.solver.DefaultSolverScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemBenchmark {
    private String name = null;
    private ProblemIO problemIO = null;
    private File inputSolutionFile = null;
    private File outputSolutionFilesDirectory = null;
    private List<ProblemStatistic> problemStatisticList = null;
    private List<PlannerBenchmarkResult> plannerBenchmarkResultList = null;
    private PlannerBenchmarkResult winningPlannerBenchmarkResult = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProblemIO getProblemIO() {
        return this.problemIO;
    }

    public void setProblemIO(ProblemIO problemIO) {
        this.problemIO = problemIO;
    }

    public File getInputSolutionFile() {
        return this.inputSolutionFile;
    }

    public void setInputSolutionFile(File inputSolutionFile) {
        this.inputSolutionFile = inputSolutionFile;
    }

    public File getOutputSolutionFilesDirectory() {
        return this.outputSolutionFilesDirectory;
    }

    public void setOutputSolutionFilesDirectory(File outputSolutionFilesDirectory) {
        this.outputSolutionFilesDirectory = outputSolutionFilesDirectory;
    }

    public List<ProblemStatistic> getProblemStatisticList() {
        return this.problemStatisticList;
    }

    public void setProblemStatisticList(List<ProblemStatistic> problemStatisticList) {
        this.problemStatisticList = problemStatisticList;
    }

    public List<PlannerBenchmarkResult> getPlannerBenchmarkResultList() {
        return this.plannerBenchmarkResultList;
    }

    public void setPlannerBenchmarkResultList(List<PlannerBenchmarkResult> plannerBenchmarkResultList) {
        this.plannerBenchmarkResultList = plannerBenchmarkResultList;
    }

    public PlannerBenchmarkResult getWinningPlannerBenchmarkResult() {
        return this.winningPlannerBenchmarkResult;
    }

    public void setWinningPlannerBenchmarkResult(PlannerBenchmarkResult winningPlannerBenchmarkResult) {
        this.winningPlannerBenchmarkResult = winningPlannerBenchmarkResult;
    }

    public void benchmarkingStarted() {
    }

    public void benchmark() {
        for (PlannerBenchmarkResult result : this.plannerBenchmarkResultList) {
            SolverBenchmark solverBenchmark = result.getSolverBenchmark();
            Solver solver = solverBenchmark.getSolverConfig().buildSolver();
            for (ProblemStatistic statistic : this.problemStatisticList) {
                statistic.addListener(solver, solverBenchmark.getName());
            }
            solver.setPlanningProblem(this.readPlanningProblem());
            solver.solve();
            Solution outputSolution = solver.getBestSolution();
            result.setTimeMillisSpend(solver.getTimeMillisSpend());
            DefaultSolverScope solverScope = ((DefaultSolver)solver).getSolverScope();
            result.setCalculateCount(solverScope.getCalculateCount());
            result.setScore((Score)outputSolution.getScore());
            SolutionDescriptor solutionDescriptor = ((DefaultSolver)solver).getSolutionDescriptor();
            result.setPlanningEntityCount(solutionDescriptor.getPlanningEntityCount(outputSolution));
            result.setProblemScale(solutionDescriptor.getProblemScale(outputSolution));
            for (ProblemStatistic statistic : this.problemStatisticList) {
                statistic.removeListener(solver, solverBenchmark.getName());
            }
            this.writeSolution(result, outputSolution);
        }
    }

    public long warmUp(long startingTimeMillis, long warmUpTimeMillisSpend, long timeLeft) {
        for (PlannerBenchmarkResult result : this.plannerBenchmarkResultList) {
            SolverBenchmark solverBenchmark = result.getSolverBenchmark();
            TerminationConfig originalTerminationConfig = solverBenchmark.getSolverConfig().getTerminationConfig();
            TerminationConfig tmpTerminationConfig = originalTerminationConfig.clone();
            tmpTerminationConfig.shortenMaximumTimeMillisSpendTotal(timeLeft);
            solverBenchmark.getSolverConfig().setTerminationConfig(tmpTerminationConfig);
            Solver solver = solverBenchmark.getSolverConfig().buildSolver();
            solver.setPlanningProblem(this.readPlanningProblem());
            solver.solve();
            solverBenchmark.getSolverConfig().setTerminationConfig(originalTerminationConfig);
            long timeSpend = System.currentTimeMillis() - startingTimeMillis;
            timeLeft = warmUpTimeMillisSpend - timeSpend;
            if (timeLeft > 0L) continue;
            return timeLeft;
        }
        return timeLeft;
    }

    public Solution readPlanningProblem() {
        return this.problemIO.read(this.inputSolutionFile);
    }

    private void writeSolution(PlannerBenchmarkResult result, Solution outputSolution) {
        String solverBenchmarkName = result.getSolverBenchmark().getName().replaceAll(" ", "_").replaceAll("[^\\w\\d_\\-]", "");
        String filename = this.name + "_" + solverBenchmarkName + "." + this.problemIO.getFileExtension();
        File outputSolutionFile = new File(this.outputSolutionFilesDirectory, filename);
        this.problemIO.write(outputSolution, outputSolutionFile);
    }

    public void benchmarkingEnded() {
        this.determineWinningResult();
        this.determineWinningResultScoreDifference();
    }

    private void determineWinningResult() {
        this.winningPlannerBenchmarkResult = null;
        for (PlannerBenchmarkResult result : this.plannerBenchmarkResultList) {
            if (this.winningPlannerBenchmarkResult != null && result.getScore().compareTo(this.winningPlannerBenchmarkResult.getScore()) <= 0) continue;
            this.winningPlannerBenchmarkResult = result;
        }
    }

    private void determineWinningResultScoreDifference() {
        for (PlannerBenchmarkResult result : this.plannerBenchmarkResultList) {
            result.setWinningScoreDifference(result.getScore().subtract(this.winningPlannerBenchmarkResult.getScore()));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ProblemBenchmark) {
            ProblemBenchmark other = (ProblemBenchmark)o;
            return this.inputSolutionFile.equals(other.getInputSolutionFile());
        }
        return false;
    }

    public int hashCode() {
        return this.inputSolutionFile.hashCode();
    }
}

