/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.localsearch;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.localsearch.decider.acceptor.AcceptorConfig;
import org.drools.planner.config.localsearch.decider.forager.ForagerConfig;
import org.drools.planner.config.localsearch.decider.selector.SelectorConfig;
import org.drools.planner.config.phase.SolverPhaseConfig;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.localsearch.DefaultLocalSearchSolverPhase;
import org.drools.planner.core.localsearch.LocalSearchSolverPhase;
import org.drools.planner.core.localsearch.decider.Decider;
import org.drools.planner.core.localsearch.decider.DefaultDecider;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.termination.Termination;

@XStreamAlias(value="localSearch")
public class LocalSearchSolverPhaseConfig
extends SolverPhaseConfig {
    @XStreamAlias(value="selector")
    private SelectorConfig selectorConfig = new SelectorConfig();
    @XStreamAlias(value="acceptor")
    private AcceptorConfig acceptorConfig = new AcceptorConfig();
    @XStreamAlias(value="forager")
    private ForagerConfig foragerConfig = new ForagerConfig();

    public SelectorConfig getSelectorConfig() {
        return this.selectorConfig;
    }

    public void setSelectorConfig(SelectorConfig selectorConfig) {
        this.selectorConfig = selectorConfig;
    }

    public AcceptorConfig getAcceptorConfig() {
        return this.acceptorConfig;
    }

    public void setAcceptorConfig(AcceptorConfig acceptorConfig) {
        this.acceptorConfig = acceptorConfig;
    }

    public ForagerConfig getForagerConfig() {
        return this.foragerConfig;
    }

    public void setForagerConfig(ForagerConfig foragerConfig) {
        this.foragerConfig = foragerConfig;
    }

    public LocalSearchSolverPhase buildSolverPhase(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, ScoreDefinition scoreDefinition, Termination solverTermination) {
        DefaultLocalSearchSolverPhase localSearchSolverPhase = new DefaultLocalSearchSolverPhase();
        this.configureSolverPhase(localSearchSolverPhase, environmentMode, scoreDefinition, solverTermination);
        localSearchSolverPhase.setDecider(this.buildDecider(environmentMode, scoreDefinition));
        if (environmentMode == EnvironmentMode.DEBUG || environmentMode == EnvironmentMode.TRACE) {
            localSearchSolverPhase.setAssertStepScoreIsUncorrupted(true);
        }
        return localSearchSolverPhase;
    }

    private Decider buildDecider(EnvironmentMode environmentMode, ScoreDefinition scoreDefinition) {
        DefaultDecider decider = new DefaultDecider();
        decider.setSelector(this.selectorConfig.buildSelector(scoreDefinition));
        decider.setAcceptor(this.acceptorConfig.buildAcceptor(environmentMode, scoreDefinition));
        decider.setForager(this.foragerConfig.buildForager(scoreDefinition));
        if (environmentMode == EnvironmentMode.TRACE) {
            decider.setAssertMoveScoreIsUncorrupted(true);
        }
        if (environmentMode == EnvironmentMode.DEBUG || environmentMode == EnvironmentMode.TRACE) {
            decider.setAssertUndoMoveIsUncorrupted(true);
        }
        return decider;
    }

    public void inherit(LocalSearchSolverPhaseConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        if (this.selectorConfig == null) {
            this.selectorConfig = inheritedConfig.getSelectorConfig();
        } else if (inheritedConfig.getSelectorConfig() != null) {
            this.selectorConfig.inherit(inheritedConfig.getSelectorConfig());
        }
        if (this.acceptorConfig == null) {
            this.acceptorConfig = inheritedConfig.getAcceptorConfig();
        } else if (inheritedConfig.getAcceptorConfig() != null) {
            this.acceptorConfig.inherit(inheritedConfig.getAcceptorConfig());
        }
        if (this.foragerConfig == null) {
            this.foragerConfig = inheritedConfig.getForagerConfig();
        } else if (inheritedConfig.getForagerConfig() != null) {
            this.foragerConfig.inherit(inheritedConfig.getForagerConfig());
        }
    }
}

