/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.constructionheuristic.greedyFit;

import java.util.Iterator;
import org.drools.planner.core.constructionheuristic.greedyFit.GreedyFitSolverPhase;
import org.drools.planner.core.constructionheuristic.greedyFit.GreedyFitSolverPhaseScope;
import org.drools.planner.core.constructionheuristic.greedyFit.GreedyFitStepScope;
import org.drools.planner.core.constructionheuristic.greedyFit.decider.GreedyDecider;
import org.drools.planner.core.constructionheuristic.greedyFit.selector.GreedyPlanningEntitySelector;
import org.drools.planner.core.phase.AbstractSolverPhase;
import org.drools.planner.core.solver.DefaultSolverScope;

public class DefaultGreedyFitSolverPhase
extends AbstractSolverPhase
implements GreedyFitSolverPhase {
    protected GreedyPlanningEntitySelector greedyPlanningEntitySelector;
    protected GreedyDecider greedyDecider;
    protected boolean assertStepScoreIsUncorrupted = false;

    public void setGreedyPlanningEntitySelector(GreedyPlanningEntitySelector greedyPlanningEntitySelector) {
        this.greedyPlanningEntitySelector = greedyPlanningEntitySelector;
    }

    public void setGreedyDecider(GreedyDecider greedyDecider) {
        this.greedyDecider = greedyDecider;
    }

    public void setAssertStepScoreIsUncorrupted(boolean assertStepScoreIsUncorrupted) {
        this.assertStepScoreIsUncorrupted = assertStepScoreIsUncorrupted;
    }

    public void solve(DefaultSolverScope solverScope) {
        GreedyFitSolverPhaseScope greedyFitSolverPhaseScope = new GreedyFitSolverPhaseScope(solverScope);
        this.phaseStarted(greedyFitSolverPhaseScope);
        GreedyFitStepScope greedyFitStepScope = this.createNextStepScope(greedyFitSolverPhaseScope, null);
        Iterator<Object> it = this.greedyPlanningEntitySelector.iterator();
        while (!this.termination.isPhaseTerminated(greedyFitSolverPhaseScope) && it.hasNext()) {
            Object planningEntity = it.next();
            greedyFitStepScope.setPlanningEntity(planningEntity);
            this.beforeDeciding(greedyFitStepScope);
            this.greedyDecider.decideNextStep(greedyFitStepScope);
            this.stepDecided(greedyFitStepScope);
            greedyFitStepScope.doStep();
            if (!it.hasNext()) {
                greedyFitStepScope.setSolutionInitialized(true);
            }
            if (this.assertStepScoreIsUncorrupted) {
                greedyFitSolverPhaseScope.assertWorkingScore(greedyFitStepScope.getScore());
            }
            this.stepTaken(greedyFitStepScope);
            greedyFitStepScope = this.createNextStepScope(greedyFitSolverPhaseScope, greedyFitStepScope);
        }
        this.phaseEnded(greedyFitSolverPhaseScope);
    }

    private GreedyFitStepScope createNextStepScope(GreedyFitSolverPhaseScope greedyFitSolverPhaseScope, GreedyFitStepScope completedGreedyFitStepScope) {
        if (completedGreedyFitStepScope == null) {
            completedGreedyFitStepScope = new GreedyFitStepScope(greedyFitSolverPhaseScope);
            completedGreedyFitStepScope.setScore(greedyFitSolverPhaseScope.getStartingScore());
            completedGreedyFitStepScope.setStepIndex(-1);
        }
        greedyFitSolverPhaseScope.setLastCompletedGreedyFitStepScope(completedGreedyFitStepScope);
        GreedyFitStepScope greedyFitStepScope = new GreedyFitStepScope(greedyFitSolverPhaseScope);
        greedyFitStepScope.setStepIndex(completedGreedyFitStepScope.getStepIndex() + 1);
        greedyFitStepScope.setSolutionInitialized(false);
        return greedyFitStepScope;
    }

    public void phaseStarted(GreedyFitSolverPhaseScope greedyFitSolverPhaseScope) {
        super.phaseStarted(greedyFitSolverPhaseScope);
        this.greedyPlanningEntitySelector.phaseStarted(greedyFitSolverPhaseScope);
        this.greedyDecider.phaseStarted(greedyFitSolverPhaseScope);
    }

    public void beforeDeciding(GreedyFitStepScope greedyFitStepScope) {
        super.beforeDeciding(greedyFitStepScope);
        this.greedyPlanningEntitySelector.beforeDeciding(greedyFitStepScope);
        this.greedyDecider.beforeDeciding(greedyFitStepScope);
    }

    public void stepDecided(GreedyFitStepScope greedyFitStepScope) {
        super.stepDecided(greedyFitStepScope);
        this.greedyPlanningEntitySelector.stepDecided(greedyFitStepScope);
        this.greedyDecider.stepDecided(greedyFitStepScope);
    }

    public void stepTaken(GreedyFitStepScope greedyFitStepScope) {
        super.stepTaken(greedyFitStepScope);
        this.greedyPlanningEntitySelector.stepTaken(greedyFitStepScope);
        this.greedyDecider.stepTaken(greedyFitStepScope);
        this.logger.debug("    Step index ({}), time spend ({}), score ({}), initialized planning entity ({}).", new Object[]{greedyFitStepScope.getStepIndex(), greedyFitStepScope.getGreedyFitSolverPhaseScope().calculateSolverTimeMillisSpend(), greedyFitStepScope.getScore(), greedyFitStepScope.getPlanningEntity()});
    }

    public void phaseEnded(GreedyFitSolverPhaseScope greedyFitSolverPhaseScope) {
        super.phaseEnded(greedyFitSolverPhaseScope);
        this.greedyPlanningEntitySelector.phaseEnded(greedyFitSolverPhaseScope);
        this.greedyDecider.phaseEnded(greedyFitSolverPhaseScope);
        this.logger.info("Phase construction heuristic ended: step total ({}), time spend ({}), best score ({}).", new Object[]{greedyFitSolverPhaseScope.getLastCompletedStepScope().getStepIndex() + 1, greedyFitSolverPhaseScope.calculateSolverTimeMillisSpend(), greedyFitSolverPhaseScope.getBestScore()});
    }
}

