/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.domain.variable;

import java.beans.PropertyDescriptor;
import java.util.Collection;
import org.drools.planner.api.domain.variable.ValueRangeFromPlanningEntityProperty;
import org.drools.planner.core.domain.common.DescriptorUtils;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.variable.AbstractPlanningValueRangeDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.solution.Solution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanningEntityPropertyPlanningValueRangeDescriptor
extends AbstractPlanningValueRangeDescriptor {
    private PropertyDescriptor rangePropertyDescriptor;

    public PlanningEntityPropertyPlanningValueRangeDescriptor(PlanningVariableDescriptor variableDescriptor, ValueRangeFromPlanningEntityProperty valueRangeFromPlanningEntityPropertyAnnotation) {
        super(variableDescriptor);
        this.processValueRangeFromPlanningEntityPropertyAnnotation(valueRangeFromPlanningEntityPropertyAnnotation);
    }

    private void processValueRangeFromPlanningEntityPropertyAnnotation(ValueRangeFromPlanningEntityProperty valueRangeFromPlanningEntityPropertyAnnotation) {
        String planningEntityProperty = valueRangeFromPlanningEntityPropertyAnnotation.propertyName();
        PlanningEntityDescriptor planningEntityDescriptor = this.variableDescriptor.getPlanningEntityDescriptor();
        this.rangePropertyDescriptor = planningEntityDescriptor.getPropertyDescriptor(planningEntityProperty);
        if (this.rangePropertyDescriptor == null) {
            String exceptionMessage = "The planningEntityClass (" + planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variableDescriptor.getVariablePropertyName() + ") that refers to a planningEntityProperty (" + planningEntityProperty + ") that does not exist.";
            if (planningEntityProperty.length() >= 2 && Character.isUpperCase(planningEntityProperty.charAt(1))) {
                String correctedPlanningEntityProperty = planningEntityProperty.substring(0, 1).toUpperCase() + planningEntityProperty.substring(1);
                exceptionMessage = exceptionMessage + " But it probably needs to be correctedPlanningEntityProperty (" + correctedPlanningEntityProperty + ") instead because the JavaBeans spec states" + " the first letter should be a upper case if the second is upper case.";
            }
            throw new IllegalArgumentException(exceptionMessage);
        }
        if (!Collection.class.isAssignableFrom(this.rangePropertyDescriptor.getPropertyType())) {
            throw new IllegalArgumentException("The planningEntityClass (" + planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variableDescriptor.getVariablePropertyName() + ") that refers to a planningEntityProperty (" + planningEntityProperty + ") that does not return a Collection.");
        }
    }

    @Override
    public Collection<?> extractValues(Solution solution, Object planningEntity) {
        return (Collection)DescriptorUtils.executeGetter(this.rangePropertyDescriptor, planningEntity);
    }

    @Override
    public long getProblemScale(Solution solution, Object planningEntity) {
        return this.extractValues(solution, planningEntity).size();
    }
}

