/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.domain.variable;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.drools.planner.api.domain.variable.PlanningValueStrengthWeightFactory;
import org.drools.planner.api.domain.variable.PlanningVariable;
import org.drools.planner.api.domain.variable.ValueRangeFromPlanningEntityProperty;
import org.drools.planner.api.domain.variable.ValueRangeFromSolutionProperty;
import org.drools.planner.api.domain.variable.ValueRangeUndefined;
import org.drools.planner.core.domain.common.DescriptorUtils;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.variable.DependentPlanningVariableDescriptor;
import org.drools.planner.core.domain.variable.PlanningEntityPropertyPlanningValueRangeDescriptor;
import org.drools.planner.core.domain.variable.PlanningValueRangeDescriptor;
import org.drools.planner.core.domain.variable.PlanningValueSorter;
import org.drools.planner.core.domain.variable.SolutionPropertyPlanningValueRangeDescriptor;
import org.drools.planner.core.domain.variable.UndefinedPlanningValueRangeDescriptor;
import org.drools.planner.core.solution.Solution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanningVariableDescriptor {
    private final PlanningEntityDescriptor planningEntityDescriptor;
    private final PropertyDescriptor variablePropertyDescriptor;
    private boolean triggerChainCorrection;
    private PlanningValueRangeDescriptor valueRangeDescriptor;
    private PlanningValueSorter valueSorter;
    private Map<String, DependentPlanningVariableDescriptor> dependentPlanningVariableDescriptorMap;

    public PlanningVariableDescriptor(PlanningEntityDescriptor planningEntityDescriptor, PropertyDescriptor variablePropertyDescriptor) {
        this.planningEntityDescriptor = planningEntityDescriptor;
        this.variablePropertyDescriptor = variablePropertyDescriptor;
    }

    public void processAnnotations() {
        this.processPropertyAnnotations();
        this.dependentPlanningVariableDescriptorMap = new HashMap<String, DependentPlanningVariableDescriptor>(2);
    }

    private void processPropertyAnnotations() {
        Class<? extends PlanningValueStrengthWeightFactory> strengthWeightFactoryClass;
        PlanningVariable planningVariableAnnotation = this.variablePropertyDescriptor.getReadMethod().getAnnotation(PlanningVariable.class);
        Class<? extends Comparator> strengthComparatorClass = planningVariableAnnotation.strengthComparatorClass();
        if (strengthComparatorClass == PlanningVariable.NullStrengthComparator.class) {
            strengthComparatorClass = null;
        }
        if ((strengthWeightFactoryClass = planningVariableAnnotation.strengthWeightFactoryClass()) == PlanningVariable.NullStrengthWeightFactory.class) {
            strengthWeightFactoryClass = null;
        }
        if (strengthComparatorClass != null && strengthWeightFactoryClass != null) {
            throw new IllegalStateException("The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") property (" + this.variablePropertyDescriptor.getName() + ") cannot have a strengthComparatorClass (" + strengthComparatorClass.getName() + ") and a strengthWeightFactoryClass (" + strengthWeightFactoryClass.getName() + ") at the same time.");
        }
        this.valueSorter = new PlanningValueSorter();
        if (strengthComparatorClass != null) {
            Comparator strengthComparator;
            try {
                strengthComparator = strengthComparatorClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("The strengthComparatorClass (" + strengthComparatorClass.getName() + ") does not have a public no-arg constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("The strengthComparatorClass (" + strengthComparatorClass.getName() + ") does not have a public no-arg constructor", e);
            }
            this.valueSorter.setStrengthComparator(strengthComparator);
        }
        if (strengthWeightFactoryClass != null) {
            PlanningValueStrengthWeightFactory strengthWeightFactory;
            try {
                strengthWeightFactory = strengthWeightFactoryClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("The strengthWeightFactoryClass (" + strengthWeightFactoryClass.getName() + ") does not have a public no-arg constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("The strengthWeightFactoryClass (" + strengthWeightFactoryClass.getName() + ") does not have a public no-arg constructor", e);
            }
            this.valueSorter.setStrengthWeightFactory(strengthWeightFactory);
        }
        this.triggerChainCorrection = planningVariableAnnotation.triggerChainCorrection();
        if (this.triggerChainCorrection && !this.variablePropertyDescriptor.getPropertyType().isAssignableFrom(this.planningEntityDescriptor.getPlanningEntityClass())) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyDescriptor.getName() + ") with triggerChainCorrection and propertyType (" + this.variablePropertyDescriptor.getPropertyType() + ") which is not a superclass/interface of or the same as the planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ").");
        }
        Method propertyGetter = this.variablePropertyDescriptor.getReadMethod();
        int valueRangeAnnotationCount = 0;
        if (propertyGetter.isAnnotationPresent(ValueRangeFromSolutionProperty.class)) {
            this.valueRangeDescriptor = new SolutionPropertyPlanningValueRangeDescriptor(this, propertyGetter.getAnnotation(ValueRangeFromSolutionProperty.class));
            ++valueRangeAnnotationCount;
        }
        if (propertyGetter.isAnnotationPresent(ValueRangeFromPlanningEntityProperty.class)) {
            this.valueRangeDescriptor = new PlanningEntityPropertyPlanningValueRangeDescriptor(this, propertyGetter.getAnnotation(ValueRangeFromPlanningEntityProperty.class));
            ++valueRangeAnnotationCount;
        }
        if (propertyGetter.isAnnotationPresent(ValueRangeUndefined.class)) {
            this.valueRangeDescriptor = new UndefinedPlanningValueRangeDescriptor(this, propertyGetter.getAnnotation(ValueRangeUndefined.class));
            ++valueRangeAnnotationCount;
        }
        if (valueRangeAnnotationCount <= 0) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyDescriptor.getName() + ") that has no ValueRange* annotation, such as ValueRangeFromSolutionProperty.");
        }
        if (valueRangeAnnotationCount > 1) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyDescriptor.getName() + ") that has multiple ValueRange* annotations.");
        }
    }

    public void addDependentPlanningVariableDescriptor(DependentPlanningVariableDescriptor dependentPlanningVariableDescriptor) {
        this.dependentPlanningVariableDescriptorMap.put(dependentPlanningVariableDescriptor.getVariablePropertyName(), dependentPlanningVariableDescriptor);
    }

    public PlanningEntityDescriptor getPlanningEntityDescriptor() {
        return this.planningEntityDescriptor;
    }

    public String getVariablePropertyName() {
        return this.variablePropertyDescriptor.getName();
    }

    public Collection<DependentPlanningVariableDescriptor> getDependentPlanningVariableDescriptors() {
        return this.dependentPlanningVariableDescriptorMap.values();
    }

    public boolean isInitialized(Object planningEntity) {
        Object variable = DescriptorUtils.executeGetter(this.variablePropertyDescriptor, planningEntity);
        return variable != null;
    }

    public void uninitialize(Object planningEntity) {
        DescriptorUtils.executeSetter(this.variablePropertyDescriptor, planningEntity, null);
    }

    public Object getValue(Object planningEntity) {
        return DescriptorUtils.executeGetter(this.variablePropertyDescriptor, planningEntity);
    }

    public void setValue(Object planningEntity, Object value) {
        DescriptorUtils.executeSetter(this.variablePropertyDescriptor, planningEntity, value);
    }

    public Collection<?> extractPlanningValues(Solution solution, Object planningEntity) {
        return this.valueRangeDescriptor.extractValues(solution, planningEntity);
    }

    public boolean isPlanningValuesCacheable() {
        return this.valueRangeDescriptor.isValuesCacheable();
    }

    public PlanningValueSorter getValueSorter() {
        return this.valueSorter;
    }

    public long getProblemScale(Solution solution, Object planningEntity) {
        return this.valueRangeDescriptor.getProblemScale(solution, planningEntity);
    }
}

