/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.domain.variable;

import java.beans.PropertyDescriptor;
import java.util.Collection;
import org.drools.planner.api.domain.variable.ValueRangeFromSolutionProperty;
import org.drools.planner.core.domain.common.DescriptorUtils;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.variable.AbstractPlanningValueRangeDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.solution.Solution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolutionPropertyPlanningValueRangeDescriptor
extends AbstractPlanningValueRangeDescriptor {
    private PropertyDescriptor rangePropertyDescriptor;

    public SolutionPropertyPlanningValueRangeDescriptor(PlanningVariableDescriptor variableDescriptor, ValueRangeFromSolutionProperty valueRangeFromSolutionPropertyAnnotation) {
        super(variableDescriptor);
        this.processValueRangeSolutionPropertyAnnotation(valueRangeFromSolutionPropertyAnnotation);
    }

    private void processValueRangeSolutionPropertyAnnotation(ValueRangeFromSolutionProperty valueRangeFromSolutionPropertyAnnotation) {
        String solutionPropertyName = valueRangeFromSolutionPropertyAnnotation.propertyName();
        PlanningEntityDescriptor planningEntityDescriptor = this.variableDescriptor.getPlanningEntityDescriptor();
        this.rangePropertyDescriptor = planningEntityDescriptor.getSolutionDescriptor().getPropertyDescriptor(solutionPropertyName);
        if (this.rangePropertyDescriptor == null) {
            String exceptionMessage = "The planningEntityClass (" + planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variableDescriptor.getVariablePropertyName() + ") that refers to a solutionClass (" + planningEntityDescriptor.getSolutionDescriptor().getSolutionClass() + ") solutionProperty (" + solutionPropertyName + ") that does not exist.";
            if (solutionPropertyName.length() >= 2 && Character.isUpperCase(solutionPropertyName.charAt(1))) {
                String correctedSolutionProperty = solutionPropertyName.substring(0, 1).toUpperCase() + solutionPropertyName.substring(1);
                exceptionMessage = exceptionMessage + " But it probably needs to be correctedSolutionProperty (" + correctedSolutionProperty + ") instead because the JavaBeans spec states" + " the first letter should be a upper case if the second is upper case.";
            }
            throw new IllegalArgumentException(exceptionMessage);
        }
        if (!Collection.class.isAssignableFrom(this.rangePropertyDescriptor.getPropertyType())) {
            throw new IllegalArgumentException("The planningEntityClass (" + planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variableDescriptor.getVariablePropertyName() + ") that refers to a solutionClass (" + planningEntityDescriptor.getSolutionDescriptor().getSolutionClass() + ") solutionProperty (" + solutionPropertyName + ") that does not return a Collection.");
        }
    }

    @Override
    public Collection<?> extractValues(Solution solution, Object planningEntity) {
        return (Collection)DescriptorUtils.executeGetter(this.rangePropertyDescriptor, solution);
    }

    @Override
    public long getProblemScale(Solution solution, Object planningEntity) {
        return this.extractValues(solution, planningEntity).size();
    }

    @Override
    public boolean isValuesCacheable() {
        return true;
    }
}

