/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.variable;

import java.util.Iterator;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.variable.PlanningValueSelector;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListener;
import org.drools.planner.core.phase.step.AbstractStepScope;

public class PlanningValueWalker
implements SolverPhaseLifecycleListener {
    private final PlanningVariableDescriptor planningVariableDescriptor;
    private final PlanningValueSelector planningValueSelector;
    private WorkingMemory workingMemory;
    private Object planningEntity;
    private FactHandle planningEntityFactHandle;
    private Iterator<?> planningValueIterator;
    private boolean isFirstValue;
    private Object workingValue;

    public PlanningValueWalker(PlanningVariableDescriptor planningVariableDescriptor, PlanningValueSelector planningValueSelector) {
        this.planningVariableDescriptor = planningVariableDescriptor;
        this.planningValueSelector = planningValueSelector;
    }

    public PlanningVariableDescriptor getPlanningVariableDescriptor() {
        return this.planningVariableDescriptor;
    }

    public Object getWorkingValue() {
        return this.workingValue;
    }

    public void phaseStarted(AbstractSolverPhaseScope solverPhaseScope) {
        this.planningValueSelector.phaseStarted(solverPhaseScope);
        this.workingMemory = solverPhaseScope.getWorkingMemory();
    }

    public void beforeDeciding(AbstractStepScope stepScope) {
        this.planningValueSelector.beforeDeciding(stepScope);
    }

    public void stepDecided(AbstractStepScope stepScope) {
        this.planningValueSelector.stepDecided(stepScope);
    }

    public void stepTaken(AbstractStepScope stepScope) {
        this.planningValueSelector.stepTaken(stepScope);
    }

    public void phaseEnded(AbstractSolverPhaseScope solverPhaseScope) {
        this.planningValueSelector.phaseEnded(solverPhaseScope);
        this.workingMemory = null;
        this.workingValue = null;
    }

    public void initWalk(Object planningEntity) {
        this.planningEntity = planningEntity;
        this.planningValueIterator = this.planningValueSelector.iterator(planningEntity);
        if (!this.planningValueIterator.hasNext()) {
            throw new IllegalStateException("The planningEntity (" + planningEntity + ") has a planning variable (" + this.planningVariableDescriptor.getVariablePropertyName() + ") which has no planning values.");
        }
        Object value = this.planningValueIterator.next();
        this.planningVariableDescriptor.setValue(planningEntity, value);
        this.isFirstValue = true;
        this.workingValue = value;
    }

    public void initPlanningEntityFactHandle(FactHandle planningEntityFactHandle) {
        this.planningEntityFactHandle = planningEntityFactHandle;
    }

    public boolean hasWalk() {
        if (this.isFirstValue) {
            return true;
        }
        return this.planningValueIterator.hasNext();
    }

    public void walk() {
        if (this.isFirstValue) {
            this.isFirstValue = false;
        } else {
            Object value = this.planningValueIterator.next();
            this.changeWorkingValue(value);
        }
    }

    public void resetWalk() {
        this.planningValueIterator = this.planningValueSelector.iterator(this.planningEntity);
        Object value = this.planningValueIterator.next();
        this.changeWorkingValue(value);
        this.workingValue = value;
    }

    private void changeWorkingValue(Object value) {
        this.planningVariableDescriptor.setValue(this.planningEntity, value);
        this.workingMemory.update((org.drools.runtime.rule.FactHandle)this.planningEntityFactHandle, this.planningEntity);
        this.workingValue = value;
    }
}

