/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch;

import org.drools.planner.core.localsearch.LocalSearchSolverPhase;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.Decider;
import org.drools.planner.core.localsearch.event.LocalSearchSolverPhaseLifecycleListener;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.phase.AbstractSolverPhase;
import org.drools.planner.core.solver.DefaultSolverScope;

public class DefaultLocalSearchSolverPhase
extends AbstractSolverPhase
implements LocalSearchSolverPhase,
LocalSearchSolverPhaseLifecycleListener {
    protected Decider decider;
    protected boolean assertStepScoreIsUncorrupted = false;

    public void setDecider(Decider decider) {
        this.decider = decider;
        this.decider.setLocalSearchSolverPhase(this);
    }

    public void setAssertStepScoreIsUncorrupted(boolean assertStepScoreIsUncorrupted) {
        this.assertStepScoreIsUncorrupted = assertStepScoreIsUncorrupted;
    }

    public void solve(DefaultSolverScope solverScope) {
        LocalSearchSolverPhaseScope solverPhaseScope = new LocalSearchSolverPhaseScope(solverScope);
        this.phaseStarted(solverPhaseScope);
        LocalSearchStepScope stepScope = this.createNextStepScope(solverPhaseScope, null);
        while (!this.termination.isPhaseTerminated(solverPhaseScope)) {
            stepScope.setTimeGradient(this.termination.calculatePhaseTimeGradient(solverPhaseScope));
            this.beforeDeciding(stepScope);
            this.decider.decideNextStep(stepScope);
            Move nextStep = stepScope.getStep();
            if (nextStep == null) {
                this.logger.warn("    Cancelled step index ({}), time spend ({}): there is no doable move. Terminating phase early.", (Object)stepScope.getStepIndex(), (Object)solverPhaseScope.calculateSolverTimeMillisSpend());
                break;
            }
            this.stepDecided(stepScope);
            nextStep.doMove(stepScope.getWorkingMemory());
            solverPhaseScope.getWorkingSolution().setScore(stepScope.getScore());
            if (this.assertStepScoreIsUncorrupted) {
                solverPhaseScope.assertWorkingScore(stepScope.getScore());
            }
            this.stepTaken(stepScope);
            stepScope = this.createNextStepScope(solverPhaseScope, stepScope);
        }
        this.phaseEnded(solverPhaseScope);
    }

    private LocalSearchStepScope createNextStepScope(LocalSearchSolverPhaseScope localSearchSolverPhaseScope, LocalSearchStepScope completedLocalSearchStepScope) {
        if (completedLocalSearchStepScope == null) {
            completedLocalSearchStepScope = new LocalSearchStepScope(localSearchSolverPhaseScope);
            completedLocalSearchStepScope.setScore(localSearchSolverPhaseScope.getStartingScore());
            completedLocalSearchStepScope.setStepIndex(-1);
            completedLocalSearchStepScope.setTimeGradient(0.0);
        }
        localSearchSolverPhaseScope.setLastCompletedLocalSearchStepScope(completedLocalSearchStepScope);
        LocalSearchStepScope localSearchStepScope = new LocalSearchStepScope(localSearchSolverPhaseScope);
        localSearchStepScope.setStepIndex(completedLocalSearchStepScope.getStepIndex() + 1);
        localSearchStepScope.setSolutionInitialized(true);
        return localSearchStepScope;
    }

    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        super.phaseStarted(localSearchSolverPhaseScope);
        this.decider.phaseStarted(localSearchSolverPhaseScope);
    }

    public void beforeDeciding(LocalSearchStepScope localSearchStepScope) {
        super.beforeDeciding(localSearchStepScope);
        this.decider.beforeDeciding(localSearchStepScope);
    }

    public void stepDecided(LocalSearchStepScope localSearchStepScope) {
        super.stepDecided(localSearchStepScope);
        this.decider.stepDecided(localSearchStepScope);
    }

    public void stepTaken(LocalSearchStepScope localSearchStepScope) {
        super.stepTaken(localSearchStepScope);
        this.decider.stepTaken(localSearchStepScope);
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope = localSearchStepScope.getLocalSearchSolverPhaseScope();
        this.logger.debug("    Step index ({}), time spend ({}), score ({}), {} best score ({}), accepted move size ({}) for picked step ({}).", new Object[]{localSearchStepScope.getStepIndex(), localSearchSolverPhaseScope.calculateSolverTimeMillisSpend(), localSearchStepScope.getScore(), localSearchStepScope.getBestScoreImproved() != false ? "new" : "   ", localSearchSolverPhaseScope.getBestScore(), this.decider.getForager().getAcceptedMovesSize(), localSearchStepScope.getStepString()});
    }

    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        super.phaseEnded(localSearchSolverPhaseScope);
        this.decider.phaseEnded(localSearchSolverPhaseScope);
        this.logger.info("Phase local search ended: step total ({}), time spend ({}), best score ({}).", new Object[]{localSearchSolverPhaseScope.getLastCompletedStepScope().getStepIndex() + 1, localSearchSolverPhaseScope.calculateSolverTimeMillisSpend(), localSearchSolverPhaseScope.getBestScore()});
    }
}

