/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.move.generic;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.TabuPropertyEnabled;
import org.drools.planner.core.move.Move;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericChangeMove
implements Move,
TabuPropertyEnabled {
    private final Object planningEntity;
    private final FactHandle planningEntityFactHandle;
    private final PlanningVariableDescriptor planningVariableDescriptor;
    private final Object toPlanningValue;

    public GenericChangeMove(Object planningEntity, FactHandle planningEntityFactHandle, PlanningVariableDescriptor planningVariableDescriptor, Object toPlanningValue) {
        this.planningEntity = planningEntity;
        this.planningEntityFactHandle = planningEntityFactHandle;
        this.planningVariableDescriptor = planningVariableDescriptor;
        this.toPlanningValue = toPlanningValue;
    }

    @Override
    public boolean isMoveDoable(WorkingMemory workingMemory) {
        Object oldPlanningValue = this.planningVariableDescriptor.getValue(this.planningEntity);
        return !ObjectUtils.equals((Object)oldPlanningValue, (Object)this.toPlanningValue);
    }

    @Override
    public Move createUndoMove(WorkingMemory workingMemory) {
        Object oldPlanningValue = this.planningVariableDescriptor.getValue(this.planningEntity);
        return new GenericChangeMove(this.planningEntity, this.planningEntityFactHandle, this.planningVariableDescriptor, oldPlanningValue);
    }

    @Override
    public void doMove(WorkingMemory workingMemory) {
        this.planningVariableDescriptor.setValue(this.planningEntity, this.toPlanningValue);
        workingMemory.update((org.drools.runtime.rule.FactHandle)this.planningEntityFactHandle, this.planningEntity);
    }

    @Override
    public Collection<? extends Object> getTabuProperties() {
        return Collections.singletonList(this.planningEntity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof GenericChangeMove) {
            GenericChangeMove other = (GenericChangeMove)o;
            return new EqualsBuilder().append(this.planningEntity, other.planningEntity).append((Object)this.planningVariableDescriptor.getVariablePropertyName(), (Object)other.planningVariableDescriptor.getVariablePropertyName()).append(this.toPlanningValue, other.toPlanningValue).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.planningEntity).append((Object)this.planningVariableDescriptor.getVariablePropertyName()).append(this.toPlanningValue).toHashCode();
    }

    public String toString() {
        return this.planningEntity + " => " + this.toPlanningValue;
    }
}

