/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.move.generic;

import java.util.ArrayList;
import java.util.List;
import org.drools.FactHandle;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.move.factory.CachedMoveFactory;
import org.drools.planner.core.move.generic.GenericChangeMove;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solution.director.SolutionDirector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericChangeMoveFactory
extends CachedMoveFactory {
    private SolutionDescriptor solutionDescriptor;
    private SolutionDirector solutionDirector;

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.solutionDescriptor = localSearchSolverPhaseScope.getSolutionDescriptor();
        this.solutionDirector = localSearchSolverPhaseScope.getSolutionDirector();
        super.phaseStarted(localSearchSolverPhaseScope);
    }

    @Override
    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        super.phaseEnded(localSearchSolverPhaseScope);
        this.solutionDescriptor = null;
        this.solutionDirector = null;
    }

    @Override
    public List<Move> createCachedMoveList(Solution solution) {
        ArrayList<Move> moveList = new ArrayList<Move>();
        for (Object planningEntity : this.solutionDescriptor.getPlanningEntityList(solution)) {
            FactHandle planningEntityFactHandle = this.solutionDirector.getWorkingMemory().getFactHandle(planningEntity);
            PlanningEntityDescriptor planningEntityDescriptor = this.solutionDescriptor.getPlanningEntityDescriptor(planningEntity.getClass());
            for (PlanningVariableDescriptor planningVariableDescriptor : planningEntityDescriptor.getPlanningVariableDescriptors()) {
                for (Object toPlanningValue : planningVariableDescriptor.extractPlanningValues(this.solutionDirector.getWorkingSolution(), planningEntity)) {
                    moveList.add(new GenericChangeMove(planningEntity, planningEntityFactHandle, planningVariableDescriptor, toPlanningValue));
                }
            }
        }
        return moveList;
    }
}

