/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.move.generic;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.TabuPropertyEnabled;
import org.drools.planner.core.move.Move;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSwapMove
implements Move,
TabuPropertyEnabled {
    private final Collection<PlanningVariableDescriptor> planningVariableDescriptors;
    private final Object leftPlanningEntity;
    private final FactHandle leftPlanningEntityFactHandle;
    private final Object rightPlanningEntity;
    private final FactHandle rightPlanningEntityFactHandle;

    public GenericSwapMove(Collection<PlanningVariableDescriptor> planningVariableDescriptors, Object leftPlanningEntity, FactHandle leftPlanningEntityFactHandle, Object rightPlanningEntity, FactHandle rightPlanningEntityFactHandle) {
        this.planningVariableDescriptors = planningVariableDescriptors;
        this.leftPlanningEntity = leftPlanningEntity;
        this.leftPlanningEntityFactHandle = leftPlanningEntityFactHandle;
        this.rightPlanningEntity = rightPlanningEntity;
        this.rightPlanningEntityFactHandle = rightPlanningEntityFactHandle;
    }

    @Override
    public boolean isMoveDoable(WorkingMemory workingMemory) {
        for (PlanningVariableDescriptor planningVariableDescriptor : this.planningVariableDescriptors) {
            Object rightValue;
            Object leftValue = planningVariableDescriptor.getValue(this.leftPlanningEntity);
            if (ObjectUtils.equals((Object)leftValue, (Object)(rightValue = planningVariableDescriptor.getValue(this.rightPlanningEntity)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Move createUndoMove(WorkingMemory workingMemory) {
        return new GenericSwapMove(this.planningVariableDescriptors, this.rightPlanningEntity, this.rightPlanningEntityFactHandle, this.leftPlanningEntity, this.leftPlanningEntityFactHandle);
    }

    @Override
    public void doMove(WorkingMemory workingMemory) {
        for (PlanningVariableDescriptor planningVariableDescriptor : this.planningVariableDescriptors) {
            Object rightValue;
            Object leftValue = planningVariableDescriptor.getValue(this.leftPlanningEntity);
            if (ObjectUtils.equals((Object)leftValue, (Object)(rightValue = planningVariableDescriptor.getValue(this.rightPlanningEntity)))) continue;
            planningVariableDescriptor.setValue(this.leftPlanningEntity, rightValue);
            workingMemory.update((org.drools.runtime.rule.FactHandle)this.leftPlanningEntityFactHandle, this.leftPlanningEntity);
            planningVariableDescriptor.setValue(this.rightPlanningEntity, leftValue);
            workingMemory.update((org.drools.runtime.rule.FactHandle)this.rightPlanningEntityFactHandle, this.rightPlanningEntity);
        }
    }

    @Override
    public Collection<? extends Object> getTabuProperties() {
        return Arrays.asList(this.leftPlanningEntity, this.rightPlanningEntity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof GenericSwapMove) {
            GenericSwapMove other = (GenericSwapMove)o;
            return new EqualsBuilder().append(this.leftPlanningEntity, other.leftPlanningEntity).append(this.rightPlanningEntity, other.rightPlanningEntity).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.leftPlanningEntity).append(this.rightPlanningEntity).toHashCode();
    }

    public String toString() {
        return this.leftPlanningEntity + " <=> " + this.rightPlanningEntity;
    }
}

