/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.move.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.drools.FactHandle;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.move.factory.CachedMoveFactory;
import org.drools.planner.core.move.generic.GenericSwapMove;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solution.director.SolutionDirector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSwapMoveFactory
extends CachedMoveFactory {
    private SolutionDescriptor solutionDescriptor;
    private SolutionDirector solutionDirector;

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.solutionDescriptor = localSearchSolverPhaseScope.getSolutionDescriptor();
        this.solutionDirector = localSearchSolverPhaseScope.getSolutionDirector();
        super.phaseStarted(localSearchSolverPhaseScope);
    }

    @Override
    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        super.phaseEnded(localSearchSolverPhaseScope);
        this.solutionDescriptor = null;
        this.solutionDirector = null;
    }

    @Override
    public List<Move> createCachedMoveList(Solution solution) {
        ArrayList<Move> moveList = new ArrayList<Move>();
        List<Object> planningEntityList = this.solutionDescriptor.getPlanningEntityList(solution);
        ListIterator<Object> leftIt = planningEntityList.listIterator();
        while (leftIt.hasNext()) {
            Object leftPlanningEntity = leftIt.next();
            FactHandle leftPlanningEntityFactHandle = this.solutionDirector.getWorkingMemory().getFactHandle(leftPlanningEntity);
            PlanningEntityDescriptor leftPlanningEntityDescriptor = this.solutionDescriptor.getPlanningEntityDescriptor(leftPlanningEntity.getClass());
            Collection<PlanningVariableDescriptor> planningVariableDescriptors = leftPlanningEntityDescriptor.getPlanningVariableDescriptors();
            ListIterator<Object> rightIt = planningEntityList.listIterator(leftIt.nextIndex());
            while (rightIt.hasNext()) {
                Object rightPlanningEntity = rightIt.next();
                PlanningEntityDescriptor rightPlanningEntityDescriptor = this.solutionDescriptor.getPlanningEntityDescriptor(leftPlanningEntity.getClass());
                if (!leftPlanningEntityDescriptor.getPlanningEntityClass().equals(rightPlanningEntityDescriptor.getPlanningEntityClass())) continue;
                FactHandle rightPlanningEntityFactHandle = this.solutionDirector.getWorkingMemory().getFactHandle(rightPlanningEntity);
                moveList.add(new GenericSwapMove(planningVariableDescriptors, leftPlanningEntity, leftPlanningEntityFactHandle, rightPlanningEntity, rightPlanningEntityFactHandle));
            }
        }
        return moveList;
    }
}

