/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.move.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.WorkingMemory;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.TabuPropertyEnabled;
import org.drools.planner.core.move.Move;
import org.drools.runtime.rule.FactHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSwapPillarMove
implements Move,
TabuPropertyEnabled {
    private final Collection<PlanningVariableDescriptor> planningVariableDescriptors;
    private final List<Object> leftPlanningEntityList;
    private final List<Object> rightPlanningEntityList;

    public GenericSwapPillarMove(Collection<PlanningVariableDescriptor> planningVariableDescriptors, List<Object> leftPlanningEntityList, List<Object> rightPlanningEntityList) {
        this.planningVariableDescriptors = planningVariableDescriptors;
        this.leftPlanningEntityList = leftPlanningEntityList;
        this.rightPlanningEntityList = rightPlanningEntityList;
    }

    @Override
    public boolean isMoveDoable(WorkingMemory workingMemory) {
        for (PlanningVariableDescriptor planningVariableDescriptor : this.planningVariableDescriptors) {
            Object rightValue;
            Object leftValue = planningVariableDescriptor.getValue(this.leftPlanningEntityList.get(0));
            if (ObjectUtils.equals((Object)leftValue, (Object)(rightValue = planningVariableDescriptor.getValue(this.rightPlanningEntityList.get(0))))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Move createUndoMove(WorkingMemory workingMemory) {
        return new GenericSwapPillarMove(this.planningVariableDescriptors, this.rightPlanningEntityList, this.leftPlanningEntityList);
    }

    @Override
    public void doMove(WorkingMemory workingMemory) {
        for (PlanningVariableDescriptor planningVariableDescriptor : this.planningVariableDescriptors) {
            Object rightValue;
            Object leftValue = planningVariableDescriptor.getValue(this.leftPlanningEntityList.get(0));
            if (ObjectUtils.equals((Object)leftValue, (Object)(rightValue = planningVariableDescriptor.getValue(this.rightPlanningEntityList.get(0))))) continue;
            for (Object leftPlanningEntity : this.leftPlanningEntityList) {
                planningVariableDescriptor.setValue(leftPlanningEntity, rightValue);
                workingMemory.update((FactHandle)workingMemory.getFactHandle(leftPlanningEntity), leftPlanningEntity);
            }
            for (Object rightPlanningEntity : this.rightPlanningEntityList) {
                planningVariableDescriptor.setValue(rightPlanningEntity, leftValue);
                workingMemory.update((FactHandle)workingMemory.getFactHandle(rightPlanningEntity), rightPlanningEntity);
            }
        }
    }

    @Override
    public Collection<? extends Object> getTabuProperties() {
        ArrayList<Object> tabuProperties = new ArrayList<Object>(this.leftPlanningEntityList.size() + this.rightPlanningEntityList.size());
        tabuProperties.addAll(this.leftPlanningEntityList);
        tabuProperties.addAll(this.rightPlanningEntityList);
        return tabuProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof GenericSwapPillarMove) {
            GenericSwapPillarMove other = (GenericSwapPillarMove)o;
            return new EqualsBuilder().append(this.leftPlanningEntityList, other.leftPlanningEntityList).append(this.rightPlanningEntityList, other.rightPlanningEntityList).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.leftPlanningEntityList).append(this.rightPlanningEntityList).toHashCode();
    }

    public String toString() {
        return this.leftPlanningEntityList + " <=> " + this.rightPlanningEntityList;
    }
}

