/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.phase;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.drools.WorkingMemory;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solution.director.SolutionDirector;
import org.drools.planner.core.solver.DefaultSolverScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSolverPhaseScope {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected DefaultSolverScope solverScope;
    protected long startingSystemTimeMillis;
    protected Score startingScore;
    protected int bestSolutionStepIndex;

    public AbstractSolverPhaseScope(DefaultSolverScope solverScope) {
        this.solverScope = solverScope;
    }

    public DefaultSolverScope getSolverScope() {
        return this.solverScope;
    }

    public long getStartingSystemTimeMillis() {
        return this.startingSystemTimeMillis;
    }

    public Score getStartingScore() {
        return this.startingScore;
    }

    public void setStartingScore(Score startingScore) {
        this.startingScore = startingScore;
    }

    public int getBestSolutionStepIndex() {
        return this.bestSolutionStepIndex;
    }

    public void setBestSolutionStepIndex(int bestSolutionStepIndex) {
        this.bestSolutionStepIndex = bestSolutionStepIndex;
    }

    public abstract AbstractStepScope getLastCompletedStepScope();

    public void reset() {
        this.startingSystemTimeMillis = System.currentTimeMillis();
        this.bestSolutionStepIndex = -1;
        this.startingScore = this.solverScope.getBestScore();
    }

    public SolutionDescriptor getSolutionDescriptor() {
        return this.solverScope.getSolutionDescriptor();
    }

    public ScoreDefinition getScoreDefinition() {
        return this.solverScope.getScoreDefinition();
    }

    public long calculateSolverTimeMillisSpend() {
        return this.solverScope.calculateTimeMillisSpend();
    }

    public long calculatePhaseTimeMillisSpend() {
        long now = System.currentTimeMillis();
        return now - this.startingSystemTimeMillis;
    }

    public SolutionDirector getSolutionDirector() {
        return this.solverScope.getSolutionDirector();
    }

    public Solution getWorkingSolution() {
        return this.solverScope.getWorkingSolution();
    }

    public Collection<Object> getWorkingFacts() {
        return this.solverScope.getWorkingFacts();
    }

    public List<Object> getWorkingPlanningEntityList() {
        return this.solverScope.getWorkingPlanningEntityList();
    }

    public boolean isWorkingSolutionInitialized() {
        return this.solverScope.isWorkingSolutionInitialized();
    }

    public WorkingMemory getWorkingMemory() {
        return this.solverScope.getWorkingMemory();
    }

    public Score calculateScoreFromWorkingMemory() {
        return this.solverScope.calculateScoreFromWorkingMemory();
    }

    public void assertWorkingScore(Score presumedScore) {
        this.solverScope.assertWorkingScore(presumedScore);
    }

    public Random getWorkingRandom() {
        return this.solverScope.getWorkingRandom();
    }

    public Score getBestScore() {
        return this.solverScope.getBestScore();
    }
}

