/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.solution.director;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.drools.ClassObjectFilter;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.calculator.ScoreCalculator;
import org.drools.planner.core.score.constraint.ConstraintOccurrence;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solution.director.SolutionDirector;
import org.drools.runtime.ObjectFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSolutionDirector
implements SolutionDirector {
    public static final String GLOBAL_SCORE_CALCULATOR_KEY = "scoreCalculator";
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SolutionDescriptor solutionDescriptor;
    protected RuleBase ruleBase;
    protected ScoreDefinition scoreDefinition;
    protected Solution workingSolution;
    protected StatefulSession workingMemory;
    protected ScoreCalculator workingScoreCalculator;
    protected long calculateCount;

    public SolutionDescriptor getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public void setSolutionDescriptor(SolutionDescriptor solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
    }

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public void setRuleBase(RuleBase ruleBase) {
        this.ruleBase = ruleBase;
    }

    public ScoreDefinition getScoreDefinition() {
        return this.scoreDefinition;
    }

    public void setScoreDefinition(ScoreDefinition scoreDefinition) {
        this.scoreDefinition = scoreDefinition;
    }

    @Override
    public Solution getWorkingSolution() {
        return this.workingSolution;
    }

    public void setWorkingSolution(Solution workingSolution) {
        this.workingSolution = workingSolution;
        this.resetWorkingMemory();
    }

    @Override
    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public long getCalculateCount() {
        return this.calculateCount;
    }

    public void resetCalculateCount() {
        this.calculateCount = 0L;
    }

    private void resetWorkingMemory() {
        if (this.workingMemory != null) {
            this.workingMemory.dispose();
        }
        this.workingMemory = this.ruleBase.newStatefulSession();
        this.workingScoreCalculator = this.scoreDefinition.buildScoreCalculator();
        this.workingMemory.setGlobal(GLOBAL_SCORE_CALCULATOR_KEY, (Object)this.workingScoreCalculator);
        for (Object fact : this.getWorkingFacts()) {
            this.workingMemory.insert(fact);
        }
    }

    public Collection<Object> getWorkingFacts() {
        return this.solutionDescriptor.getAllFacts(this.workingSolution);
    }

    public List<Object> getWorkingPlanningEntityList() {
        return this.solutionDescriptor.getPlanningEntityList(this.workingSolution);
    }

    public boolean isWorkingSolutionInitialized() {
        return this.solutionDescriptor.isInitialized(this.workingSolution);
    }

    @Override
    public Score calculateScoreFromWorkingMemory() {
        this.workingMemory.fireAllRules();
        Score score = this.workingScoreCalculator.calculateScore();
        this.workingSolution.setScore(score);
        ++this.calculateCount;
        return score;
    }

    public void dispose() {
        if (this.workingMemory != null) {
            this.workingMemory.dispose();
        }
    }

    public void assertWorkingScore(Score presumedScore) {
        DefaultSolutionDirector uncorruptedSolutionDirector = this.buildUncorruptedSolutionDirector();
        Score uncorruptedScore = uncorruptedSolutionDirector.calculateScoreFromWorkingMemory();
        if (!presumedScore.equals(uncorruptedScore)) {
            String scoreCorruptionAnalysis = this.buildScoreCorruptionAnalysis(uncorruptedSolutionDirector);
            uncorruptedSolutionDirector.dispose();
            throw new IllegalStateException("Score corruption: the presumedScore (" + presumedScore + ") is not the uncorruptedScore (" + uncorruptedScore + "):\n" + scoreCorruptionAnalysis);
        }
        uncorruptedSolutionDirector.dispose();
    }

    private DefaultSolutionDirector buildUncorruptedSolutionDirector() {
        DefaultSolutionDirector uncorruptedSolutionDirector = new DefaultSolutionDirector();
        uncorruptedSolutionDirector.setSolutionDescriptor(this.solutionDescriptor);
        uncorruptedSolutionDirector.setRuleBase(this.ruleBase);
        uncorruptedSolutionDirector.setScoreDefinition(this.scoreDefinition);
        uncorruptedSolutionDirector.setWorkingSolution(this.workingSolution);
        return uncorruptedSolutionDirector;
    }

    private String buildScoreCorruptionAnalysis(DefaultSolutionDirector uncorruptedSolutionDirector) {
        int count;
        LinkedHashSet workingConstraintOccurrenceSet = new LinkedHashSet();
        Iterator workingIt = this.workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(ConstraintOccurrence.class));
        while (workingIt.hasNext()) {
            workingConstraintOccurrenceSet.add(workingIt.next());
        }
        LinkedHashSet uncorruptedConstraintOccurrenceSet = new LinkedHashSet();
        Iterator uncorruptedIt = uncorruptedSolutionDirector.getWorkingMemory().iterateObjects((ObjectFilter)new ClassObjectFilter(ConstraintOccurrence.class));
        while (uncorruptedIt.hasNext()) {
            uncorruptedConstraintOccurrenceSet.add(uncorruptedIt.next());
        }
        LinkedHashSet excessSet = new LinkedHashSet(workingConstraintOccurrenceSet);
        excessSet.removeAll(uncorruptedConstraintOccurrenceSet);
        LinkedHashSet lackingSet = new LinkedHashSet(uncorruptedConstraintOccurrenceSet);
        lackingSet.removeAll(workingConstraintOccurrenceSet);
        int CONSTRAINT_OCCURRENCE_DISPLAY_LIMIT = 10;
        StringBuilder analysis = new StringBuilder();
        if (!excessSet.isEmpty()) {
            analysis.append("  The workingMemory has ").append(excessSet.size()).append(" ConstraintOccurrence(s) in excess:\n");
            count = 0;
            for (Object o : excessSet) {
                if (count >= CONSTRAINT_OCCURRENCE_DISPLAY_LIMIT) {
                    analysis.append("    ... ").append(excessSet.size() - CONSTRAINT_OCCURRENCE_DISPLAY_LIMIT).append(" more\n");
                    break;
                }
                analysis.append("    ").append(o.toString()).append("\n");
                ++count;
            }
        }
        if (!lackingSet.isEmpty()) {
            analysis.append("  The workingMemory has ").append(excessSet.size()).append(" ConstraintOccurrence(s) lacking:\n");
            count = 0;
            for (Object o : lackingSet) {
                if (count >= CONSTRAINT_OCCURRENCE_DISPLAY_LIMIT) {
                    analysis.append("    ... ").append(lackingSet.size() - CONSTRAINT_OCCURRENCE_DISPLAY_LIMIT).append(" more\n");
                    break;
                }
                analysis.append("    ").append(o.toString()).append("\n");
                ++count;
            }
        }
        if (excessSet.isEmpty() && lackingSet.isEmpty()) {
            analysis.append("  Check the score rules. No ConstraintOccurrence(s) in excess or lacking.  Possibly some logically inserted score rules do not extend ConstraintOccurrence.\n  Consider making them extend ConstraintOccurrence or just reuse the build-in ConstraintOccurrence implementations.");
        } else {
            analysis.append("  Check the score rules who created those ConstraintOccurrences. Verify that each ConstraintOccurrence's causes and weight is correct.");
        }
        return analysis.toString();
    }
}

