/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.drools.planner.benchmark.api.PlannerBenchmark;
import org.drools.planner.benchmark.config.SolverBenchmarkConfig;
import org.drools.planner.benchmark.core.DefaultPlannerBenchmark;
import org.drools.planner.benchmark.core.ProblemBenchmark;
import org.drools.planner.benchmark.core.SolverBenchmark;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="plannerBenchmark")
public class PlannerBenchmarkConfig {
    private File benchmarkDirectory = null;
    private File benchmarkInstanceDirectory = null;
    private File outputSolutionFilesDirectory = null;
    private File statisticDirectory = null;
    private Comparator<SolverBenchmark> solverBenchmarkComparator = null;
    private Long warmUpTimeMillisSpend = null;
    private Long warmUpSecondsSpend = null;
    private Long warmUpMinutesSpend = null;
    private Long warmUpHoursSpend = null;
    @XStreamAlias(value="inheritedSolverBenchmark")
    private SolverBenchmarkConfig inheritedSolverBenchmarkConfig = null;
    @XStreamImplicit(itemFieldName="solverBenchmark")
    private List<SolverBenchmarkConfig> solverBenchmarkConfigList = null;

    public File getBenchmarkDirectory() {
        return this.benchmarkDirectory;
    }

    public void setBenchmarkDirectory(File benchmarkDirectory) {
        this.benchmarkDirectory = benchmarkDirectory;
    }

    public File getBenchmarkInstanceDirectory() {
        return this.benchmarkInstanceDirectory;
    }

    public void setBenchmarkInstanceDirectory(File benchmarkInstanceDirectory) {
        this.benchmarkInstanceDirectory = benchmarkInstanceDirectory;
    }

    public File getOutputSolutionFilesDirectory() {
        return this.outputSolutionFilesDirectory;
    }

    public void setOutputSolutionFilesDirectory(File outputSolutionFilesDirectory) {
        this.outputSolutionFilesDirectory = outputSolutionFilesDirectory;
    }

    public File getStatisticDirectory() {
        return this.statisticDirectory;
    }

    public void setStatisticDirectory(File statisticDirectory) {
        this.statisticDirectory = statisticDirectory;
    }

    public Comparator<SolverBenchmark> getSolverBenchmarkComparator() {
        return this.solverBenchmarkComparator;
    }

    public void setSolverBenchmarkComparator(Comparator<SolverBenchmark> solverBenchmarkComparator) {
        this.solverBenchmarkComparator = solverBenchmarkComparator;
    }

    public Long getWarmUpTimeMillisSpend() {
        return this.warmUpTimeMillisSpend;
    }

    public void setWarmUpTimeMillisSpend(Long warmUpTimeMillisSpend) {
        this.warmUpTimeMillisSpend = warmUpTimeMillisSpend;
    }

    public Long getWarmUpSecondsSpend() {
        return this.warmUpSecondsSpend;
    }

    public void setWarmUpSecondsSpend(Long warmUpSecondsSpend) {
        this.warmUpSecondsSpend = warmUpSecondsSpend;
    }

    public Long getWarmUpMinutesSpend() {
        return this.warmUpMinutesSpend;
    }

    public void setWarmUpMinutesSpend(Long warmUpMinutesSpend) {
        this.warmUpMinutesSpend = warmUpMinutesSpend;
    }

    public Long getWarmUpHoursSpend() {
        return this.warmUpHoursSpend;
    }

    public void setWarmUpHoursSpend(Long warmUpHoursSpend) {
        this.warmUpHoursSpend = warmUpHoursSpend;
    }

    public SolverBenchmarkConfig getInheritedSolverBenchmarkConfig() {
        return this.inheritedSolverBenchmarkConfig;
    }

    public void setInheritedSolverBenchmarkConfig(SolverBenchmarkConfig inheritedSolverBenchmarkConfig) {
        this.inheritedSolverBenchmarkConfig = inheritedSolverBenchmarkConfig;
    }

    public List<SolverBenchmarkConfig> getSolverBenchmarkConfigList() {
        return this.solverBenchmarkConfigList;
    }

    public void setSolverBenchmarkConfigList(List<SolverBenchmarkConfig> solverBenchmarkConfigList) {
        this.solverBenchmarkConfigList = solverBenchmarkConfigList;
    }

    private void validate() {
        if (this.solverBenchmarkConfigList == null || this.solverBenchmarkConfigList.isEmpty()) {
            throw new IllegalArgumentException("Configure at least 1 <solverBenchmark> in the <plannerBenchmark> configuration.");
        }
    }

    private void generateSolverBenchmarkConfigNames() {
        HashSet<String> nameSet = new HashSet<String>(this.solverBenchmarkConfigList.size());
        LinkedHashSet<SolverBenchmarkConfig> noNameBenchmarkConfigSet = new LinkedHashSet<SolverBenchmarkConfig>(this.solverBenchmarkConfigList.size());
        for (SolverBenchmarkConfig solverBenchmarkConfig : this.solverBenchmarkConfigList) {
            if (solverBenchmarkConfig.getName() != null) {
                boolean unique = nameSet.add(solverBenchmarkConfig.getName());
                if (unique) continue;
                throw new IllegalStateException("The benchmark name (" + solverBenchmarkConfig.getName() + ") is used in more than 1 benchmark.");
            }
            noNameBenchmarkConfigSet.add(solverBenchmarkConfig);
        }
        int generatedNameIndex = 0;
        for (SolverBenchmarkConfig solverBenchmarkConfig : noNameBenchmarkConfigSet) {
            String generatedName = "Config_" + generatedNameIndex;
            while (nameSet.contains(generatedName)) {
                generatedName = "Config_" + ++generatedNameIndex;
            }
            solverBenchmarkConfig.setName(generatedName);
            ++generatedNameIndex;
        }
    }

    private void inherit() {
        if (this.inheritedSolverBenchmarkConfig != null) {
            for (SolverBenchmarkConfig solverBenchmarkConfig : this.solverBenchmarkConfigList) {
                solverBenchmarkConfig.inherit(this.inheritedSolverBenchmarkConfig);
            }
        }
    }

    public PlannerBenchmark buildPlannerBenchmark() {
        this.validate();
        this.generateSolverBenchmarkConfigNames();
        this.inherit();
        DefaultPlannerBenchmark plannerBenchmark = new DefaultPlannerBenchmark();
        plannerBenchmark.setBenchmarkDirectory(this.benchmarkDirectory);
        plannerBenchmark.setBenchmarkInstanceDirectory(this.benchmarkInstanceDirectory);
        plannerBenchmark.setOutputSolutionFilesDirectory(this.outputSolutionFilesDirectory);
        plannerBenchmark.setStatisticDirectory(this.statisticDirectory);
        plannerBenchmark.setSolverBenchmarkComparator(this.solverBenchmarkComparator);
        plannerBenchmark.setWarmUpTimeMillisSpend(this.calculateWarmUpTimeMillisSpendTotal());
        ArrayList<SolverBenchmark> solverBenchmarkList = new ArrayList<SolverBenchmark>(this.solverBenchmarkConfigList.size());
        ArrayList<ProblemBenchmark> unifiedProblemBenchmarkList = new ArrayList<ProblemBenchmark>();
        for (SolverBenchmarkConfig solverBenchmarkConfig : this.solverBenchmarkConfigList) {
            SolverBenchmark solverBenchmark = solverBenchmarkConfig.buildSolverBenchmark(unifiedProblemBenchmarkList);
            solverBenchmarkList.add(solverBenchmark);
        }
        plannerBenchmark.setSolverBenchmarkList(solverBenchmarkList);
        plannerBenchmark.setUnifiedProblemBenchmarkList(unifiedProblemBenchmarkList);
        return plannerBenchmark;
    }

    public Long calculateWarmUpTimeMillisSpendTotal() {
        if (this.warmUpTimeMillisSpend == null && this.warmUpSecondsSpend == null && this.warmUpMinutesSpend == null && this.warmUpHoursSpend == null) {
            return null;
        }
        long warmUpTimeMillisSpendTotal = 0L;
        if (this.warmUpTimeMillisSpend != null) {
            warmUpTimeMillisSpendTotal += this.warmUpTimeMillisSpend.longValue();
        }
        if (this.warmUpSecondsSpend != null) {
            warmUpTimeMillisSpendTotal += this.warmUpSecondsSpend * 1000L;
        }
        if (this.warmUpMinutesSpend != null) {
            warmUpTimeMillisSpendTotal += this.warmUpMinutesSpend * 60000L;
        }
        if (this.warmUpHoursSpend != null) {
            warmUpTimeMillisSpendTotal += this.warmUpHoursSpend * 3600000L;
        }
        return warmUpTimeMillisSpendTotal;
    }
}

