/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.core;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.drools.planner.benchmark.api.PlannerBenchmark;
import org.drools.planner.benchmark.core.ProblemBenchmark;
import org.drools.planner.benchmark.core.SolverBenchmark;
import org.drools.planner.benchmark.core.comparator.TotalScoreSolverBenchmarkComparator;
import org.drools.planner.benchmark.core.statistic.ProblemStatisticType;
import org.drools.planner.benchmark.core.statistic.StatisticManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPlannerBenchmark
implements PlannerBenchmark {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private File benchmarkDirectory = null;
    private File benchmarkInstanceDirectory = null;
    private File outputSolutionFilesDirectory = null;
    private File statisticDirectory = null;
    private List<ProblemStatisticType> problemStatisticTypeList = null;
    private Comparator<SolverBenchmark> solverBenchmarkComparator = null;
    private Long warmUpTimeMillisSpend = null;
    private List<SolverBenchmark> solverBenchmarkList = null;
    private List<ProblemBenchmark> unifiedProblemBenchmarkList = null;
    private SolverBenchmark winningSolverBenchmark = null;

    public File getBenchmarkDirectory() {
        return this.benchmarkDirectory;
    }

    public void setBenchmarkDirectory(File benchmarkDirectory) {
        this.benchmarkDirectory = benchmarkDirectory;
    }

    public File getBenchmarkInstanceDirectory() {
        return this.benchmarkInstanceDirectory;
    }

    public void setBenchmarkInstanceDirectory(File benchmarkInstanceDirectory) {
        this.benchmarkInstanceDirectory = benchmarkInstanceDirectory;
    }

    public File getOutputSolutionFilesDirectory() {
        return this.outputSolutionFilesDirectory;
    }

    public void setOutputSolutionFilesDirectory(File outputSolutionFilesDirectory) {
        this.outputSolutionFilesDirectory = outputSolutionFilesDirectory;
    }

    public File getStatisticDirectory() {
        return this.statisticDirectory;
    }

    public void setStatisticDirectory(File statisticDirectory) {
        this.statisticDirectory = statisticDirectory;
    }

    public List<ProblemStatisticType> getProblemStatisticTypeList() {
        return this.problemStatisticTypeList;
    }

    public void setProblemStatisticTypeList(List<ProblemStatisticType> problemStatisticTypeList) {
        this.problemStatisticTypeList = problemStatisticTypeList;
    }

    public Comparator<SolverBenchmark> getSolverBenchmarkComparator() {
        return this.solverBenchmarkComparator;
    }

    public void setSolverBenchmarkComparator(Comparator<SolverBenchmark> solverBenchmarkComparator) {
        this.solverBenchmarkComparator = solverBenchmarkComparator;
    }

    public Long getWarmUpTimeMillisSpend() {
        return this.warmUpTimeMillisSpend;
    }

    public void setWarmUpTimeMillisSpend(Long warmUpTimeMillisSpend) {
        this.warmUpTimeMillisSpend = warmUpTimeMillisSpend;
    }

    public List<SolverBenchmark> getSolverBenchmarkList() {
        return this.solverBenchmarkList;
    }

    public void setSolverBenchmarkList(List<SolverBenchmark> solverBenchmarkList) {
        this.solverBenchmarkList = solverBenchmarkList;
    }

    public List<ProblemBenchmark> getUnifiedProblemBenchmarkList() {
        return this.unifiedProblemBenchmarkList;
    }

    public void setUnifiedProblemBenchmarkList(List<ProblemBenchmark> unifiedProblemBenchmarkList) {
        this.unifiedProblemBenchmarkList = unifiedProblemBenchmarkList;
    }

    @Override
    public void benchmark() {
        this.benchmarkingStarted();
        this.warmUp();
        for (ProblemBenchmark problemBenchmark : this.unifiedProblemBenchmarkList) {
            problemBenchmark.benchmark();
        }
        this.benchmarkingEnded();
    }

    public void benchmarkingStarted() {
        if (this.solverBenchmarkList == null || this.solverBenchmarkList.isEmpty()) {
            throw new IllegalArgumentException("The solverBenchmarkList (" + this.solverBenchmarkList + ") cannot be empty.");
        }
        this.initBenchmarkDirectoryAndSubdirs();
        if (this.solverBenchmarkComparator == null) {
            this.solverBenchmarkComparator = new TotalScoreSolverBenchmarkComparator();
        }
        for (SolverBenchmark solverBenchmark : this.solverBenchmarkList) {
            solverBenchmark.benchmarkingStarted();
        }
        for (ProblemBenchmark problemBenchmark : this.unifiedProblemBenchmarkList) {
            problemBenchmark.setOutputSolutionFilesDirectory(this.outputSolutionFilesDirectory);
            problemBenchmark.benchmarkingStarted();
        }
        this.logger.info("Benchmarking started: solverBenchmarkList size ({}).", (Object)this.solverBenchmarkList.size());
    }

    private void initBenchmarkDirectoryAndSubdirs() {
        if (this.benchmarkDirectory == null) {
            throw new IllegalArgumentException("The benchmarkDirectory (" + this.benchmarkDirectory + ") must not be null.");
        }
        this.benchmarkDirectory.mkdirs();
        if (this.benchmarkInstanceDirectory == null) {
            String timestampDirectory = new SimpleDateFormat("yyyy-MM-dd_HHmmss").format(new Date());
            this.benchmarkInstanceDirectory = new File(this.benchmarkDirectory, timestampDirectory);
        }
        this.benchmarkInstanceDirectory.mkdirs();
        if (this.outputSolutionFilesDirectory == null) {
            this.outputSolutionFilesDirectory = new File(this.benchmarkInstanceDirectory, "output");
        }
        this.outputSolutionFilesDirectory.mkdirs();
        if (this.statisticDirectory == null) {
            this.statisticDirectory = new File(this.benchmarkInstanceDirectory, "statistic");
        }
        this.statisticDirectory.mkdirs();
    }

    private void warmUp() {
        if (this.warmUpTimeMillisSpend != null) {
            this.logger.info("================================================================================");
            this.logger.info("Warming up");
            this.logger.info("================================================================================");
            long startingTimeMillis = System.currentTimeMillis();
            long timeLeft = this.warmUpTimeMillisSpend;
            Iterator<ProblemBenchmark> it = this.unifiedProblemBenchmarkList.iterator();
            while (timeLeft > 0L) {
                if (!it.hasNext()) {
                    it = this.unifiedProblemBenchmarkList.iterator();
                }
                ProblemBenchmark problemBenchmark = it.next();
                timeLeft = problemBenchmark.warmUp(startingTimeMillis, this.warmUpTimeMillisSpend, timeLeft);
            }
            this.logger.info("================================================================================");
            this.logger.info("Finished warmUp");
            this.logger.info("================================================================================");
        }
    }

    public void benchmarkingEnded() {
        for (ProblemBenchmark problemBenchmark : this.unifiedProblemBenchmarkList) {
            problemBenchmark.benchmarkingEnded();
        }
        for (SolverBenchmark solverBenchmark : this.solverBenchmarkList) {
            solverBenchmark.benchmarkingEnded();
        }
        this.determineRanking();
        StatisticManager statisticManager = new StatisticManager(this.benchmarkInstanceDirectory.getName(), this.statisticDirectory, this.unifiedProblemBenchmarkList);
        statisticManager.writeStatistics(this.solverBenchmarkList);
        this.logger.info("Benchmarking ended: winning solverBenchmark ({}), statistic html overview ({}).", (Object)this.winningSolverBenchmark.getName(), (Object)statisticManager.getHtmlOverviewFile().getAbsolutePath());
    }

    private void determineRanking() {
        ArrayList<SolverBenchmark> sortedSolverBenchmarkList = new ArrayList<SolverBenchmark>(this.solverBenchmarkList);
        Collections.sort(sortedSolverBenchmarkList, this.solverBenchmarkComparator);
        Collections.reverse(sortedSolverBenchmarkList);
        for (SolverBenchmark solverBenchmark : this.solverBenchmarkList) {
            int ranking = sortedSolverBenchmarkList.indexOf(solverBenchmark);
            solverBenchmark.setRanking(ranking);
            if (ranking != 0) continue;
            this.winningSolverBenchmark = solverBenchmark;
        }
    }
}

