/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.core;

import java.util.ArrayList;
import java.util.List;
import org.drools.planner.benchmark.core.PlannerBenchmarkResult;
import org.drools.planner.benchmark.core.ProblemBenchmark;
import org.drools.planner.config.solver.SolverConfig;
import org.drools.planner.core.score.Score;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolverBenchmark {
    private String name = null;
    private SolverConfig solverConfig = null;
    private List<ProblemBenchmark> problemBenchmarkList = null;
    private List<PlannerBenchmarkResult> plannerBenchmarkResultList = null;
    private Score totalScore = null;
    private Integer ranking = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SolverConfig getSolverConfig() {
        return this.solverConfig;
    }

    public void setSolverConfig(SolverConfig solverConfig) {
        this.solverConfig = solverConfig;
    }

    public List<ProblemBenchmark> getProblemBenchmarkList() {
        return this.problemBenchmarkList;
    }

    public void setProblemBenchmarkList(List<ProblemBenchmark> problemBenchmarkList) {
        this.problemBenchmarkList = problemBenchmarkList;
    }

    public List<PlannerBenchmarkResult> getPlannerBenchmarkResultList() {
        return this.plannerBenchmarkResultList;
    }

    public void setPlannerBenchmarkResultList(List<PlannerBenchmarkResult> plannerBenchmarkResultList) {
        this.plannerBenchmarkResultList = plannerBenchmarkResultList;
    }

    public Integer getRanking() {
        return this.ranking;
    }

    public void setRanking(Integer ranking) {
        this.ranking = ranking;
    }

    public void benchmarkingStarted() {
    }

    public void benchmarkingEnded() {
        this.determineTotalScore();
    }

    private void determineTotalScore() {
        this.totalScore = null;
        for (PlannerBenchmarkResult plannerBenchmarkResult : this.plannerBenchmarkResultList) {
            if (this.totalScore == null) {
                this.totalScore = plannerBenchmarkResult.getScore();
                continue;
            }
            this.totalScore = this.totalScore.add(plannerBenchmarkResult.getScore());
        }
    }

    public boolean isRankingBest() {
        return this.ranking == 0;
    }

    public Score getTotalScore() {
        return this.totalScore;
    }

    public Score getAverageScore() {
        return this.getTotalScore().divide(this.plannerBenchmarkResultList.size());
    }

    public List<Score> getScoreList() {
        ArrayList<Score> scoreList = new ArrayList<Score>(this.plannerBenchmarkResultList.size());
        for (PlannerBenchmarkResult plannerBenchmarkResult : this.plannerBenchmarkResultList) {
            scoreList.add(plannerBenchmarkResult.getScore());
        }
        return scoreList;
    }
}

