/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.core.statistic;

import java.io.File;
import org.drools.planner.benchmark.core.statistic.ProblemStatistic;
import org.drools.planner.benchmark.core.statistic.ProblemStatisticType;

public abstract class AbstractProblemStatistic
implements ProblemStatistic {
    protected ProblemStatisticType problemStatisticType;

    protected AbstractProblemStatistic(ProblemStatisticType problemStatisticType) {
        this.problemStatisticType = problemStatisticType;
    }

    public CharSequence writeStatistic(File statisticDirectory, String baseName) {
        StringBuilder htmlFragment = new StringBuilder();
        htmlFragment.append("  <h3>").append(this.problemStatisticType.toString()).append("</h3>\n");
        htmlFragment.append(this.writeCsvStatistic(statisticDirectory, baseName));
        htmlFragment.append(this.writeGraphStatistic(statisticDirectory, baseName));
        return htmlFragment;
    }

    protected abstract CharSequence writeCsvStatistic(File var1, String var2);

    protected abstract CharSequence writeGraphStatistic(File var1, String var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractProblemStatisticScvLine
    implements Comparable<AbstractProblemStatisticScvLine> {
        protected long timeMillisSpend;

        public AbstractProblemStatisticScvLine(long timeMillisSpend) {
            this.timeMillisSpend = timeMillisSpend;
        }

        public long getTimeMillisSpend() {
            return this.timeMillisSpend;
        }

        @Override
        public int compareTo(AbstractProblemStatisticScvLine other) {
            return this.timeMillisSpend < other.timeMillisSpend ? -1 : (this.timeMillisSpend > other.timeMillisSpend ? 1 : 0);
        }
    }
}

