/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.core.statistic;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.drools.planner.benchmark.core.PlannerBenchmarkResult;
import org.drools.planner.benchmark.core.ProblemBenchmark;
import org.drools.planner.benchmark.core.SolverBenchmark;
import org.drools.planner.benchmark.core.statistic.MillisecondsSpendNumberFormat;
import org.drools.planner.benchmark.core.statistic.ProblemStatistic;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.TextAnchor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticManager {
    private final String benchmarkName;
    private final File statisticDirectory;
    private final File htmlOverviewFile;
    private final List<ProblemBenchmark> problemBenchmarkList;

    public StatisticManager(String benchmarkName, File statisticDirectory, List<ProblemBenchmark> problemBenchmarkList) {
        this.benchmarkName = benchmarkName;
        this.statisticDirectory = statisticDirectory;
        this.htmlOverviewFile = new File(statisticDirectory, "index.html");
        this.problemBenchmarkList = problemBenchmarkList;
    }

    public void writeStatistics(List<SolverBenchmark> solverBenchmarkList) {
        StringBuilder htmlFragment = new StringBuilder(this.problemBenchmarkList.size() * 160);
        htmlFragment.append("  <h1>Summary</h1>\n");
        htmlFragment.append(this.writeBestScoreSummaryChart(solverBenchmarkList));
        htmlFragment.append(this.writeWinningScoreDifferenceSummaryChart(solverBenchmarkList));
        htmlFragment.append(this.writeTimeSpendSummaryChart(solverBenchmarkList));
        htmlFragment.append(this.writeScalabilitySummaryChart(solverBenchmarkList));
        htmlFragment.append(this.writeAverageCalculateCountPerSecondSummaryChart(solverBenchmarkList));
        htmlFragment.append(this.writeBestScoreSummaryTable(solverBenchmarkList));
        htmlFragment.append("  <h1>Statistics</h1>\n");
        for (ProblemBenchmark problemBenchmark : this.problemBenchmarkList) {
            String problemBenchmarkName = problemBenchmark.getName();
            htmlFragment.append("  <h2>").append(problemBenchmarkName).append("</h2>\n");
            for (ProblemStatistic statistic : problemBenchmark.getProblemStatisticList()) {
                htmlFragment.append(statistic.writeStatistic(this.statisticDirectory, problemBenchmarkName));
            }
        }
        this.writeHtmlOverview(htmlFragment);
    }

    private CharSequence writeBestScoreSummaryChart(List<SolverBenchmark> solverBenchmarkList) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (SolverBenchmark solverBenchmark : solverBenchmarkList) {
            ScoreDefinition scoreDefinition = solverBenchmark.getSolverConfig().getScoreDirectorFactoryConfig().buildScoreDefinition();
            for (PlannerBenchmarkResult result : solverBenchmark.getPlannerBenchmarkResultList()) {
                Score score = result.getScore();
                Double scoreGraphValue = scoreDefinition.translateScoreToGraphValue(score);
                String solverLabel = solverBenchmark.getName();
                if (solverBenchmark.isRankingBest()) {
                    solverLabel = solverLabel + " (winner)";
                }
                String planningProblemLabel = result.getProblemBenchmark().getName();
                dataset.addValue((Number)scoreGraphValue, (Comparable)((Object)solverLabel), (Comparable)((Object)planningProblemLabel));
            }
        }
        CategoryAxis xAxis = new CategoryAxis("Data");
        xAxis.setCategoryMargin(0.4);
        NumberAxis yAxis = new NumberAxis("Score");
        BarRenderer renderer = new BarRenderer();
        ItemLabelPosition positiveItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
        renderer.setBasePositiveItemLabelPosition(positiveItemLabelPosition);
        ItemLabelPosition negativeItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
        renderer.setBaseNegativeItemLabelPosition(negativeItemLabelPosition);
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        renderer.setBaseItemLabelsVisible(true);
        CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, xAxis, (ValueAxis)yAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart("Best score summary (higher score is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        BufferedImage chartImage = chart.createBufferedImage(1024, 768);
        File chartSummaryFile = new File(this.statisticDirectory, "bestScoreSummary.png");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(chartSummaryFile);
            ImageIO.write((RenderedImage)chartImage, "png", out);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing graphStatisticFile: " + chartSummaryFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return "  <h2>Best score summary chart</h2>\n  <img src=\"" + chartSummaryFile.getName() + "\"/>\n";
    }

    private CharSequence writeWinningScoreDifferenceSummaryChart(List<SolverBenchmark> solverBenchmarkList) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (SolverBenchmark solverBenchmark : solverBenchmarkList) {
            ScoreDefinition scoreDefinition = solverBenchmark.getSolverConfig().getScoreDirectorFactoryConfig().buildScoreDefinition();
            for (PlannerBenchmarkResult result : solverBenchmark.getPlannerBenchmarkResultList()) {
                Score score = result.getWinningScoreDifference();
                Double scoreGraphValue = scoreDefinition.translateScoreToGraphValue(score);
                String solverLabel = solverBenchmark.getName();
                if (solverBenchmark.isRankingBest()) {
                    solverLabel = solverLabel + " (winner)";
                }
                String planningProblemLabel = result.getProblemBenchmark().getName();
                dataset.addValue((Number)scoreGraphValue, (Comparable)((Object)solverLabel), (Comparable)((Object)planningProblemLabel));
            }
        }
        CategoryAxis xAxis = new CategoryAxis("Data");
        xAxis.setCategoryMargin(0.4);
        NumberAxis yAxis = new NumberAxis("Winning score difference");
        BarRenderer renderer = new BarRenderer();
        ItemLabelPosition positiveItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
        renderer.setBasePositiveItemLabelPosition(positiveItemLabelPosition);
        ItemLabelPosition negativeItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
        renderer.setBaseNegativeItemLabelPosition(negativeItemLabelPosition);
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        renderer.setBaseItemLabelsVisible(true);
        CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, xAxis, (ValueAxis)yAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart("Winning score difference summary (higher is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        BufferedImage chartImage = chart.createBufferedImage(1024, 768);
        File chartSummaryFile = new File(this.statisticDirectory, "winningScoreDifferenceSummary.png");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(chartSummaryFile);
            ImageIO.write((RenderedImage)chartImage, "png", out);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing graphStatisticFile: " + chartSummaryFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return "  <h2>Winning score difference summary chart</h2>\n  <img src=\"" + chartSummaryFile.getName() + "\"/>\n";
    }

    private CharSequence writeTimeSpendSummaryChart(List<SolverBenchmark> solverBenchmarkList) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (SolverBenchmark solverBenchmark : solverBenchmarkList) {
            for (PlannerBenchmarkResult result : solverBenchmark.getPlannerBenchmarkResultList()) {
                long timeMillisSpend = result.getTimeMillisSpend();
                String solverLabel = solverBenchmark.getName();
                String planningProblemLabel = result.getProblemBenchmark().getName();
                dataset.addValue((double)timeMillisSpend, (Comparable)((Object)solverLabel), (Comparable)((Object)planningProblemLabel));
            }
        }
        CategoryAxis xAxis = new CategoryAxis("Data");
        NumberAxis yAxis = new NumberAxis("Time spend");
        yAxis.setNumberFormatOverride((NumberFormat)new MillisecondsSpendNumberFormat());
        BarRenderer renderer = new BarRenderer();
        ItemLabelPosition positiveItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
        renderer.setBasePositiveItemLabelPosition(positiveItemLabelPosition);
        ItemLabelPosition negativeItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
        renderer.setBaseNegativeItemLabelPosition(negativeItemLabelPosition);
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", (NumberFormat)new MillisecondsSpendNumberFormat()));
        renderer.setBaseItemLabelsVisible(true);
        CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, xAxis, (ValueAxis)yAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart("Time spend summary (lower time is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        BufferedImage chartImage = chart.createBufferedImage(1024, 768);
        File chartSummaryFile = new File(this.statisticDirectory, "timeSpendSummary.png");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(chartSummaryFile);
            ImageIO.write((RenderedImage)chartImage, "png", out);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing graphStatisticFile: " + chartSummaryFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return "  <h2>Time spend summary chart</h2>\n  <img src=\"" + chartSummaryFile.getName() + "\"/>\n";
    }

    private CharSequence writeScalabilitySummaryChart(List<SolverBenchmark> solverBenchmarkList) {
        NumberAxis xAxis = new NumberAxis("Problem scale");
        NumberAxis yAxis = new NumberAxis("Time spend");
        yAxis.setNumberFormatOverride((NumberFormat)new MillisecondsSpendNumberFormat());
        XYPlot plot = new XYPlot(null, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        int seriesIndex = 0;
        for (SolverBenchmark solverBenchmark : solverBenchmarkList) {
            XYSeries series = new XYSeries((Comparable)((Object)solverBenchmark.getName()));
            for (PlannerBenchmarkResult result : solverBenchmark.getPlannerBenchmarkResultList()) {
                long problemScale = result.getProblemScale();
                long timeMillisSpend = result.getTimeMillisSpend();
                series.add((Number)problemScale, (Number)timeMillisSpend);
            }
            XYSeriesCollection seriesCollection = new XYSeriesCollection();
            seriesCollection.addSeries(series);
            plot.setDataset(seriesIndex, (XYDataset)seriesCollection);
            StandardXYItemRenderer renderer = new StandardXYItemRenderer(3);
            renderer.setSeriesStroke(0, (Stroke)new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f, 6.0f}, 0.0f));
            plot.setRenderer(seriesIndex, (XYItemRenderer)renderer);
            ++seriesIndex;
        }
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart("Scalability summary (lower is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        BufferedImage chartImage = chart.createBufferedImage(1024, 768);
        File chartSummaryFile = new File(this.statisticDirectory, "scalabilitySummary.png");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(chartSummaryFile);
            ImageIO.write((RenderedImage)chartImage, "png", out);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing graphStatisticFile: " + chartSummaryFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return "  <h2>Scalability summary chart</h2>\n  <img src=\"" + chartSummaryFile.getName() + "\"/>\n";
    }

    private CharSequence writeAverageCalculateCountPerSecondSummaryChart(List<SolverBenchmark> solverBenchmarkList) {
        NumberAxis xAxis = new NumberAxis("Problem scale");
        NumberAxis yAxis = new NumberAxis("Average calculate count per second");
        XYPlot plot = new XYPlot(null, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        int seriesIndex = 0;
        for (SolverBenchmark solverBenchmark : solverBenchmarkList) {
            XYSeries series = new XYSeries((Comparable)((Object)solverBenchmark.getName()));
            for (PlannerBenchmarkResult result : solverBenchmark.getPlannerBenchmarkResultList()) {
                long problemScale = result.getProblemScale();
                long averageCalculateCountPerSecond = result.getAverageCalculateCountPerSecond();
                series.add((Number)problemScale, (Number)averageCalculateCountPerSecond);
            }
            XYSeriesCollection seriesCollection = new XYSeriesCollection();
            seriesCollection.addSeries(series);
            plot.setDataset(seriesIndex, (XYDataset)seriesCollection);
            StandardXYItemRenderer renderer = new StandardXYItemRenderer(3);
            renderer.setSeriesStroke(0, (Stroke)new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f, 6.0f}, 0.0f));
            plot.setRenderer(seriesIndex, (XYItemRenderer)renderer);
            ++seriesIndex;
        }
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart("Average calculate count summary (higher is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        BufferedImage chartImage = chart.createBufferedImage(1024, 768);
        File chartSummaryFile = new File(this.statisticDirectory, "averageCalculateCountSummary.png");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(chartSummaryFile);
            ImageIO.write((RenderedImage)chartImage, "png", out);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing graphStatisticFile: " + chartSummaryFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return "  <h2>Average calculate count summary chart</h2>\n  <img src=\"" + chartSummaryFile.getName() + "\"/>\n";
    }

    private CharSequence writeBestScoreSummaryTable(List<SolverBenchmark> solverBenchmarkList) {
        StringBuilder htmlFragment = new StringBuilder(solverBenchmarkList.size() * 160);
        htmlFragment.append("  <h2>Best score summary table</h2>\n");
        htmlFragment.append("  <table border=\"1\">\n");
        htmlFragment.append("    <tr><th>Solver</th>");
        for (ProblemBenchmark problemBenchmark : this.problemBenchmarkList) {
            htmlFragment.append("<th>").append(problemBenchmark.getName()).append("</th>");
        }
        htmlFragment.append("<th>Average</th><th>Ranking</th></tr>\n");
        boolean oddLine = true;
        for (SolverBenchmark solverBenchmark : solverBenchmarkList) {
            String backgroundColor = solverBenchmark.isRankingBest() ? "Yellow" : (oddLine ? "White" : "LightGray");
            htmlFragment.append("    <tr style=\"background-color: ").append(backgroundColor).append("\"><th>").append(solverBenchmark.getName()).append("</th>");
            for (ProblemBenchmark problemBenchmark : this.problemBenchmarkList) {
                boolean noResult = true;
                for (PlannerBenchmarkResult result : solverBenchmark.getPlannerBenchmarkResultList()) {
                    if (!problemBenchmark.equals(result.getProblemBenchmark())) continue;
                    Score score = result.getScore();
                    htmlFragment.append("<td>").append(score.toString()).append("</td>");
                    noResult = false;
                    break;
                }
                if (!noResult) continue;
                htmlFragment.append("<td/>");
            }
            htmlFragment.append("<td>").append(solverBenchmark.getAverageScore().toString()).append("</td><td>").append(solverBenchmark.getRanking()).append("</td>");
            htmlFragment.append("</tr>\n");
            oddLine = !oddLine;
        }
        htmlFragment.append("  </table>\n");
        return htmlFragment.toString();
    }

    private void writeHtmlOverview(CharSequence htmlFragment) {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.htmlOverviewFile), "UTF-8");
            ((Writer)writer).append("<html>\n");
            ((Writer)writer).append("<head>\n");
            ((Writer)writer).append("  <title>Statistic ").append(this.benchmarkName).append("</title>\n");
            ((Writer)writer).append("</head>\n");
            ((Writer)writer).append("<body>\n");
            ((Writer)writer).append(htmlFragment);
            ((Writer)writer).append("</body>\n");
            ((Writer)writer).append("</html>\n");
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing htmlOverviewFile: " + this.htmlOverviewFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public File getHtmlOverviewFile() {
        return this.htmlOverviewFile;
    }
}

