/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.core.statistic.calculatecount;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.drools.planner.benchmark.core.statistic.AbstractProblemStatistic;
import org.drools.planner.benchmark.core.statistic.MillisecondsSpendNumberFormat;
import org.drools.planner.benchmark.core.statistic.ProblemStatisticType;
import org.drools.planner.benchmark.core.statistic.calculatecount.CalculateCountStatisticListener;
import org.drools.planner.benchmark.core.statistic.calculatecount.CalculateCountStatisticPoint;
import org.drools.planner.core.Solver;
import org.drools.planner.core.solver.DefaultSolver;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalculateCountStatistic
extends AbstractProblemStatistic {
    private List<String> configNameList = new ArrayList<String>();
    private Map<String, CalculateCountStatisticListener> statisticListenerMap = new LinkedHashMap<String, CalculateCountStatisticListener>();

    public CalculateCountStatistic() {
        super(ProblemStatisticType.CALCULATE_COUNT_PER_SECOND);
    }

    @Override
    public void addListener(Solver solver, String configName) {
        if (this.configNameList.contains(configName)) {
            throw new IllegalArgumentException("Cannot add a listener with the same configName (" + configName + ") twice.");
        }
        this.configNameList.add(configName);
        CalculateCountStatisticListener statisticListener = new CalculateCountStatisticListener();
        ((DefaultSolver)solver).addSolverPhaseLifecycleListener(statisticListener);
        this.statisticListenerMap.put(configName, statisticListener);
    }

    @Override
    public void removeListener(Solver solver, String configName) {
        CalculateCountStatisticListener statisticListener = this.statisticListenerMap.get(configName);
        ((DefaultSolver)solver).removeSolverPhaseLifecycleListener(statisticListener);
    }

    private List<CalculateCountScvLine> extractCsvLineList() {
        HashMap<Long, CalculateCountScvLine> timeToBestScoresLineMap = new HashMap<Long, CalculateCountScvLine>();
        for (Map.Entry<String, CalculateCountStatisticListener> listenerEntry : this.statisticListenerMap.entrySet()) {
            String configName = listenerEntry.getKey();
            List<CalculateCountStatisticPoint> statisticPointList = listenerEntry.getValue().getStatisticPointList();
            for (CalculateCountStatisticPoint statisticPoint : statisticPointList) {
                long timeMillisSpend = statisticPoint.getTimeMillisSpend();
                CalculateCountScvLine line = (CalculateCountScvLine)timeToBestScoresLineMap.get(timeMillisSpend);
                if (line == null) {
                    line = new CalculateCountScvLine(timeMillisSpend);
                    timeToBestScoresLineMap.put(timeMillisSpend, line);
                }
                line.getConfigNameToCalculateCountPerSecondMap().put(configName, statisticPoint.getCalculateCountPerSecond());
            }
        }
        ArrayList<CalculateCountScvLine> csvLineList = new ArrayList<CalculateCountScvLine>(timeToBestScoresLineMap.values());
        Collections.sort(csvLineList);
        return csvLineList;
    }

    @Override
    protected CharSequence writeCsvStatistic(File statisticDirectory, String baseName) {
        List<CalculateCountScvLine> csvLineList = this.extractCsvLineList();
        File csvStatisticFile = new File(statisticDirectory, baseName + "CalculateCountStatistic.csv");
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(csvStatisticFile), "UTF-8");
            ((Writer)writer).append("\"TimeMillisSpend\"");
            for (String configName : this.configNameList) {
                ((Writer)writer).append(",\"").append(configName.replaceAll("\\\"", "\\\"")).append("\"");
            }
            ((Writer)writer).append("\n");
            for (CalculateCountScvLine line : csvLineList) {
                writer.write(Long.toString(line.getTimeMillisSpend()));
                for (String configName : this.configNameList) {
                    ((Writer)writer).append(",");
                    Long calculateCountPerSecond = line.getConfigNameToCalculateCountPerSecondMap().get(configName);
                    if (calculateCountPerSecond == null) continue;
                    ((Writer)writer).append(calculateCountPerSecond.toString());
                }
                ((Writer)writer).append("\n");
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing csvStatisticFile: " + csvStatisticFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        return "  <p><a href=\"" + csvStatisticFile.getName() + "\">CVS file</a></p>\n";
    }

    @Override
    protected CharSequence writeGraphStatistic(File statisticDirectory, String baseName) {
        XYSeriesCollection seriesCollection = new XYSeriesCollection();
        for (Map.Entry<String, CalculateCountStatisticListener> listenerEntry : this.statisticListenerMap.entrySet()) {
            String configName = listenerEntry.getKey();
            XYSeries series = new XYSeries((Comparable)((Object)configName));
            List<CalculateCountStatisticPoint> statisticPointList = listenerEntry.getValue().getStatisticPointList();
            for (CalculateCountStatisticPoint statisticPoint : statisticPointList) {
                long timeMillisSpend = statisticPoint.getTimeMillisSpend();
                long calculateCountPerSecond = statisticPoint.getCalculateCountPerSecond();
                series.add((double)timeMillisSpend, (double)calculateCountPerSecond);
            }
            seriesCollection.addSeries(series);
        }
        NumberAxis xAxis = new NumberAxis("Time spend");
        xAxis.setNumberFormatOverride((NumberFormat)new MillisecondsSpendNumberFormat());
        NumberAxis yAxis = new NumberAxis("Calculate count per second");
        yAxis.setAutoRangeIncludesZero(false);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        XYPlot plot = new XYPlot((XYDataset)seriesCollection, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart(baseName + " calculate count statistic", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        BufferedImage chartImage = chart.createBufferedImage(1024, 768);
        File graphStatisticFile = new File(statisticDirectory, baseName + "CalculateCountStatistic.png");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(graphStatisticFile);
            ImageIO.write((RenderedImage)chartImage, "png", out);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing graphStatisticFile: " + graphStatisticFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return "  <img src=\"" + graphStatisticFile.getName() + "\"/>\n";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CalculateCountScvLine
    extends AbstractProblemStatistic.AbstractProblemStatisticScvLine {
        private Map<String, Long> configNameToCalculateCountPerSecondMap = new HashMap<String, Long>();

        public CalculateCountScvLine(long timeMillisSpend) {
            super(timeMillisSpend);
        }

        public Map<String, Long> getConfigNameToCalculateCountPerSecondMap() {
            return this.configNameToCalculateCountPerSecondMap;
        }
    }
}

