/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.localsearch.decider.acceptor;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.util.ConfigUtils;
import org.drools.planner.core.localsearch.decider.acceptor.Acceptor;
import org.drools.planner.core.localsearch.decider.acceptor.CompositeAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.greatdeluge.GreatDelugeAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.simulatedannealing.SimulatedAnnealingAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.MoveTabuAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.PlanningEntityTabuAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.PlanningValueTabuAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.SolutionTabuAcceptor;
import org.drools.planner.core.score.definition.ScoreDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="acceptor")
public class AcceptorConfig {
    @XStreamImplicit(itemFieldName="acceptorClass")
    private List<Class<? extends Acceptor>> acceptorClassList = null;
    @XStreamImplicit(itemFieldName="acceptorType")
    private List<AcceptorType> acceptorTypeList = null;
    protected Integer moveTabuSize = null;
    protected Integer partialMoveTabuSize = null;
    protected Integer undoMoveTabuSize = null;
    protected Integer partialUndoMoveTabuSize = null;
    protected Integer planningEntityTabuSize = null;
    protected Integer partialPlanningEntityTabuSize = null;
    protected Integer planningValueTabuSize = null;
    protected Integer partialPlanningValueTabuSize = null;
    protected Integer solutionTabuSize = null;
    protected Integer partialSolutionTabuSize = null;
    protected String simulatedAnnealingStartingTemperature = null;
    protected Double greatDelugeWaterLevelUpperBoundRate = null;
    protected Double greatDelugeWaterRisingRate = null;

    public List<Class<? extends Acceptor>> getAcceptorClassList() {
        return this.acceptorClassList;
    }

    public void setAcceptorClassList(List<Class<? extends Acceptor>> acceptorClassList) {
        this.acceptorClassList = acceptorClassList;
    }

    public List<AcceptorType> getAcceptorTypeList() {
        return this.acceptorTypeList;
    }

    public void setAcceptorTypeList(List<AcceptorType> acceptorTypeList) {
        this.acceptorTypeList = acceptorTypeList;
    }

    public Integer getMoveTabuSize() {
        return this.moveTabuSize;
    }

    public void setMoveTabuSize(Integer moveTabuSize) {
        this.moveTabuSize = moveTabuSize;
    }

    public Integer getPartialMoveTabuSize() {
        return this.partialMoveTabuSize;
    }

    public void setPartialMoveTabuSize(Integer partialMoveTabuSize) {
        this.partialMoveTabuSize = partialMoveTabuSize;
    }

    public Integer getUndoMoveTabuSize() {
        return this.undoMoveTabuSize;
    }

    public void setUndoMoveTabuSize(Integer undoMoveTabuSize) {
        this.undoMoveTabuSize = undoMoveTabuSize;
    }

    public Integer getPartialUndoMoveTabuSize() {
        return this.partialUndoMoveTabuSize;
    }

    public void setPartialUndoMoveTabuSize(Integer partialUndoMoveTabuSize) {
        this.partialUndoMoveTabuSize = partialUndoMoveTabuSize;
    }

    public Integer getPlanningEntityTabuSize() {
        return this.planningEntityTabuSize;
    }

    public void setPlanningEntityTabuSize(Integer planningEntityTabuSize) {
        this.planningEntityTabuSize = planningEntityTabuSize;
    }

    public Integer getPartialPlanningEntityTabuSize() {
        return this.partialPlanningEntityTabuSize;
    }

    public void setPartialPlanningEntityTabuSize(Integer partialPlanningEntityTabuSize) {
        this.partialPlanningEntityTabuSize = partialPlanningEntityTabuSize;
    }

    public Integer getPlanningValueTabuSize() {
        return this.planningValueTabuSize;
    }

    public void setPlanningValueTabuSize(Integer planningValueTabuSize) {
        this.planningValueTabuSize = planningValueTabuSize;
    }

    public Integer getPartialPlanningValueTabuSize() {
        return this.partialPlanningValueTabuSize;
    }

    public void setPartialPlanningValueTabuSize(Integer partialPlanningValueTabuSize) {
        this.partialPlanningValueTabuSize = partialPlanningValueTabuSize;
    }

    public Integer getSolutionTabuSize() {
        return this.solutionTabuSize;
    }

    public void setSolutionTabuSize(Integer solutionTabuSize) {
        this.solutionTabuSize = solutionTabuSize;
    }

    public Integer getPartialSolutionTabuSize() {
        return this.partialSolutionTabuSize;
    }

    public void setPartialSolutionTabuSize(Integer partialSolutionTabuSize) {
        this.partialSolutionTabuSize = partialSolutionTabuSize;
    }

    public String getSimulatedAnnealingStartingTemperature() {
        return this.simulatedAnnealingStartingTemperature;
    }

    public void setSimulatedAnnealingStartingTemperature(String simulatedAnnealingStartingTemperature) {
        this.simulatedAnnealingStartingTemperature = simulatedAnnealingStartingTemperature;
    }

    public Double getGreatDelugeWaterLevelUpperBoundRate() {
        return this.greatDelugeWaterLevelUpperBoundRate;
    }

    public void setGreatDelugeWaterLevelUpperBoundRate(Double greatDelugeWaterLevelUpperBoundRate) {
        this.greatDelugeWaterLevelUpperBoundRate = greatDelugeWaterLevelUpperBoundRate;
    }

    public Double getGreatDelugeWaterRisingRate() {
        return this.greatDelugeWaterRisingRate;
    }

    public void setGreatDelugeWaterRisingRate(Double greatDelugeWaterRisingRate) {
        this.greatDelugeWaterRisingRate = greatDelugeWaterRisingRate;
    }

    public Acceptor buildAcceptor(EnvironmentMode environmentMode, ScoreDefinition scoreDefinition) {
        ArrayList<Acceptor> acceptorList = new ArrayList<Acceptor>();
        if (this.acceptorClassList != null) {
            for (Class<? extends Acceptor> acceptorClass : this.acceptorClassList) {
                try {
                    acceptorList.add(acceptorClass.newInstance());
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("acceptorClass (" + acceptorClass.getName() + ") does not have a public no-arg constructor", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("acceptorClass (" + acceptorClass.getName() + ") does not have a public no-arg constructor", e);
                }
            }
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.MOVE_TABU) || this.moveTabuSize != null || this.partialMoveTabuSize != null) {
            MoveTabuAcceptor moveTabuAcceptor = new MoveTabuAcceptor();
            moveTabuAcceptor.setUseUndoMoveAsTabuMove(false);
            if (this.moveTabuSize != null) {
                moveTabuAcceptor.setTabuSize(this.moveTabuSize);
            }
            if (this.partialMoveTabuSize != null) {
                moveTabuAcceptor.setPartialTabuSize(this.partialMoveTabuSize);
            }
            if (environmentMode == EnvironmentMode.TRACE) {
                moveTabuAcceptor.setAssertTabuHashCodeCorrectness(true);
            }
            acceptorList.add(moveTabuAcceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.UNDO_MOVE_TABU) || this.undoMoveTabuSize != null || this.partialUndoMoveTabuSize != null) {
            MoveTabuAcceptor undoMoveTabuAcceptor = new MoveTabuAcceptor();
            undoMoveTabuAcceptor.setUseUndoMoveAsTabuMove(true);
            if (this.undoMoveTabuSize != null) {
                undoMoveTabuAcceptor.setTabuSize(this.undoMoveTabuSize);
            }
            if (this.partialUndoMoveTabuSize != null) {
                undoMoveTabuAcceptor.setPartialTabuSize(this.partialUndoMoveTabuSize);
            }
            if (environmentMode == EnvironmentMode.TRACE) {
                undoMoveTabuAcceptor.setAssertTabuHashCodeCorrectness(true);
            }
            acceptorList.add(undoMoveTabuAcceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.PLANNING_ENTITY_TABU) || this.planningEntityTabuSize != null || this.partialPlanningEntityTabuSize != null) {
            PlanningEntityTabuAcceptor planningEntityTabuAcceptor = new PlanningEntityTabuAcceptor();
            if (this.planningEntityTabuSize != null) {
                planningEntityTabuAcceptor.setTabuSize(this.planningEntityTabuSize);
            }
            if (this.partialPlanningEntityTabuSize != null) {
                planningEntityTabuAcceptor.setPartialTabuSize(this.partialPlanningEntityTabuSize);
            }
            if (environmentMode == EnvironmentMode.TRACE) {
                planningEntityTabuAcceptor.setAssertTabuHashCodeCorrectness(true);
            }
            acceptorList.add(planningEntityTabuAcceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.PLANNING_VALUE_TABU) || this.planningValueTabuSize != null || this.partialPlanningValueTabuSize != null) {
            PlanningValueTabuAcceptor planningValueTabuAcceptor = new PlanningValueTabuAcceptor();
            if (this.planningValueTabuSize != null) {
                planningValueTabuAcceptor.setTabuSize(this.planningValueTabuSize);
            }
            if (this.partialPlanningValueTabuSize != null) {
                planningValueTabuAcceptor.setPartialTabuSize(this.partialPlanningValueTabuSize);
            }
            if (environmentMode == EnvironmentMode.TRACE) {
                planningValueTabuAcceptor.setAssertTabuHashCodeCorrectness(true);
            }
            acceptorList.add(planningValueTabuAcceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.SOLUTION_TABU) || this.solutionTabuSize != null || this.partialSolutionTabuSize != null) {
            SolutionTabuAcceptor solutionTabuAcceptor = new SolutionTabuAcceptor();
            if (this.solutionTabuSize != null) {
                solutionTabuAcceptor.setTabuSize(this.solutionTabuSize);
            }
            if (this.partialSolutionTabuSize != null) {
                solutionTabuAcceptor.setPartialTabuSize(this.partialSolutionTabuSize);
            }
            if (environmentMode == EnvironmentMode.TRACE) {
                solutionTabuAcceptor.setAssertTabuHashCodeCorrectness(true);
            }
            acceptorList.add(solutionTabuAcceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.SIMULATED_ANNEALING) || this.simulatedAnnealingStartingTemperature != null) {
            SimulatedAnnealingAcceptor simulatedAnnealingAcceptor = new SimulatedAnnealingAcceptor();
            simulatedAnnealingAcceptor.setStartingTemperature(scoreDefinition.parseScore(this.simulatedAnnealingStartingTemperature));
            acceptorList.add(simulatedAnnealingAcceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.GREAT_DELUGE) || this.greatDelugeWaterLevelUpperBoundRate != null || this.greatDelugeWaterRisingRate != null) {
            double waterLevelUpperBoundRate = (Double)ObjectUtils.defaultIfNull((Object)this.greatDelugeWaterLevelUpperBoundRate, (Object)1.2);
            double waterRisingRate = (Double)ObjectUtils.defaultIfNull((Object)this.greatDelugeWaterRisingRate, (Object)1.0E-7);
            acceptorList.add(new GreatDelugeAcceptor(waterLevelUpperBoundRate, waterRisingRate));
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.LATE_ACCEPTANCE)) {
            throw new UnsupportedOperationException("LATE_ACCEPTANCE not yet supported.");
        }
        if (acceptorList.size() == 1) {
            return (Acceptor)acceptorList.get(0);
        }
        if (acceptorList.size() > 1) {
            CompositeAcceptor compositeAcceptor = new CompositeAcceptor();
            compositeAcceptor.setAcceptorList(acceptorList);
            return compositeAcceptor;
        }
        SolutionTabuAcceptor solutionTabuAcceptor = new SolutionTabuAcceptor();
        solutionTabuAcceptor.setTabuSize(1500);
        if (environmentMode == EnvironmentMode.TRACE) {
            solutionTabuAcceptor.setAssertTabuHashCodeCorrectness(true);
        }
        return solutionTabuAcceptor;
    }

    public void inherit(AcceptorConfig inheritedConfig) {
        this.acceptorClassList = ConfigUtils.inheritMergeableListProperty(this.acceptorClassList, inheritedConfig.getAcceptorClassList());
        if (this.acceptorTypeList == null) {
            this.acceptorTypeList = inheritedConfig.getAcceptorTypeList();
        } else {
            List<AcceptorType> inheritedAcceptorTypeList = inheritedConfig.getAcceptorTypeList();
            if (inheritedAcceptorTypeList != null) {
                for (AcceptorType acceptorType : inheritedAcceptorTypeList) {
                    if (this.acceptorTypeList.contains((Object)acceptorType)) continue;
                    this.acceptorTypeList.add(acceptorType);
                }
            }
        }
        if (this.moveTabuSize == null) {
            this.moveTabuSize = inheritedConfig.getMoveTabuSize();
        }
        if (this.partialMoveTabuSize == null) {
            this.partialMoveTabuSize = inheritedConfig.getPartialMoveTabuSize();
        }
        if (this.undoMoveTabuSize == null) {
            this.undoMoveTabuSize = inheritedConfig.getUndoMoveTabuSize();
        }
        if (this.partialUndoMoveTabuSize == null) {
            this.partialUndoMoveTabuSize = inheritedConfig.getPartialUndoMoveTabuSize();
        }
        if (this.planningEntityTabuSize == null) {
            this.planningEntityTabuSize = inheritedConfig.getPlanningEntityTabuSize();
        }
        if (this.partialPlanningEntityTabuSize == null) {
            this.partialPlanningEntityTabuSize = inheritedConfig.getPartialPlanningEntityTabuSize();
        }
        if (this.solutionTabuSize == null) {
            this.solutionTabuSize = inheritedConfig.getSolutionTabuSize();
        }
        if (this.partialSolutionTabuSize == null) {
            this.partialSolutionTabuSize = inheritedConfig.getPartialSolutionTabuSize();
        }
        if (this.simulatedAnnealingStartingTemperature == null) {
            this.simulatedAnnealingStartingTemperature = inheritedConfig.getSimulatedAnnealingStartingTemperature();
        }
        if (this.greatDelugeWaterLevelUpperBoundRate == null) {
            this.greatDelugeWaterLevelUpperBoundRate = inheritedConfig.getGreatDelugeWaterLevelUpperBoundRate();
        }
        if (this.greatDelugeWaterRisingRate == null) {
            this.greatDelugeWaterRisingRate = inheritedConfig.getGreatDelugeWaterRisingRate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AcceptorType {
        PLANNING_ENTITY_TABU,
        PLANNING_VALUE_TABU,
        MOVE_TABU,
        UNDO_MOVE_TABU,
        SOLUTION_TABU,
        SIMULATED_ANNEALING,
        LATE_ACCEPTANCE,
        GREAT_DELUGE;

    }
}

