/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.score.director;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.planner.config.util.ConfigUtils;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.score.buildin.hardandsoft.HardAndSoftScoreDefinition;
import org.drools.planner.core.score.buildin.hardandsoftlong.HardAndSoftLongScoreDefinition;
import org.drools.planner.core.score.buildin.simple.SimpleScoreDefinition;
import org.drools.planner.core.score.buildin.simpledouble.SimpleDoubleScoreDefinition;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.score.director.AbstractScoreDirectorFactory;
import org.drools.planner.core.score.director.ScoreDirectorFactory;
import org.drools.planner.core.score.director.drools.DroolsScoreDirectorFactory;
import org.drools.planner.core.score.director.incremental.IncrementalScoreCalculator;
import org.drools.planner.core.score.director.incremental.IncrementalScoreDirectorFactory;
import org.drools.planner.core.score.director.simple.SimpleScoreCalculator;
import org.drools.planner.core.score.director.simple.SimpleScoreDirectorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="scoreDirectorFactory")
public class ScoreDirectorFactoryConfig {
    protected ScoreDefinition scoreDefinition = null;
    protected Class<? extends ScoreDefinition> scoreDefinitionClass = null;
    protected ScoreDefinitionType scoreDefinitionType = null;
    @XStreamOmitField
    protected SimpleScoreCalculator simpleScoreCalculator = null;
    protected Class<? extends SimpleScoreCalculator> simpleScoreCalculatorClass = null;
    protected Class<? extends IncrementalScoreCalculator> incrementalScoreCalculatorClass = null;
    @XStreamOmitField
    protected RuleBase ruleBase = null;
    @XStreamImplicit(itemFieldName="scoreDrl")
    protected List<String> scoreDrlList = null;

    public ScoreDefinition getScoreDefinition() {
        return this.scoreDefinition;
    }

    public void setScoreDefinition(ScoreDefinition scoreDefinition) {
        this.scoreDefinition = scoreDefinition;
    }

    public Class<? extends ScoreDefinition> getScoreDefinitionClass() {
        return this.scoreDefinitionClass;
    }

    public void setScoreDefinitionClass(Class<? extends ScoreDefinition> scoreDefinitionClass) {
        this.scoreDefinitionClass = scoreDefinitionClass;
    }

    public ScoreDefinitionType getScoreDefinitionType() {
        return this.scoreDefinitionType;
    }

    public void setScoreDefinitionType(ScoreDefinitionType scoreDefinitionType) {
        this.scoreDefinitionType = scoreDefinitionType;
    }

    public SimpleScoreCalculator getSimpleScoreCalculator() {
        return this.simpleScoreCalculator;
    }

    public void setSimpleScoreCalculator(SimpleScoreCalculator simpleScoreCalculator) {
        this.simpleScoreCalculator = simpleScoreCalculator;
    }

    public Class<? extends SimpleScoreCalculator> getSimpleScoreCalculatorClass() {
        return this.simpleScoreCalculatorClass;
    }

    public void setSimpleScoreCalculatorClass(Class<? extends SimpleScoreCalculator> simpleScoreCalculatorClass) {
        this.simpleScoreCalculatorClass = simpleScoreCalculatorClass;
    }

    public Class<? extends IncrementalScoreCalculator> getIncrementalScoreCalculatorClass() {
        return this.incrementalScoreCalculatorClass;
    }

    public void setIncrementalScoreCalculatorClass(Class<? extends IncrementalScoreCalculator> incrementalScoreCalculatorClass) {
        this.incrementalScoreCalculatorClass = incrementalScoreCalculatorClass;
    }

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public void setRuleBase(RuleBase ruleBase) {
        this.ruleBase = ruleBase;
    }

    public List<String> getScoreDrlList() {
        return this.scoreDrlList;
    }

    public void setScoreDrlList(List<String> scoreDrlList) {
        this.scoreDrlList = scoreDrlList;
    }

    public ScoreDirectorFactory buildScoreDirectorFactory(SolutionDescriptor solutionDescriptor) {
        ScoreDefinition scoreDefinition = this.buildScoreDefinition();
        AbstractScoreDirectorFactory scoreDirectorFactory = this.buildSimpleScoreDirectorFactory();
        if (scoreDirectorFactory == null) {
            scoreDirectorFactory = this.buildIncrementalScoreDirectorFactory();
        }
        if (scoreDirectorFactory == null) {
            scoreDirectorFactory = this.buildDroolsScoreDirectorFactory();
        }
        scoreDirectorFactory.setSolutionDescriptor(solutionDescriptor);
        scoreDirectorFactory.setScoreDefinition(scoreDefinition);
        return scoreDirectorFactory;
    }

    public ScoreDefinition buildScoreDefinition() {
        if (this.scoreDefinition != null) {
            return this.scoreDefinition;
        }
        if (this.scoreDefinitionClass != null) {
            try {
                return this.scoreDefinitionClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("scoreDefinitionClass (" + this.scoreDefinitionClass.getName() + ") does not have a public no-arg constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("scoreDefinitionClass (" + this.scoreDefinitionClass.getName() + ") does not have a public no-arg constructor", e);
            }
        }
        if (this.scoreDefinitionType != null) {
            switch (this.scoreDefinitionType) {
                case SIMPLE: {
                    return new SimpleScoreDefinition();
                }
                case SIMPLE_DOUBLE: {
                    return new SimpleDoubleScoreDefinition();
                }
                case HARD_AND_SOFT: {
                    return new HardAndSoftScoreDefinition();
                }
                case HARD_AND_SOFT_LONG: {
                    return new HardAndSoftLongScoreDefinition();
                }
            }
            throw new IllegalStateException("The scoreDefinitionType (" + (Object)((Object)this.scoreDefinitionType) + ") is not implemented");
        }
        return new SimpleScoreDefinition();
    }

    private AbstractScoreDirectorFactory buildSimpleScoreDirectorFactory() {
        if (this.simpleScoreCalculator != null) {
            return new SimpleScoreDirectorFactory(this.simpleScoreCalculator);
        }
        if (this.simpleScoreCalculatorClass != null) {
            SimpleScoreCalculator simpleScoreCalculator;
            try {
                simpleScoreCalculator = this.simpleScoreCalculatorClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("simpleScoreCalculatorClass (" + this.simpleScoreCalculatorClass.getName() + ") does not have a public no-arg constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("simpleScoreCalculatorClass (" + this.simpleScoreCalculatorClass.getName() + ") does not have a public no-arg constructor", e);
            }
            return new SimpleScoreDirectorFactory(simpleScoreCalculator);
        }
        return null;
    }

    private AbstractScoreDirectorFactory buildIncrementalScoreDirectorFactory() {
        if (this.incrementalScoreCalculatorClass != null) {
            return new IncrementalScoreDirectorFactory(this.incrementalScoreCalculatorClass);
        }
        return null;
    }

    private AbstractScoreDirectorFactory buildDroolsScoreDirectorFactory() {
        DroolsScoreDirectorFactory scoreDirectorFactory = new DroolsScoreDirectorFactory();
        scoreDirectorFactory.setRuleBase(this.buildRuleBase());
        return scoreDirectorFactory;
    }

    private RuleBase buildRuleBase() {
        if (this.ruleBase != null) {
            if (this.scoreDrlList != null && !this.scoreDrlList.isEmpty()) {
                throw new IllegalArgumentException("If ruleBase is not null, the scoreDrlList (" + this.scoreDrlList + ") must be empty.");
            }
            return this.ruleBase;
        }
        PackageBuilder packageBuilder = new PackageBuilder();
        for (String scoreDrl : this.scoreDrlList) {
            InputStream scoreDrlIn = this.getClass().getResourceAsStream(scoreDrl);
            if (scoreDrlIn == null) {
                throw new IllegalArgumentException("scoreDrl (" + scoreDrl + ") does not exist as a classpath resource.");
            }
            try {
                packageBuilder.addPackageFromDrl((Reader)new InputStreamReader(scoreDrlIn, "UTF-8"));
            }
            catch (DroolsParserException e) {
                throw new IllegalArgumentException("scoreDrl (" + scoreDrl + ") could not be loaded.", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("scoreDrl (" + scoreDrl + ") could not be loaded.", e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)scoreDrlIn);
            }
        }
        RuleBaseConfiguration ruleBaseConfiguration = new RuleBaseConfiguration();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)ruleBaseConfiguration);
        if (packageBuilder.hasErrors()) {
            throw new IllegalStateException("There are errors in the scoreDrl's:\n" + packageBuilder.getErrors().toString());
        }
        ruleBase.addPackage(packageBuilder.getPackage());
        return ruleBase;
    }

    public void inherit(ScoreDirectorFactoryConfig inheritedConfig) {
        if (this.scoreDefinition == null && this.scoreDefinitionClass == null && this.scoreDefinitionType == null) {
            this.scoreDefinition = inheritedConfig.getScoreDefinition();
            this.scoreDefinitionClass = inheritedConfig.getScoreDefinitionClass();
            this.scoreDefinitionType = inheritedConfig.getScoreDefinitionType();
        }
        if (this.simpleScoreCalculator == null) {
            this.simpleScoreCalculator = inheritedConfig.getSimpleScoreCalculator();
        }
        if (this.simpleScoreCalculatorClass == null) {
            this.simpleScoreCalculatorClass = inheritedConfig.getSimpleScoreCalculatorClass();
        }
        if (this.incrementalScoreCalculatorClass == null) {
            this.incrementalScoreCalculatorClass = inheritedConfig.getIncrementalScoreCalculatorClass();
        }
        if (this.ruleBase == null) {
            this.ruleBase = inheritedConfig.getRuleBase();
        }
        this.scoreDrlList = ConfigUtils.inheritMergeableListProperty(this.scoreDrlList, inheritedConfig.getScoreDrlList());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScoreDefinitionType {
        SIMPLE,
        SIMPLE_DOUBLE,
        HARD_AND_SOFT,
        HARD_AND_SOFT_LONG;

    }
}

