/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.bestsolution;

import org.drools.planner.core.event.SolverEventSupport;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solver.DefaultSolverScope;
import org.drools.planner.core.solver.event.SolverLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestSolutionRecaller
implements SolverLifecycleListener {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SolverEventSupport solverEventSupport;

    public void setSolverEventSupport(SolverEventSupport solverEventSupport) {
        this.solverEventSupport = solverEventSupport;
    }

    public void solvingStarted(DefaultSolverScope solverScope) {
        boolean workingSolutionInitialized = solverScope.isWorkingSolutionInitialized();
        Score startingInitializedScore = workingSolutionInitialized ? solverScope.calculateScore() : null;
        solverScope.setStartingInitializedScore(startingInitializedScore);
        solverScope.setBestScore(startingInitializedScore);
    }

    public void extractBestSolution(AbstractStepScope stepScope) {
        boolean bestScoreImproved;
        if (!stepScope.isSolutionInitialized()) {
            return;
        }
        AbstractSolverPhaseScope solverPhaseScope = stepScope.getSolverPhaseScope();
        DefaultSolverScope solverScope = solverPhaseScope.getSolverScope();
        Score newScore = stepScope.getScore();
        Score bestScore = solverPhaseScope.getBestScore();
        if (bestScore == null) {
            bestScoreImproved = true;
            solverScope.setStartingInitializedScore(newScore);
        } else {
            bestScoreImproved = newScore.compareTo(bestScore) > 0;
        }
        stepScope.setBestScoreImproved(bestScoreImproved);
        if (bestScoreImproved) {
            solverPhaseScope.setBestSolutionStepIndex(stepScope.getStepIndex());
            Solution newBestSolution = stepScope.createOrGetClonedSolution();
            this.updateBestSolution(solverScope, newBestSolution);
        }
    }

    public void updateBestSolution(DefaultSolverScope solverScope, Solution newBestSolution) {
        solverScope.setBestSolution(newBestSolution);
        solverScope.setBestScore((Score)newBestSolution.getScore());
        this.solverEventSupport.fireBestSolutionChanged(newBestSolution);
    }

    public void solvingEnded(DefaultSolverScope solverScope) {
    }
}

