/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.constructionheuristic.greedyFit;

import java.util.Iterator;
import org.drools.planner.core.constructionheuristic.greedyFit.GreedyFitSolverPhase;
import org.drools.planner.core.constructionheuristic.greedyFit.GreedyFitSolverPhaseScope;
import org.drools.planner.core.constructionheuristic.greedyFit.GreedyFitStepScope;
import org.drools.planner.core.constructionheuristic.greedyFit.decider.GreedyDecider;
import org.drools.planner.core.constructionheuristic.greedyFit.selector.GreedyPlanningEntitySelector;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.phase.AbstractSolverPhase;
import org.drools.planner.core.solver.DefaultSolverScope;

public class DefaultGreedyFitSolverPhase
extends AbstractSolverPhase
implements GreedyFitSolverPhase {
    protected GreedyPlanningEntitySelector greedyPlanningEntitySelector;
    protected GreedyDecider greedyDecider;
    protected boolean assertStepScoreIsUncorrupted = false;

    public void setGreedyPlanningEntitySelector(GreedyPlanningEntitySelector greedyPlanningEntitySelector) {
        this.greedyPlanningEntitySelector = greedyPlanningEntitySelector;
    }

    public void setGreedyDecider(GreedyDecider greedyDecider) {
        this.greedyDecider = greedyDecider;
    }

    public void setAssertStepScoreIsUncorrupted(boolean assertStepScoreIsUncorrupted) {
        this.assertStepScoreIsUncorrupted = assertStepScoreIsUncorrupted;
    }

    public void solve(DefaultSolverScope solverScope) {
        GreedyFitSolverPhaseScope solverPhaseScope = new GreedyFitSolverPhaseScope(solverScope);
        this.phaseStarted(solverPhaseScope);
        GreedyFitStepScope stepScope = this.createNextStepScope(solverPhaseScope, null);
        Iterator<Object> it = this.greedyPlanningEntitySelector.iterator();
        while (!this.termination.isPhaseTerminated(solverPhaseScope) && it.hasNext()) {
            Object planningEntity = it.next();
            stepScope.setPlanningEntity(planningEntity);
            this.beforeDeciding(stepScope);
            this.greedyDecider.decideNextStep(stepScope);
            Move nextStep = stepScope.getStep();
            if (nextStep == null) {
                this.logger.warn("    Cancelled step index ({}), time spend ({}): there is no doable move. Terminating phase early.", (Object)stepScope.getStepIndex(), (Object)solverPhaseScope.calculateSolverTimeMillisSpend());
                break;
            }
            nextStep.doMove(stepScope.getScoreDirector());
            solverPhaseScope.getWorkingSolution().setScore(stepScope.getScore());
            if (this.assertStepScoreIsUncorrupted) {
                solverPhaseScope.assertWorkingScore(stepScope.getScore());
            }
            if (!it.hasNext()) {
                stepScope.setSolutionInitialized(true);
            }
            this.stepTaken(stepScope);
            stepScope = this.createNextStepScope(solverPhaseScope, stepScope);
        }
        this.phaseEnded(solverPhaseScope);
    }

    private GreedyFitStepScope createNextStepScope(GreedyFitSolverPhaseScope greedyFitSolverPhaseScope, GreedyFitStepScope completedGreedyFitStepScope) {
        if (completedGreedyFitStepScope == null) {
            completedGreedyFitStepScope = new GreedyFitStepScope(greedyFitSolverPhaseScope);
            completedGreedyFitStepScope.setScore(greedyFitSolverPhaseScope.getStartingScore());
            completedGreedyFitStepScope.setStepIndex(-1);
        }
        greedyFitSolverPhaseScope.setLastCompletedGreedyFitStepScope(completedGreedyFitStepScope);
        GreedyFitStepScope greedyFitStepScope = new GreedyFitStepScope(greedyFitSolverPhaseScope);
        greedyFitStepScope.setStepIndex(completedGreedyFitStepScope.getStepIndex() + 1);
        greedyFitStepScope.setSolutionInitialized(false);
        return greedyFitStepScope;
    }

    public void phaseStarted(GreedyFitSolverPhaseScope greedyFitSolverPhaseScope) {
        super.phaseStarted(greedyFitSolverPhaseScope);
        this.greedyPlanningEntitySelector.phaseStarted(greedyFitSolverPhaseScope);
        this.greedyDecider.phaseStarted(greedyFitSolverPhaseScope);
    }

    public void beforeDeciding(GreedyFitStepScope greedyFitStepScope) {
        super.beforeDeciding(greedyFitStepScope);
        this.greedyPlanningEntitySelector.beforeDeciding(greedyFitStepScope);
        this.greedyDecider.beforeDeciding(greedyFitStepScope);
    }

    public void stepTaken(GreedyFitStepScope greedyFitStepScope) {
        super.stepTaken(greedyFitStepScope);
        this.greedyPlanningEntitySelector.stepTaken(greedyFitStepScope);
        this.greedyDecider.stepTaken(greedyFitStepScope);
        this.logger.debug("    Step index ({}), time spend ({}), score ({}), initialized planning entity ({}).", new Object[]{greedyFitStepScope.getStepIndex(), greedyFitStepScope.getGreedyFitSolverPhaseScope().calculateSolverTimeMillisSpend(), greedyFitStepScope.getScore(), greedyFitStepScope.getPlanningEntity()});
    }

    public void phaseEnded(GreedyFitSolverPhaseScope greedyFitSolverPhaseScope) {
        super.phaseEnded(greedyFitSolverPhaseScope);
        this.greedyPlanningEntitySelector.phaseEnded(greedyFitSolverPhaseScope);
        this.greedyDecider.phaseEnded(greedyFitSolverPhaseScope);
        this.logger.info("Phase constructionHeuristic ended: step total ({}), time spend ({}), best score ({}).", new Object[]{greedyFitSolverPhaseScope.getLastCompletedStepScope().getStepIndex() + 1, greedyFitSolverPhaseScope.calculateSolverTimeMillisSpend(), greedyFitSolverPhaseScope.getBestScore()});
    }
}

