/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.constructionheuristic.greedyFit.decider;

import java.util.Iterator;
import org.drools.planner.core.constructionheuristic.greedyFit.GreedyFitSolverPhaseScope;
import org.drools.planner.core.constructionheuristic.greedyFit.GreedyFitStepScope;
import org.drools.planner.core.constructionheuristic.greedyFit.decider.GreedyDecider;
import org.drools.planner.core.constructionheuristic.greedyFit.decider.GreedyMoveScope;
import org.drools.planner.core.constructionheuristic.greedyFit.decider.forager.GreedyForager;
import org.drools.planner.core.heuristic.selector.variable.PlanningVariableWalker;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.director.ScoreDirector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGreedyDecider
implements GreedyDecider {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private PlanningVariableWalker planningVariableWalker;
    private GreedyForager forager;
    protected boolean assertMoveScoreIsUncorrupted = false;
    protected boolean assertUndoMoveIsUncorrupted = false;

    public void setPlanningVariableWalker(PlanningVariableWalker planningVariableWalker) {
        this.planningVariableWalker = planningVariableWalker;
    }

    public void setForager(GreedyForager forager) {
        this.forager = forager;
    }

    public void setAssertMoveScoreIsUncorrupted(boolean assertMoveScoreIsUncorrupted) {
        this.assertMoveScoreIsUncorrupted = assertMoveScoreIsUncorrupted;
    }

    public void setAssertUndoMoveIsUncorrupted(boolean assertUndoMoveIsUncorrupted) {
        this.assertUndoMoveIsUncorrupted = assertUndoMoveIsUncorrupted;
    }

    public void phaseStarted(GreedyFitSolverPhaseScope greedyFitSolverPhaseScope) {
        this.planningVariableWalker.phaseStarted(greedyFitSolverPhaseScope);
        this.forager.phaseStarted(greedyFitSolverPhaseScope);
    }

    public void beforeDeciding(GreedyFitStepScope greedyFitStepScope) {
        this.planningVariableWalker.beforeDeciding(greedyFitStepScope);
        this.forager.beforeDeciding(greedyFitStepScope);
    }

    public void decideNextStep(GreedyFitStepScope stepScope) {
        GreedyMoveScope pickedMoveScope;
        Object planningEntity = stepScope.getPlanningEntity();
        Iterator<Move> moveIterator = this.planningVariableWalker.moveIterator(planningEntity);
        while (moveIterator.hasNext()) {
            Move move = moveIterator.next();
            GreedyMoveScope moveScope = new GreedyMoveScope(stepScope);
            moveScope.setMove(move);
            this.doMove(moveScope);
            if (!this.forager.isQuitEarly()) continue;
            break;
        }
        if ((pickedMoveScope = this.forager.pickMove(stepScope)) != null) {
            Move step = pickedMoveScope.getMove();
            stepScope.setStep(step);
            if (this.logger.isDebugEnabled()) {
                stepScope.setStepString(step.toString());
            }
            stepScope.setUndoStep(pickedMoveScope.getUndoMove());
            stepScope.setScore(pickedMoveScope.getScore());
        }
    }

    private void doMove(GreedyMoveScope moveScope) {
        Score lastCompletedStepScore;
        GreedyFitSolverPhaseScope greedyFitSolverPhaseScope;
        Score undoScore;
        ScoreDirector scoreDirector = moveScope.getScoreDirector();
        Move move = moveScope.getMove();
        Move undoMove = move.createUndoMove(scoreDirector);
        moveScope.setUndoMove(undoMove);
        move.doMove(scoreDirector);
        this.processMove(moveScope);
        undoMove.doMove(scoreDirector);
        if (this.assertUndoMoveIsUncorrupted && !(undoScore = (greedyFitSolverPhaseScope = moveScope.getGreedyFitStepScope().getGreedyFitSolverPhaseScope()).calculateScore()).equals(lastCompletedStepScore = greedyFitSolverPhaseScope.getLastCompletedStepScope().getScore())) {
            greedyFitSolverPhaseScope.getSolverScope().getScoreDirector().assertWorkingScore(undoScore);
            throw new IllegalStateException("The moveClass (" + move.getClass() + ")'s move (" + move + ") probably has a corrupted undoMove (" + undoMove + ")." + " Or maybe there are corrupted score rules.\n" + "Check the Move.createUndoMove(...) method of that Move class" + " and enable EnvironmentMode TRACE to fail-faster on corrupted score rules.\n" + "Score corruption: the lastCompletedStepScore (" + lastCompletedStepScore + ") is not the undoScore (" + undoScore + ").");
        }
        this.logger.trace("        Move score ({}) for move ({}).", new Object[]{moveScope.getScore(), moveScope.getMove()});
    }

    private void processMove(GreedyMoveScope moveScope) {
        Score score = moveScope.getGreedyFitStepScope().getGreedyFitSolverPhaseScope().calculateScore();
        if (this.assertMoveScoreIsUncorrupted) {
            moveScope.getGreedyFitStepScope().getGreedyFitSolverPhaseScope().assertWorkingScore(score);
        }
        moveScope.setScore(score);
        this.forager.addMove(moveScope);
    }

    public void stepTaken(GreedyFitStepScope greedyFitStepScope) {
        this.planningVariableWalker.stepTaken(greedyFitStepScope);
        this.forager.stepTaken(greedyFitStepScope);
    }

    public void phaseEnded(GreedyFitSolverPhaseScope greedyFitSolverPhaseScope) {
        this.planningVariableWalker.phaseEnded(greedyFitSolverPhaseScope);
        this.forager.phaseEnded(greedyFitSolverPhaseScope);
    }
}

