/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.entity;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.entity.PlanningEntitySorter;
import org.drools.planner.core.heuristic.selector.entity.PlanningEntitySelectionOrder;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListenerAdapter;
import org.drools.planner.core.score.director.ScoreDirector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanningEntitySelector
extends SolverPhaseLifecycleListenerAdapter
implements Iterable<Object> {
    private PlanningEntityDescriptor planningEntityDescriptor;
    private PlanningEntitySelectionOrder selectionOrder = PlanningEntitySelectionOrder.ORIGINAL;
    private boolean resetInitializedPlanningEntities = false;
    private List<Object> selectedPlanningEntityList = null;

    public PlanningEntitySelector(PlanningEntityDescriptor planningEntityDescriptor) {
        this.planningEntityDescriptor = planningEntityDescriptor;
    }

    public void setSelectionOrder(PlanningEntitySelectionOrder selectionOrder) {
        this.selectionOrder = selectionOrder;
    }

    public void setResetInitializedPlanningEntities(boolean resetInitializedPlanningEntities) {
        this.resetInitializedPlanningEntities = resetInitializedPlanningEntities;
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope solverPhaseScope) {
        this.validateConfiguration();
        this.initSelectedPlanningEntityList(solverPhaseScope);
    }

    private void validateConfiguration() {
        PlanningEntitySorter planningEntitySorter;
        if (this.selectionOrder == PlanningEntitySelectionOrder.DECREASING_DIFFICULTY && !(planningEntitySorter = this.planningEntityDescriptor.getPlanningEntitySorter()).isSortDifficultySupported()) {
            throw new IllegalStateException("The selectionOrder (" + (Object)((Object)this.selectionOrder) + ") can not be used on a PlanningEntity (" + this.planningEntityDescriptor.getPlanningEntityClass().getName() + ") that has no support for difficulty sorting. Check the @PlanningEntity annotation.");
        }
    }

    private void initSelectedPlanningEntityList(AbstractSolverPhaseScope solverPhaseScope) {
        List<Object> workingPlanningEntityList = solverPhaseScope.getWorkingPlanningEntityList();
        Iterator<Object> it = workingPlanningEntityList.iterator();
        while (it.hasNext()) {
            Object planningEntity = it.next();
            if (!this.planningEntityDescriptor.getPlanningEntityClass().isInstance(planningEntity)) {
                it.remove();
                continue;
            }
            if (!this.planningEntityDescriptor.isInitialized(planningEntity)) continue;
            if (this.resetInitializedPlanningEntities) {
                ScoreDirector scoreDirector = solverPhaseScope.getScoreDirector();
                scoreDirector.beforeEntityRemoved(planningEntity);
                this.planningEntityDescriptor.uninitialize(planningEntity);
                scoreDirector.afterEntityRemoved(planningEntity);
                continue;
            }
            it.remove();
        }
        switch (this.selectionOrder) {
            case ORIGINAL: {
                break;
            }
            case RANDOM: {
                Collections.shuffle(workingPlanningEntityList, solverPhaseScope.getWorkingRandom());
                break;
            }
            case DECREASING_DIFFICULTY: {
                PlanningEntitySorter planningEntitySorter = this.planningEntityDescriptor.getPlanningEntitySorter();
                planningEntitySorter.sortDifficultyDescending(solverPhaseScope.getWorkingSolution(), workingPlanningEntityList);
                break;
            }
            default: {
                throw new IllegalStateException("The selectionOrder (" + (Object)((Object)this.selectionOrder) + ") is not implemented");
            }
        }
        this.selectedPlanningEntityList = workingPlanningEntityList;
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope solverPhaseScope) {
        this.selectedPlanningEntityList = null;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.selectedPlanningEntityList.iterator();
    }
}

