/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.variable;

import java.util.Iterator;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.variable.PlanningValueSelector;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.move.generic.GenericChainedChangeMove;
import org.drools.planner.core.move.generic.GenericChangeMove;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListener;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.score.director.ScoreDirector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanningValueWalker
implements SolverPhaseLifecycleListener {
    private final PlanningVariableDescriptor planningVariableDescriptor;
    private final PlanningValueSelector planningValueSelector;
    private ScoreDirector scoreDirector;
    private Object planningEntity;
    private Iterator<?> planningValueIterator;
    private boolean isFirstValue;
    private Object workingValue;

    public PlanningValueWalker(PlanningVariableDescriptor planningVariableDescriptor, PlanningValueSelector planningValueSelector) {
        this.planningVariableDescriptor = planningVariableDescriptor;
        this.planningValueSelector = planningValueSelector;
    }

    public PlanningVariableDescriptor getPlanningVariableDescriptor() {
        return this.planningVariableDescriptor;
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope solverPhaseScope) {
        this.planningValueSelector.phaseStarted(solverPhaseScope);
        this.scoreDirector = solverPhaseScope.getScoreDirector();
    }

    @Override
    public void beforeDeciding(AbstractStepScope stepScope) {
        this.planningValueSelector.beforeDeciding(stepScope);
    }

    @Override
    public void stepTaken(AbstractStepScope stepScope) {
        this.planningValueSelector.stepTaken(stepScope);
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope solverPhaseScope) {
        this.planningValueSelector.phaseEnded(solverPhaseScope);
        this.scoreDirector = null;
        this.planningEntity = null;
        this.isFirstValue = false;
        this.workingValue = null;
    }

    public void initWalk(Object planningEntity) {
        this.planningEntity = planningEntity;
        this.planningValueIterator = this.planningValueSelector.iterator(planningEntity);
        if (!this.planningValueIterator.hasNext()) {
            throw new IllegalStateException("The planningEntity (" + planningEntity + ") has a planning variable (" + this.planningVariableDescriptor.getVariableName() + ") which has no planning values.");
        }
        Object value = this.planningValueIterator.next();
        this.planningVariableDescriptor.setValue(planningEntity, value);
        this.isFirstValue = true;
        this.workingValue = value;
    }

    public boolean hasWalk() {
        if (this.isFirstValue) {
            return true;
        }
        return this.planningValueIterator.hasNext();
    }

    public void walk() {
        if (this.isFirstValue) {
            this.isFirstValue = false;
        } else {
            Object value = this.planningValueIterator.next();
            this.changeWorkingValue(value);
        }
    }

    public void resetWalk() {
        this.planningValueIterator = this.planningValueSelector.iterator(this.planningEntity);
        Object value = this.planningValueIterator.next();
        this.changeWorkingValue(value);
        this.workingValue = value;
    }

    private void changeWorkingValue(Object value) {
        this.scoreDirector.beforeVariableChanged(this.planningEntity, this.planningVariableDescriptor.getVariableName());
        this.planningVariableDescriptor.setValue(this.planningEntity, value);
        this.scoreDirector.afterVariableChanged(this.planningEntity, this.planningVariableDescriptor.getVariableName());
        this.workingValue = value;
    }

    public Iterator<Move> moveIterator(Object planningEntity) {
        Iterator<?> planningValueIterator = this.planningValueSelector.iterator(planningEntity);
        if (!this.planningVariableDescriptor.isChained()) {
            return new ChangeMoveIterator(planningValueIterator, planningEntity);
        }
        Object oldTrailingEntity = this.findTrailingEntity(planningEntity);
        return new ChainedChangeMoveIterator(planningValueIterator, planningEntity, oldTrailingEntity);
    }

    private Object findTrailingEntity(Object planningEntity) {
        Object trailingEntity = null;
        PlanningEntityDescriptor entityDescriptor = this.planningVariableDescriptor.getPlanningEntityDescriptor();
        for (Object suspectedTrailingEntity : entityDescriptor.extractEntities(this.scoreDirector.getWorkingSolution())) {
            if (this.planningVariableDescriptor.getValue(suspectedTrailingEntity) != planningEntity) continue;
            if (trailingEntity != null) {
                throw new IllegalStateException("The planningEntity (" + planningEntity + ") has multiple trailing entities (" + trailingEntity + ") (" + suspectedTrailingEntity + ") pointing to it for chained planningVariable (" + this.planningVariableDescriptor.getVariableName() + ").");
            }
            trailingEntity = suspectedTrailingEntity;
        }
        return trailingEntity;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChainedChangeMoveIterator
    extends ChangeMoveIterator {
        private final Object oldTrailingEntity;

        public ChainedChangeMoveIterator(Iterator<?> planningValueIterator, Object planningEntity, Object oldTrailingEntity) {
            super(planningValueIterator, planningEntity);
            this.oldTrailingEntity = oldTrailingEntity;
        }

        @Override
        public Move next() {
            Object toPlanningValue = this.planningValueIterator.next();
            Object newTrailingEntity = PlanningValueWalker.this.findTrailingEntity(toPlanningValue);
            return new GenericChainedChangeMove(this.planningEntity, PlanningValueWalker.this.planningVariableDescriptor, toPlanningValue, this.oldTrailingEntity, newTrailingEntity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChangeMoveIterator
    implements Iterator<Move> {
        protected final Iterator<?> planningValueIterator;
        protected final Object planningEntity;

        public ChangeMoveIterator(Iterator<?> planningValueIterator, Object planningEntity) {
            this.planningValueIterator = planningValueIterator;
            this.planningEntity = planningEntity;
        }

        @Override
        public boolean hasNext() {
            return this.planningValueIterator.hasNext();
        }

        @Override
        public Move next() {
            Object toPlanningValue = this.planningValueIterator.next();
            return new GenericChangeMove(this.planningEntity, PlanningValueWalker.this.planningVariableDescriptor, toPlanningValue);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

